/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.utils.vct;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.CostCodeCategoryReference;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.PersonPosition;
import com.gridnine.xtrip.common.model.dict.PersonPositionReference;
import com.gridnine.xtrip.common.model.dict.ProfileGroup;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.CostCodeType;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonAddress;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.ProfileKeyContactPerson;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKeyCategory;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptor;
import com.gridnine.xtrip.common.model.system.MetadataValueType;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.model.utils.vct.VctXmlAddress;
import com.gridnine.xtrip.server.model.utils.vct.VctXmlBankAccount;
import com.gridnine.xtrip.server.model.utils.vct.VctXmlContactPerson;
import com.gridnine.xtrip.server.model.utils.vct.VctXmlContract;
import com.gridnine.xtrip.server.model.utils.vct.VctXmlContragent;
import com.gridnine.xtrip.server.model.utils.vct.VctXmlContragentUdid;
import com.gridnine.xtrip.server.model.utils.vct.VctXmlEmailContact;
import com.gridnine.xtrip.server.model.utils.vct.VctXmlHeadContragent;
import com.gridnine.xtrip.server.model.utils.vct.VctXmlPhoneContact;
import com.gridnine.xtrip.server.model.utils.vct.VctXmlUdidType;
import com.gridnine.xtrip.server.model.utils.vct.VctXmlUdidValue;
import com.gridnine.xtrip.server.model.utils.vct.VctXmlWebContact;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VctXmlImportUtil {
    private static final String NODE_OBJECT = "object";
    private static final String NULL_KEY = "NULL_KEY";
    private static final String KEY_CLIENT_ORIGIN = "KEY_ORGANIZATION_CLIENT_ORIGIN";
    private static MetadataKeyDescriptor clientOriginKeyDescriptorContainer;
    private static final String IMPORTER = "importer";
    private static final int MAX_ENTRIES_PER_DOCUMENT = 600;
    private static Map<String, LegalForm> legalFormsMap;
    private static Map<String, PersonPosition> positionsMap;
    private static Map<String, PersonPosition> oldPositions;
    private static Map<String, ProfileGroup> oldGroups;
    private static Map<String, ProfileGroup> newGroups;
    private static Map<String, DictionaryReference<GeoLocation>> citiesReferences;
    private static Map<String, EntityContainer<Organization>> oldOrganizationContainers;
    private static Map<String, EntityContainer<Holding>> oldHoldingContainers;
    private static Map<String, EntityContainer<Person>> oldPersonContainers;
    private static Map<String, EntityContainer<Contract>> oldContractContainers;
    private static Map<String, EntityContainer<SalesPoint>> oldSalesPointContainers;
    private static Map<String, EntityContainer<Person>> newPersonContainers;
    private static Map<String, EntityReference<Holding>> holdingReferences;
    private static Map<String, CostCodeCategory> oldCostCodeCategories;
    private static Map<String, MetadataKeyDescriptor> oldMetadataKeyDescriptors;
    public static Map<String, EntityContainer<Organization>> newOrganizationContainers;
    public static List<EntityContainer<? extends BaseEntity>> newHoldingContainers;
    public static Map<String, String> holdingNamesMap;
    public static Map<String, String> udidNamesMap;
    public static Map<String, String> afsNamesMap;
    public static Set<String> otherUdidNamesSet;
    public static Map<String, Set<String>> payersMap;
    private static Map<String, EntityContainer<Contract>> newContractContainers;
    private static Map<String, EntityContainer<SalesPoint>> newSalesPointContainers;
    private static final Map<String, DictionaryReference<CostCodeCategory>> costCodeCategoryReferences;
    public static final List<BaseDictionary> newDictionaryContainers;
    public static CostCodeCategory clientOriginUdidCategory;
    public static final String clientOriginUdidCategoryName = "CLIENT ORIGIN";
    private static Set<String> udidsNotFound;
    public static final Pattern patternExtensionNumber;
    public static final Pattern patternName;
    public static final Pattern patternCity1;
    public static final Pattern patternCity2;
    public static final Pattern patternCityGeneral;

    private static Map<String, LegalForm> getLegalForms() {
        if (legalFormsMap == null) {
            legalFormsMap = DictionaryCache.get().getAll(LegalForm.class);
        }
        return legalFormsMap;
    }

    private static Map<String, PersonPosition> getPersonPositions() {
        if (positionsMap == null) {
            positionsMap = DictionaryCache.get().getAll(PersonPosition.class);
        }
        return positionsMap;
    }

    public static List<BaseEntity> getContainersFromXml(Document doc) throws Exception {
        ArrayList<BaseEntity> res = new ArrayList<BaseEntity>();
        Element docEle = doc.getDocumentElement();
        NodeList containers = docEle.getElementsByTagName(NODE_OBJECT);
        if (containers != null && containers.getLength() > 0) {
            for (int i = 0; i < containers.getLength(); ++i) {
                Node node = containers.item(i);
                if (node.getNodeType() != 1) continue;
                Element elm = (Element)node;
                String className = elm.getAttribute("class");
                if (className.contains("EntityContainer")) {
                    String typeClass = XHelper.readString((Element)elm, (String)"entityType");
                    Class<?> cls = Class.forName(typeClass);
                    EntityContainer etc = (EntityContainer)EntityContainer.class.getConstructor(Class.class).newInstance(cls);
                    etc.fromXML(elm);
                    res.add((BaseEntity)etc);
                    continue;
                }
                Class<?> cls = Class.forName(className);
                BaseDictionary dictionary = (BaseDictionary)cls.newInstance();
                dictionary.fromXML(elm);
                res.add((BaseEntity)dictionary);
            }
        }
        return res;
    }

    public static Document getSourceDocument(File file) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        return document;
    }

    public static String toString(Node node) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Transformer transformer = XUtil.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.transform(new DOMSource(node), new StreamResult(baos));
        return baos.toString("utf-8");
    }

    public static void readUdidAndAFSMapping(String fileName, List<Message> messages) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            while ((line = br.readLine()) != null) {
                String[] parts = line.split("\\|");
                if ("AFS".equals(parts[1].trim())) {
                    afsNamesMap.put(parts[0].trim(), parts[2].trim());
                    continue;
                }
                if ("UDID".equals(parts[1].trim())) {
                    udidNamesMap.put(parts[0].trim(), parts[2].trim());
                    continue;
                }
                otherUdidNamesSet.add(parts[0].trim());
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void arrangeOldContainers(List<BaseEntity> containers, List<Message> messages) {
        int numOrg = 0;
        int numHold = 0;
        int numPers = 0;
        int numSP = 0;
        int numCtr = 0;
        int numOther = 0;
        for (BaseEntity base : containers) {
            String name;
            if (base instanceof EntityContainer) {
                String key;
                Person per;
                String key2;
                if (((EntityContainer)base).getEntity() instanceof Organization) {
                    Organization org = (Organization)((EntityContainer)base).getEntity();
                    if (org == null) continue;
                    String string = key2 = !TextUtil.isBlank((String)org.getCode()) ? org.getCode() : NULL_KEY;
                    if (oldOrganizationContainers.containsKey(key2) && !key2.equals(NULL_KEY)) {
                        messages.add(MessageHelper.createErrorMessage((String)("\u0412\u043e \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0439 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0441 DK = " + key2 + ", \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 = " + org.getShortName()), (Object[])null));
                    }
                    if (!key2.equals(NULL_KEY) && !oldOrganizationContainers.containsKey(key2)) {
                        oldOrganizationContainers.put(key2, (EntityContainer<Organization>)((EntityContainer)base));
                    }
                    ++numOrg;
                    continue;
                }
                if (((EntityContainer)base).getEntity() instanceof Holding) {
                    Holding hold = (Holding)((EntityContainer)base).getEntity();
                    if (hold == null) continue;
                    String string = key2 = !TextUtil.isBlank((String)hold.getCode()) ? hold.getCode() : NULL_KEY;
                    if (oldHoldingContainers.containsKey(key2) && !key2.equals(NULL_KEY)) {
                        messages.add(MessageHelper.createErrorMessage((String)("\u0412\u043e \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u0445\u043e\u043b\u0434\u0438\u043d\u0433\u0430 \u0441 DK = " + key2 + ", \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 = " + hold.getShortName()), (Object[])null));
                    }
                    if (!key2.equals(NULL_KEY) && !oldHoldingContainers.containsKey(key2)) {
                        oldHoldingContainers.put(key2, (EntityContainer<Holding>)((EntityContainer)base));
                    }
                    ++numHold;
                    continue;
                }
                if (((EntityContainer)base).getEntity() instanceof SalesPoint) {
                    SalesPoint sp = (SalesPoint)((EntityContainer)base).getEntity();
                    if (sp == null) continue;
                    String string = key2 = !TextUtil.isBlank((String)sp.getShortName()) ? sp.getShortName() : NULL_KEY;
                    if (oldSalesPointContainers.containsKey(key2) && !key2.equals(NULL_KEY)) {
                        messages.add(MessageHelper.createErrorMessage((String)("\u0412\u043e \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0439 \u0442\u043e\u0447\u043a\u0438 \u043f\u0440\u043e\u0434\u0430\u0436 \u0441 \u043a\u043e\u0434\u043e\u043c = " + key2 + ", \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 = " + sp.getCode()), (Object[])null));
                    }
                    if (!key2.equals(NULL_KEY) && !oldSalesPointContainers.containsKey(key2)) {
                        oldSalesPointContainers.put(key2, (EntityContainer<SalesPoint>)((EntityContainer)base));
                    }
                    ++numSP;
                    continue;
                }
                if (((EntityContainer)base).getEntity() instanceof Contract) {
                    Contract ctr = (Contract)((EntityContainer)base).getEntity();
                    if (ctr == null) continue;
                    String string = key2 = !TextUtil.isBlank((String)ctr.getName()) ? ctr.getName() : NULL_KEY;
                    if (oldContractContainers.containsKey(key2) && !key2.equals(NULL_KEY)) {
                        messages.add(MessageHelper.createErrorMessage((String)("\u0412\u043e \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c = " + key2 + ", \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 = " + ctr.getName()), (Object[])null));
                    }
                    if (!key2.equals(NULL_KEY) && !oldContractContainers.containsKey(key2)) {
                        oldContractContainers.put(key2, (EntityContainer<Contract>)((EntityContainer)base));
                    }
                    ++numCtr;
                    continue;
                }
                if (!(((EntityContainer)base).getEntity() instanceof Person) || (per = (Person)((EntityContainer)base).getEntity()) == null) continue;
                String orgCaption = "";
                for (PersonEmployment pe : per.getEmployments()) {
                    if (pe.getOrganization() == null) continue;
                    orgCaption = pe.getOrganization().getCaption();
                    break;
                }
                if (oldPersonContainers.containsKey(key = VctXmlImportUtil.getKeyForPerson(per, orgCaption)) && !key.equals(NULL_KEY)) {
                    messages.add(MessageHelper.createErrorMessage((String)("\u0412\u043e \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0439 \u043f\u0435\u0440\u0441\u043e\u043d\u044b \u0441 \u043a\u043b\u044e\u0447\u043e\u043c = " + key), (Object[])null));
                }
                if (!key.equals(NULL_KEY) && !oldPersonContainers.containsKey(key)) {
                    oldPersonContainers.put(key, (EntityContainer<Person>)((EntityContainer)base));
                }
                ++numPers;
                continue;
            }
            if (!(base instanceof BaseDictionary)) continue;
            if (base instanceof CostCodeCategory) {
                CostCodeCategory cat = (CostCodeCategory)base;
                if (TextUtil.isSame((String)cat.getName(), (String)clientOriginUdidCategoryName)) {
                    oldCostCodeCategories.put(clientOriginUdidCategoryName, cat);
                }
            } else if (base instanceof PersonPosition) {
                PersonPosition pp = (PersonPosition)base;
                name = pp.getTranslations().containsKey(LocaleUtil.LOCALE_RU) ? (String)pp.getTranslations().get(LocaleUtil.LOCALE_RU) : (String)pp.getTranslations().values().iterator().next();
                oldPositions.put(name, pp);
            } else if (base instanceof ProfileGroup) {
                ProfileGroup pg = (ProfileGroup)base;
                name = pg.getTranslations().containsKey(LocaleUtil.LOCALE_RU) ? (String)pg.getTranslations().get(LocaleUtil.LOCALE_RU) : (String)pg.getTranslations().values().iterator().next();
                oldGroups.put(name, pg);
            } else if (base instanceof MetadataKeyDescriptor) {
                MetadataKeyDescriptor mkd = (MetadataKeyDescriptor)base;
                name = mkd.getTranslations().containsKey(LocaleUtil.LOCALE_RU) ? (String)mkd.getTranslations().get(LocaleUtil.LOCALE_RU) : (String)mkd.getTranslations().values().iterator().next();
                oldMetadataKeyDescriptors.put(name, mkd);
            }
            ++numOther;
        }
    }

    public static List<Document> convert(Document sourceDocument, Document udidDocument, List<BaseEntity> containers, List<Message> messages) throws Exception {
        List<Document> res = new ArrayList<Document>();
        if (sourceDocument == null || sourceDocument.getChildNodes().getLength() == 0) {
            messages.add(MessageHelper.createErrorMessage((String)"No nodes in XML!", (Object[])null));
            return res;
        }
        if (udidDocument == null || udidDocument.getChildNodes().getLength() == 0) {
            messages.add(MessageHelper.createErrorMessage((String)"No nodes in Udid XML!", (Object[])null));
            return res;
        }
        Node rootNode = sourceDocument.getChildNodes().item(0);
        ArrayList contragents = new ArrayList();
        XHelper.addListElements((Element)((Element)rootNode), (String)"\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442", contragents, VctXmlContragent.class);
        rootNode = udidDocument.getChildNodes().item(0);
        ArrayList contragentUdids = new ArrayList();
        XHelper.addListElements((Element)((Element)rootNode), (String)"\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442", contragentUdids, VctXmlContragentUdid.class);
        VctXmlImportUtil.arrangeOldContainers(containers, messages);
        HashMap<String, VctXmlContragent> contragentsMap = new HashMap<String, VctXmlContragent>();
        HashSet<String> dkSet = new HashSet<String>();
        for (Object ctr : contragents) {
            String dkNumber = ((VctXmlContragent)ctr).getContragentCode();
            if (TextUtil.isBlank((String)dkNumber)) {
                messages.add(MessageHelper.createErrorMessage((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d DKnumber ", (Object[])null));
                continue;
            }
            if (dkSet.contains(dkNumber)) {
                messages.add(MessageHelper.createErrorMessage((String)("Duplicate DKnumber: " + dkNumber), (Object[])null));
            } else {
                dkSet.add(dkNumber);
            }
            contragentsMap.put(dkNumber, (VctXmlContragent)ctr);
        }
        HashMap<String, VctXmlContragentUdid> contragentUdidsMap = new HashMap<String, VctXmlContragentUdid>();
        dkSet.clear();
        for (VctXmlContragentUdid ctr : contragentUdids) {
            String dkNumber = ctr.getContragentCode();
            if (TextUtil.isBlank((String)dkNumber)) {
                messages.add(MessageHelper.createErrorMessage((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d DKnumber ", (Object[])null));
                continue;
            }
            if (dkSet.contains(dkNumber)) {
                messages.add(MessageHelper.createErrorMessage((String)("Duplicate DKnumber: " + dkNumber), (Object[])null));
            } else {
                dkSet.add(dkNumber);
            }
            contragentUdidsMap.put(dkNumber, ctr);
        }
        try {
            VctXmlImportUtil.createEntities(contragentsMap, contragentUdidsMap, messages);
        }
        catch (Exception e) {
            messages.add(MessageHelper.createErrorMessage((String)("Exception happened: " + Arrays.toString(e.getStackTrace())), (Object[])new Object[0]));
            e.printStackTrace();
        }
        res = VctXmlImportUtil.createResultDocuments();
        return res;
    }

    private static List<Document> createResultDocuments() throws Exception {
        ArrayList<Document> convertDocuments = new ArrayList<Document>();
        Document convertDocument = null;
        Node element = null;
        int count = 0;
        ArrayList<Object> resultList = new ArrayList<Object>();
        resultList.addAll(newHoldingContainers);
        resultList.addAll(newOrganizationContainers.values());
        resultList.addAll(newPersonContainers.values());
        resultList.addAll(newContractContainers.values());
        resultList.addAll(newSalesPointContainers.values());
        resultList.addAll(newDictionaryContainers);
        for (BaseEntity baseEntity : resultList) {
            if (count % 600 == 0) {
                count = 0;
                convertDocument = DocumentBuilderHelper.newDocument();
                convertDocuments.add(convertDocument);
                element = convertDocument.createElementNS(null, "objects");
                convertDocument.appendChild(element);
            }
            Element entityElement = null;
            if (baseEntity instanceof EntityContainer) {
                entityElement = VctXmlImportUtil.createEntityContainerElement(convertDocument, baseEntity);
            } else if (baseEntity instanceof BaseDictionary) {
                entityElement = VctXmlImportUtil.createDictionatyContainerElement(convertDocument, (BaseDictionary)baseEntity);
            }
            element.appendChild(entityElement);
            element.setAttribute("totalCount", String.valueOf(count + 1));
            ++count;
        }
        return convertDocuments;
    }

    private static <T extends BaseEntity> Element createEntityContainerElement(Document convertDocument, BaseEntity entityContainer) throws Exception {
        Element entityContainerElement = convertDocument.createElementNS(null, NODE_OBJECT);
        entityContainerElement.setAttribute("class", EntityContainer.class.getName());
        entityContainer.toXML(entityContainerElement);
        return entityContainerElement;
    }

    private static void createEntities(Map<String, VctXmlContragent> contragentsMap, Map<String, VctXmlContragentUdid> contragentUdidsMap, List<Message> messages) throws Exception {
        if (oldCostCodeCategories.containsKey(clientOriginUdidCategoryName)) {
            clientOriginUdidCategory = oldCostCodeCategories.get(clientOriginUdidCategoryName);
        } else {
            clientOriginUdidCategory = VctXmlImportUtil.createDictionaryContainer(CostCodeCategory.class, UUIDGenerator.generate().toString());
            clientOriginUdidCategory.setName(clientOriginUdidCategoryName);
            clientOriginUdidCategory.setShortName(clientOriginUdidCategoryName);
            clientOriginUdidCategory.getTranslations().put(LocaleUtil.LOCALE_EN, clientOriginUdidCategoryName.toUpperCase());
            clientOriginUdidCategory.getTranslations().put(LocaleUtil.LOCALE_RU, clientOriginUdidCategoryName.toUpperCase());
            newDictionaryContainers.add((BaseDictionary)clientOriginUdidCategory);
            clientOriginUdidCategory.setDataSource("vct-xml-import-util");
            DictionaryStorage.get().save((BaseDictionary)clientOriginUdidCategory);
        }
        if (oldMetadataKeyDescriptors.containsKey(clientOriginUdidCategoryName)) {
            clientOriginKeyDescriptorContainer = oldMetadataKeyDescriptors.get(clientOriginUdidCategoryName);
        } else {
            clientOriginKeyDescriptorContainer = VctXmlImportUtil.createDictionaryContainer(MetadataKeyDescriptor.class, KEY_CLIENT_ORIGIN);
            clientOriginKeyDescriptorContainer.setCategory(MetadataKeyCategory.ORGANIZATION);
            clientOriginKeyDescriptorContainer.setValueType(MetadataValueType.STRING);
            clientOriginKeyDescriptorContainer.setPredefined(false);
            clientOriginKeyDescriptorContainer.getTranslations().put(LocaleUtil.LOCALE_EN, clientOriginUdidCategoryName);
            clientOriginKeyDescriptorContainer.getTranslations().put(LocaleUtil.LOCALE_RU, clientOriginUdidCategoryName);
        }
        newDictionaryContainers.add((BaseDictionary)clientOriginKeyDescriptorContainer);
        HashSet<String> headContragents = new HashSet<String>();
        HashSet<String> holdingCodes = new HashSet<String>();
        for (VctXmlContragent vctXmlContragent : contragentsMap.values()) {
            if (TextUtil.isBlank((String)vctXmlContragent.getHeadContragent())) continue;
            if (!headContragents.contains(vctXmlContragent.getHeadContragent())) {
                headContragents.add(vctXmlContragent.getHeadContragent());
                continue;
            }
            if (!contragentsMap.containsKey(vctXmlContragent.getHeadContragent())) continue;
            holdingCodes.add(vctXmlContragent.getHeadContragent());
        }
        for (String string : holdingCodes) {
            VctXmlContragent contragent = contragentsMap.get(string);
            String dkNumber = contragent.getContragentCode() + "0";
            EntityContainer<Holding> holdCont = null;
            Holding hold = null;
            if (oldHoldingContainers.containsKey(dkNumber)) {
                holdCont = oldHoldingContainers.get(dkNumber);
                if (holdCont != null) {
                    hold = (Holding)holdCont.getEntity();
                    VctXmlImportUtil.clearAllHoldingData(hold);
                }
            } else {
                holdCont = VctXmlImportUtil.createEntityContainer(Holding.class, UUIDGenerator.generate().toString());
                if (holdCont != null) {
                    hold = (Holding)holdCont.getEntity();
                }
            }
            VctXmlImportUtil.createHolding(hold, contragent, messages);
            newHoldingContainers.add(holdCont);
            holdingReferences.put(contragent.getHeadContragent(), (EntityReference<Holding>)holdCont.toReference());
            holdingNamesMap.put(contragent.getHeadContragent(), contragent.getName());
        }
        for (Map.Entry entry : contragentsMap.entrySet()) {
            String key = (String)entry.getKey();
            VctXmlContragent contragent = (VctXmlContragent)entry.getValue();
            EntityContainer<Organization> orgCont = null;
            String dkNumber = contragent.getContragentCode() + "0";
            Organization org = null;
            if (oldOrganizationContainers.containsKey(dkNumber)) {
                orgCont = oldOrganizationContainers.get(dkNumber);
                if (orgCont != null) {
                    org = (Organization)orgCont.getEntity();
                    VctXmlImportUtil.clearAllOrganizationData(org);
                }
            } else {
                orgCont = VctXmlImportUtil.createEntityContainer(Organization.class, UUIDGenerator.generate().toString());
                if (orgCont != null) {
                    org = (Organization)orgCont.getEntity();
                }
            }
            VctXmlImportUtil.createOrganization(orgCont, contragent, contragentUdidsMap.get(key), messages);
            newOrganizationContainers.put(contragent.getContragentCode(), orgCont);
        }
        for (EntityContainer entityContainer : newOrganizationContainers.values()) {
            Organization org = (Organization)entityContainer.getEntity();
            if (payersMap.get(org.getCode()) == null) continue;
            for (String payerCode : payersMap.get(org.getCode())) {
                if (newOrganizationContainers.containsKey(payerCode)) {
                    EntityReference payerRef = newOrganizationContainers.get(payerCode).toReference();
                    org.getPayers().add(payerRef);
                    continue;
                }
                messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + org.getCode().substring(0, org.getCode().length() - 1) + ". \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430-\u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c: " + payerCode), (Object[])new Object[0]));
            }
        }
        for (String string : udidsNotFound) {
            messages.add(MessageHelper.createErrorMessage((String)("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0434\u043b\u044f \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u044f \u043a\u043e\u0441\u0442 \u0446\u0435\u043d\u0442\u0440\u0430: " + string), (Object[])new Object[0]));
        }
    }

    private static void createOrganization(EntityContainer<Organization> orgCont, VctXmlContragent contragent, VctXmlContragentUdid udidData, List<Message> messages) throws InstantiationException, IllegalAccessException {
        Organization org = (Organization)orgCont.getEntity();
        org.getTypes().add(OrganizationType.CORPORATE_CLIENT);
        org.setCode(contragent.getContragentCode() + "0");
        L10nStringHelper.setValue((L10nString)org.getShortName(), (String)TextUtil.translit((String)contragent.getName(), (boolean)true), (Locale)LocaleUtil.LOCALE_EN);
        L10nStringHelper.setValue((L10nString)org.getShortName(), (String)contragent.getName(), (Locale)LocaleUtil.LOCALE_RU);
        L10nStringHelper.setValue((L10nString)org.getFullName(), (String)TextUtil.translit((String)contragent.getFullName(), (boolean)true), (Locale)LocaleUtil.LOCALE_EN);
        L10nStringHelper.setValue((L10nString)org.getFullName(), (String)contragent.getFullName(), (Locale)LocaleUtil.LOCALE_RU);
        if (!TextUtil.isBlank((String)contragent.getLegalForm())) {
            org.setLegalForm(VctXmlImportUtil.getLegalForm(org.getShortName().toString(), contragent.getLegalForm(), messages));
        }
        if (!TextUtil.isBlank((String)contragent.getHeadContragent())) {
            org.setHolding(holdingReferences.get(contragent.getHeadContragent()));
        }
        HashSet<String> payers = new HashSet<String>();
        for (VctXmlHeadContragent head : contragent.getHeadContragentTorg12List()) {
            if (TextUtil.isBlank((String)head.getContragentCode()) || TextUtil.isSame((String)head.getContragentCode(), (String)contragent.getContragentCode())) continue;
            payers.add(head.getContragentCode());
        }
        for (VctXmlHeadContragent head : contragent.getHeadContragentInvoiceList()) {
            if (TextUtil.isBlank((String)head.getContragentCode()) || TextUtil.isSame((String)head.getContragentCode(), (String)contragent.getContragentCode())) continue;
            payers.add(head.getContragentCode());
        }
        for (VctXmlHeadContragent head : contragent.getHeadContragentInvoiceFacturaList()) {
            if (TextUtil.isBlank((String)head.getContragentCode()) || TextUtil.isSame((String)head.getContragentCode(), (String)contragent.getContragentCode())) continue;
            payers.add(head.getContragentCode());
        }
        if (payers.size() > 0) {
            payersMap.put(org.getCode(), payers);
        }
        org.setForeign(!contragent.isResident());
        for (VctXmlContactPerson person : contragent.getContactPersons()) {
            EntityContainer<Person> perCont;
            Person per;
            String personKey;
            if (TextUtil.isBlank((String)person.getContactPersonName())) continue;
            Matcher m = patternName.matcher(person.getContactPersonName());
            if (!m.matches()) {
                messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragent.getContragentCode() + ". \u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430: " + person.getContactPersonName()), (Object[])new Object[0]));
            }
            if (newPersonContainers.containsKey(personKey = VctXmlImportUtil.getKeyForPerson(per = (Person)(perCont = VctXmlImportUtil.createPersonContainer(person.getContactPersonName())).getEntity(), orgCont.toReference() != null ? orgCont.toReference().toString() : ""))) {
                perCont = newPersonContainers.get(personKey);
                messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragent.getContragentCode() + ". \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u0449\u0435\u0435\u0441\u044f \u0438\u043c\u044f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430: " + person.getContactPersonName()), (Object[])new Object[0]));
                continue;
            }
            if (oldPersonContainers.containsKey(personKey) && (perCont = oldPersonContainers.get(personKey)) != null) {
                per = (Person)perCont.getEntity();
                VctXmlImportUtil.clearAllPersonData(per);
            }
            VctXmlImportUtil.createPerson(per, person, (EntityReference<Organization>)orgCont.toReference(), contragent.getContragentCode(), messages);
            newPersonContainers.put(personKey, perCont);
            ProfileKeyContactPerson keyContactPerson = new ProfileKeyContactPerson();
            keyContactPerson.setPerson(perCont.toReference());
            org.getKeyContacts().add(keyContactPerson);
        }
        org.setKpp(contragent.getKpp());
        org.setRegistrationId(contragent.getInn());
        if (contragent.getLegalAddress() != null) {
            org.getAddresses().add(VctXmlImportUtil.createAddress(contragent.getContragentCode(), contragent.getLegalAddress(), AddressType.LEGAL, messages, Address.class));
        }
        if (contragent.getFactualAddress() != null) {
            org.getAddresses().add(VctXmlImportUtil.createAddress(contragent.getContragentCode(), contragent.getFactualAddress(), AddressType.FACTUAL, messages, Address.class));
        }
        for (VctXmlPhoneContact phone : contragent.getPhones()) {
            if (phone == null) continue;
            org.getCommunications().add(VctXmlImportUtil.createPhoneCommunication(phone, messages, null, Communication.class));
        }
        for (VctXmlPhoneContact phone : contragent.getPhones()) {
            if (phone == null) continue;
            org.getCommunications().add(VctXmlImportUtil.createPhoneCommunication(phone, messages, CommunicationType.FAX, Communication.class));
        }
        if (!TextUtil.isBlank((String)contragent.getAdditionalDescription())) {
            Metadata m = new Metadata();
            m.setKey((DictionaryReference)clientOriginKeyDescriptorContainer.toReference());
            m.setValue((Object)contragent.getAdditionalDescription());
            org.getMetadata().add(m);
        }
        org.setNotes(contragent.getComment());
        for (VctXmlBankAccount account : contragent.getAccounts()) {
            if (TextUtil.isBlank((String)account.getCorrAccount()) && TextUtil.isBlank((String)account.getBik())) continue;
            BankAccount ba = new BankAccount();
            ba.setBankName(account.getBank());
            ba.setBik(account.getBik());
            ba.setCorrespondentAccount(account.getCorrAccount());
            if (!TextUtil.isBlank((String)account.getCity())) {
                String cityStr = VctXmlImportUtil.clearCityName(account.getCity());
                Iterator<VctXmlContract> cityRef = citiesReferences.get(cityStr.toLowerCase());
                if (cityRef == null) {
                    messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragent.getContragentCode() + " \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0433\u043e\u0440\u043e\u0434 \u0434\u043b\u044f \u0431\u0430\u043d\u043a\u0430: " + account.getCity()), (Object[])new Object[0]));
                } else {
                    ba.setCity(cityRef);
                }
            }
            boolean found = false;
            for (BankAccount acc : org.getBankAccounts()) {
                if (!TextUtil.isSame((String)acc.getCorrespondentAccount(), (String)ba.getCorrespondentAccount()) || !TextUtil.isSame((String)acc.getBankName(), (String)ba.getBankName()) || !TextUtil.isSame((String)acc.getBik(), (String)ba.getBik()) || (ba.getCity() != null || acc.getCity() != null) && (ba.getCity() == null || !ba.getCity().equals((Object)acc.getCity()))) continue;
                found = true;
                break;
            }
            if (found) continue;
            org.getBankAccounts().add(ba);
        }
        VctXmlContract contract = null;
        int numContractsVIP = 0;
        int numContractsVKT = 0;
        String orgCode = null;
        for (VctXmlContract ctr : contragent.getContracts()) {
            if (TextUtil.isBlank((String)ctr.getOrganization())) continue;
            if (ctr.getOrganization().contains("\u041a\u043e\u0440\u043f\u043e\u0440\u0435\u0439\u0442 \u0422\u0440\u0435\u0432\u0435\u043b")) {
                orgCode = "\u0412\u041a\u0422";
                if (contract == null) {
                    contract = ctr;
                }
                ++numContractsVKT;
                continue;
            }
            if (ctr.getOrganization().contains("\u0412.\u0418.\u041f. \u0421\u0435\u0440\u0432\u0438\u0441")) {
                orgCode = "\u041d\u041e\u0412\u0410\u042f_\u0411\u0410\u0421\u041c\u0410\u041d";
                contract = ctr;
                ++numContractsVIP;
                continue;
            }
            messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragent.getContragentCode() + ". \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043d\u0435\u0443\u0447\u0442\u0435\u043d\u043d\u0430\u044f \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435: " + ctr.getOrganization()), (Object[])new Object[0]));
        }
        if (contract == null) {
            messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragent.getContragentCode() + ". \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: "), (Object[])new Object[0]));
        } else if (numContractsVIP > 1) {
            messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragent.getContragentCode() + ". \u041d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u0412\u0418\u041f: " + contract.getOrganization()), (Object[])new Object[0]));
            contract = null;
        } else if (numContractsVKT > 1 && numContractsVIP != 1) {
            messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragent.getContragentCode() + ". \u041d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u0412\u041a\u0422: " + contract.getOrganization()), (Object[])new Object[0]));
            contract = null;
        }
        if (contract != null) {
            Iterator<VctXmlUdidType> ctrCont = null;
            String keyForContract = null;
            String nameForContract = null;
            if (holdingReferences.containsKey(contragent.getHeadContragent())) {
                keyForContract = contragent.getHeadContragent();
                nameForContract = holdingNamesMap.get(contragent.getHeadContragent());
            } else {
                keyForContract = contragent.getContragentCode();
                nameForContract = contragent.getName();
            }
            nameForContract = "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 " + nameForContract;
            Contract ctr = null;
            EntityReference agencyRef = null;
            if (orgCode != null) {
                EntityContainer<Organization> orgCtrCont = oldOrganizationContainers.get(orgCode);
                if (orgCtrCont == null) {
                    messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragent.getContragentCode() + ". \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u043e \u043a\u043e\u0434\u0443: " + orgCode), (Object[])new Object[0]));
                } else {
                    org.setParent(orgCtrCont.toReference());
                    agencyRef = orgCtrCont.toReference();
                }
            }
            if ((ctrCont = newContractContainers.get(keyForContract)) == null) {
                ctrCont = oldContractContainers.get(nameForContract);
                if (ctrCont != null) {
                    VctXmlImportUtil.clearAllContractData((Contract)ctrCont.getEntity());
                } else {
                    try {
                        ctrCont = VctXmlImportUtil.createEntityContainer(Contract.class, UUIDGenerator.generate().toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (ctrCont != null) {
                    ctr = (Contract)ctrCont.getEntity();
                    VctXmlImportUtil.createContract(ctr, contract, nameForContract, (EntityReference<Organization>)agencyRef, messages);
                }
            } else {
                ctr = (Contract)ctrCont.getEntity();
            }
            VctXmlImportUtil.addClientToContract(ctr, contract, (EntityReference<Organization>)orgCont.toReference(), messages);
            newContractContainers.put(keyForContract, (EntityContainer<Contract>)ctrCont);
            if (!TextUtil.isBlank((String)contract.getOffice())) {
                EntityContainer<SalesPoint> spCont = null;
                if (!newSalesPointContainers.containsKey(contract.getOffice())) {
                    spCont = oldSalesPointContainers.get(contract.getOffice());
                    if (spCont == null) {
                        try {
                            spCont = VctXmlImportUtil.createEntityContainer(SalesPoint.class, UUIDGenerator.generate().toString());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    SalesPoint sp = (SalesPoint)spCont.getEntity();
                    sp.setShortName(contract.getOffice());
                    sp.setFullName(contract.getOffice());
                    newSalesPointContainers.put(contract.getOffice(), spCont);
                } else {
                    spCont = newSalesPointContainers.get(contract.getOffice());
                }
                DictionaryReference<ProfileGroup> pgRef = VctXmlImportUtil.getProfileGroup(contract.getOffice(), messages);
                boolean found = false;
                for (Metadata m : org.getMetadata()) {
                    if (m == null || !TextUtil.isSame((String)m.getKey().getCode(), (String)"KEY_ORGANIZATION_PROFILE_GROUP")) continue;
                    m.setValue(pgRef);
                    found = true;
                    break;
                }
                if (!found) {
                    Metadata m = new Metadata();
                    m.setKey((DictionaryReference)((MetadataKeyDescriptor)DictionaryCache.get().getAll(MetadataKeyDescriptor.class).get("KEY_ORGANIZATION_PROFILE_GROUP")).toReference());
                    m.setValue(pgRef);
                    org.getMetadata().add(m);
                }
            }
        }
        if (udidData != null) {
            for (VctXmlUdidType udidType : udidData.getUdidTypes()) {
                if (TextUtil.isBlank((String)udidType.getName())) {
                    messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragent.getContragentCode() + ". UDID. \u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435\u041a\u043e\u0441\u0442\u0426\u0435\u043d\u0442\u0440\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e"), (Object[])new Object[0]));
                    continue;
                }
                boolean isUdid = false;
                String statName = null;
                if (afsNamesMap.containsKey(udidType.getName())) {
                    statName = afsNamesMap.get(udidType.getName());
                } else if (udidNamesMap.containsKey(udidType.getName())) {
                    isUdid = true;
                    statName = udidNamesMap.get(udidType.getName());
                } else {
                    if (otherUdidNamesSet.contains(udidType.getName())) continue;
                    udidsNotFound.add(udidType.getName());
                    continue;
                }
                if (TextUtil.isSame((String)"NULL", (String)statName, (boolean)true)) continue;
                if (udidType.getType() == null) {
                    messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragent.getContragentCode() + ". UDID. \u0422\u0438\u043f \u043a\u043e\u0441\u0442 \u0446\u0435\u043d\u0442\u0440\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d"), (Object[])new Object[0]));
                    continue;
                }
                if (udidType.getType() == VctXmlUdidType.UdidType.OTHER) {
                    messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragent.getContragentCode() + ". UDID. \u0422\u0438\u043f \u043a\u043e\u0441\u0442 \u0446\u0435\u043d\u0442\u0440\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d"), (Object[])new Object[0]));
                    continue;
                }
                if (isUdid) {
                    CostCodeType ccType = null;
                    if (org.getCostCodeProperties().size() < 9) {
                        ccType = CostCodeType.values()[org.getCostCodeProperties().size()];
                    } else {
                        ccType = CostCodeType.COST_CODE_9;
                        messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragent.getContragentCode() + ". UDID. \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 9 \u0442\u0438\u043f\u043e\u0432 \u044e\u0434\u0438\u0434\u043e\u0432"), (Object[])new Object[0]));
                    }
                    CostCodeProperties ccp = null;
                    boolean costCodePropertiesAlreadyExists = false;
                    for (CostCodeProperties ccpTemp : org.getCostCodeProperties()) {
                        if (!TextUtil.isSame((String)ccpTemp.getName(), (String)statName)) continue;
                        costCodePropertiesAlreadyExists = true;
                        break;
                    }
                    if (costCodePropertiesAlreadyExists) {
                        messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragent.getContragentCode() + ". UDID. \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0438\u0439\u0441\u044f \u0442\u0438\u043f \u044e\u0434\u0438\u0434\u0430: " + statName + " \u0434\u043b\u044f \u0438\u0441\u0445\u043e\u0434\u043d\u043e\u0433\u043e: " + udidType.getName()), (Object[])new Object[0]));
                    }
                    if (ccp == null) {
                        ccp = VctXmlImportUtil.createCostCodeProperties(statName, ccType, null);
                    }
                    org.getCostCodeProperties().add(ccp);
                    if (udidType.getType() != VctXmlUdidType.UdidType.DICTIONARY) continue;
                    if (udidType.getUdidValues().size() == 1) {
                        VctXmlUdidValue udidValue = udidType.getUdidValues().get(0);
                        if (udidValue == null || TextUtil.isBlank((String)udidValue.getValue())) continue;
                        ccp.setSabreValue(udidValue.getValue());
                        continue;
                    }
                    if (udidType.getUdidValues().size() > 1) {
                        ccp.setSabreDropList(true);
                        for (VctXmlUdidValue udidValue : udidType.getUdidValues()) {
                            if (udidValue == null || TextUtil.isBlank((String)udidValue.getValue())) continue;
                            org.getCostCodes().add(VctXmlImportUtil.createCostCode(ccp, udidValue.getValue()));
                        }
                        continue;
                    }
                    messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragent.getContragentCode() + ". UDID. \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u0442\u0438\u043f \u044e\u0434\u0438\u0434\u0430 \"\u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\" \u0431\u0435\u0437 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439: " + udidType.getName()), (Object[])new Object[0]));
                    continue;
                }
                AFSType afsType = null;
                if ("P3D".equals(statName)) {
                    afsType = AFSType.P3D;
                } else if ("HBF2".equals(statName)) {
                    afsType = AFSType.HBF2;
                } else if ("LAF3".equals(statName)) {
                    afsType = AFSType.LAF3;
                } else {
                    messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragent.getContragentCode() + ". UDID.  \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043d\u0435\u0443\u0447\u0442\u0435\u043d\u043d\u044b\u0439 \u0442\u0438\u043f AFS"), (Object[])new Object[0]));
                }
                if (afsType == null) continue;
                String afs = org.getAfsSettings();
                if (afs == null) {
                    afs = "";
                }
                if (!afs.contains(afsType.name())) {
                    if (afs.length() > 0) {
                        afs = afs + "|";
                    }
                    afs = afs + afsType.name();
                }
                org.setAfsSettings(afs);
            }
        }
        if (org.getParent() != null) {
            CreditLimitInfo cli = new CreditLimitInfo();
            cli.setUnlimited(true);
            cli.setCreditor(org.getParent());
            org.getFinanceRestrictions().getCreditLimits().add(cli);
        }
    }

    private static void clearAllContractData(Contract ctr) {
        ctr.setContractType(null);
        ctr.setName(null);
        ctr.setSupplier(null);
        ctr.setVendor(null);
        ctr.getCustomers().clear();
    }

    private static void createContract(Contract ctr, VctXmlContract contract, String nameForContract, EntityReference<Organization> agencyRef, List<Message> messages) {
        ctr.setContractType(ContractType.CLIENT);
        ctr.setSupplier(agencyRef);
        ctr.setName(nameForContract);
    }

    private static void addClientToContract(Contract ctr, VctXmlContract contract, EntityReference<Organization> customer, List<Message> messages) {
        ContractCustomerInfo cci = new ContractCustomerInfo();
        cci.setCustomer(customer);
        cci.setNumber(contract.getContractNumber());
        cci.setIssueDate(contract.getStartDate());
        cci.setStartDate(contract.getStartDate());
        cci.setEndDate(contract.getEndDate());
        String cur = null;
        if (contract.getCurrency() != null) {
            cur = "RUR".equals(contract.getCurrency()) ? "RUB" : contract.getCurrency();
        }
        cci.setPaymentCurrency(cur);
        ctr.getCustomers().add(cci);
    }

    private static void createPerson(Person per, VctXmlContactPerson person, EntityReference<Organization> orgRef, String contragentCode, List<Message> messages) throws InstantiationException, IllegalAccessException {
        PersonEmployment pe = new PersonEmployment();
        pe.setOrganization(orgRef);
        pe.setMainEmployment(true);
        if (!TextUtil.isBlank((String)person.getPosition())) {
            pe.setPosition(VctXmlImportUtil.getPersonPosition(VctXmlImportUtil.getKeyForPerson(per, ""), person.getPosition(), messages));
        }
        if (!TextUtil.isBlank((String)person.getRole())) {
            // empty if block
        }
        per.getEmployments().add(pe);
        per.getTypes().add(PersonType.PASSENGER);
        for (VctXmlAddress addr : person.getContactAddresses()) {
            if (TextUtil.isBlank((String)addr.getAddressView()) && TextUtil.isBlank((String)addr.getStreet())) continue;
            per.getAddresses().add(VctXmlImportUtil.createPersonAddress(contragentCode, addr, orgRef, messages));
        }
        for (VctXmlEmailContact email : person.getContactEmails()) {
            per.getCommunications().add(VctXmlImportUtil.createPersonEmailWebCommunication(email.getAddress(), email.getView(), orgRef, true, messages));
        }
        for (VctXmlWebContact web : person.getContactWebs()) {
            per.getCommunications().add(VctXmlImportUtil.createPersonEmailWebCommunication(web.getAddress(), web.getView(), orgRef, false, messages));
        }
        for (VctXmlPhoneContact phone : person.getContactPhones()) {
            per.getCommunications().add(VctXmlImportUtil.createPersonPhoneCommunication(phone, orgRef, messages));
        }
        per.setNotes(person.getComment());
    }

    private static <T extends Communication> T createPhoneCommunication(VctXmlPhoneContact phone, List<Message> messages, CommunicationType phoneType, Class<T> type) throws InstantiationException, IllegalAccessException {
        Communication res = (Communication)type.newInstance();
        res.setCountryCode(phone.getCountryCode());
        res.setCityCode(phone.getCityCode());
        String number = !TextUtil.isBlank((String)phone.getNumber()) ? phone.getNumber() : "";
        res.setSense(number);
        if (!TextUtil.isBlank((String)phone.getView())) {
            String view = phone.getView();
            Matcher m = patternExtensionNumber.matcher(view);
            if (m.matches() && m.groupCount() > 2) {
                res.setInternalNumber(m.group(3).trim());
                view = m.group(1).trim();
                if (view.endsWith(",")) {
                    view = view.substring(0, view.length() - 1);
                }
            }
            if (TextUtil.isBlank((String)phone.getCountryCode()) && TextUtil.isBlank((String)phone.getCityCode()) && view.length() > number.length() + 2) {
                res.setSense(view);
            }
        }
        if (phoneType != null) {
            res.setType(phoneType);
        } else if (!TextUtil.isBlank((String)phone.getType())) {
            if (phone.getType().toLowerCase().contains("\u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439")) {
                res.setType(CommunicationType.MOBILE);
            } else {
                res.setType(CommunicationType.WORK_PHONE);
            }
        }
        return (T)res;
    }

    private static PersonCommunication createPersonPhoneCommunication(VctXmlPhoneContact phone, EntityReference<Organization> orgRef, List<Message> messages) throws InstantiationException, IllegalAccessException {
        PersonCommunication p = VctXmlImportUtil.createPhoneCommunication(phone, messages, null, PersonCommunication.class);
        p.setOrganization(orgRef);
        return p;
    }

    private static <T extends Communication> T createEmailWebCommunication(String address, String view, boolean isEmail, List<Message> messages, Class<T> type) throws InstantiationException, IllegalAccessException {
        Communication c = (Communication)type.newInstance();
        c.setType(isEmail ? CommunicationType.EMAIL : CommunicationType.WEB);
        c.setSense(!TextUtil.isBlank((String)address) ? address : view);
        return (T)c;
    }

    private static PersonCommunication createPersonEmailWebCommunication(String address, String view, EntityReference<Organization> orgRef, boolean isEmail, List<Message> messages) throws InstantiationException, IllegalAccessException {
        PersonCommunication c = VctXmlImportUtil.createEmailWebCommunication(address, view, isEmail, messages, PersonCommunication.class);
        c.setOrganization(orgRef);
        return c;
    }

    private static <T extends Address> T createAddress(String contragentCode, VctXmlAddress addr, AddressType addressType, List<Message> messages, Class<T> type) throws InstantiationException, IllegalAccessException {
        Address a = (Address)type.newInstance();
        if (!TextUtil.isBlank((String)addr.getCity())) {
            String cityStr = VctXmlImportUtil.clearCityName(addr.getCity());
            DictionaryReference<GeoLocation> cityRef = citiesReferences.get(cityStr.toLowerCase());
            if (cityRef == null) {
                String whosaddress = "\u0432 \u0430\u0434\u0440\u0435\u0441\u0435 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430";
                if (type.equals(PersonAddress.class)) {
                    whosaddress = "\u0432 \u0430\u0434\u0440\u0435\u0441\u0435 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430";
                }
                messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragentCode + ". \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0433\u043e\u0440\u043e\u0434 " + whosaddress + ": " + addr.getCity()), (Object[])new Object[0]));
            } else {
                a.setCity(cityRef);
            }
        }
        if (!TextUtil.isBlank((String)addr.getStreet())) {
            L10nStringHelper.setValue((L10nString)a.getAddress(), (String)addr.getStreet(), (Locale)LocaleUtil.LOCALE_RU);
        }
        if (!TextUtil.isBlank((String)addr.getAddressView())) {
            Matcher mCity = patternCityGeneral.matcher(addr.getAddressView());
            String view = addr.getAddressView();
            String cityName = null;
            if (mCity.matches() && a.getCity() == null && mCity.groupCount() > 3) {
                cityName = mCity.group(3).toLowerCase();
                String before = mCity.group(1).trim();
                String after = mCity.group(4).trim();
                if (before.endsWith(",") && after.startsWith(",")) {
                    before = before.substring(0, before.length() - 1);
                }
                view = before + after;
            } else if (addr.getAddressView().contains("\u041c\u043e\u0441\u043a\u0432\u0430") || addr.getAddressView().contains("\u043c\u043e\u0441\u043a\u0432\u0430")) {
                cityName = "\u043c\u043e\u0441\u043a\u0432\u0430";
                view = addr.getAddressView().replaceAll("[\u041c|\u043c]\u043e\u0441\u043a\u0432\u0430", "");
            } else if (addr.getAddressView().contains("\u0421\u0430\u043d\u043a\u0442-\u041f\u0435\u0442\u0435\u0440\u0431\u0443\u0440\u0433") || addr.getAddressView().contains("\u0441\u0430\u043d\u043a\u0442-\u043f\u0435\u0442\u0435\u0440\u0431\u0443\u0440\u0433")) {
                cityName = "\u0441\u0430\u043d\u043a\u0442-\u043f\u0435\u0442\u0435\u0440\u0431\u0443\u0440\u0433";
                view = addr.getAddressView().replaceAll("[\u0421|\u0441]\u0430\u043d\u043a\u0442\\-[\u041f|\u043f]\u0435\u0442\u0435\u0440\u0431\u0443\u0440\u0433", "");
            }
            if (cityName != null) {
                DictionaryReference<GeoLocation> cityRef = citiesReferences.get(cityName);
                if (cityRef == null) {
                    String whosaddress = "\u0432 \u0430\u0434\u0440\u0435\u0441\u0435 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430 \u0432 \u0442\u0435\u0433\u0435 \u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435";
                    if (type.equals(PersonAddress.class)) {
                        whosaddress = "\u0432 \u0430\u0434\u0440\u0435\u0441\u0435 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430";
                    }
                    messages.add(MessageHelper.createErrorMessage((String)("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442: " + contragentCode + ". \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0433\u043e\u0440\u043e\u0434 " + whosaddress + ": " + cityName), (Object[])new Object[0]));
                } else {
                    a.setCity(cityRef);
                }
            }
            if (TextUtil.isBlank((String)addr.getStreet())) {
                L10nStringHelper.setValue((L10nString)a.getAddress(), (String)view, (Locale)LocaleUtil.LOCALE_RU);
            }
        }
        a.setZip(addr.getZipCode());
        a.setRegion(DictHelper.findGeoRegionByName((String)addr.getRegion()));
        L10nStringHelper.setValue((L10nString)a.getTown(), (String)addr.getTown(), (Locale)LocaleUtil.LOCALE_RU);
        L10nStringHelper.setValue((L10nString)a.getHouse(), (String)addr.getHouse(), (Locale)LocaleUtil.LOCALE_RU);
        L10nStringHelper.setValue((L10nString)a.getDistrict(), (String)addr.getDistrict(), (Locale)LocaleUtil.LOCALE_RU);
        L10nStringHelper.setValue((L10nString)a.getBuilding(), (String)addr.getBuilding(), (Locale)LocaleUtil.LOCALE_RU);
        L10nStringHelper.setValue((L10nString)a.getFlat(), (String)addr.getApartment(), (Locale)LocaleUtil.LOCALE_RU);
        a.setAddressType(addressType);
        return (T)a;
    }

    private static PersonAddress createPersonAddress(String contragentCode, VctXmlAddress addr, EntityReference<Organization> orgRef, List<Message> messages) throws InstantiationException, IllegalAccessException {
        PersonAddress a = VctXmlImportUtil.createAddress(contragentCode, addr, AddressType.BUSINESS, messages, PersonAddress.class);
        a.setOrganization(orgRef);
        return a;
    }

    private static String clearCityName(String city) {
        city = city.trim();
        Matcher m1 = patternCity1.matcher(city);
        Matcher m2 = patternCity2.matcher(city);
        if (m1.matches()) {
            return m1.group(2).trim();
        }
        if (m2.matches()) {
            return m2.group(1).trim();
        }
        return city;
    }

    private static void createHolding(Holding hold, VctXmlContragent contragent, List<Message> messages) throws InstantiationException, IllegalAccessException {
        hold.setCode(contragent.getContragentCode() + "0");
        L10nStringHelper.setValue((L10nString)hold.getShortName(), (String)TextUtil.translit((String)contragent.getName(), (boolean)true), (Locale)LocaleUtil.LOCALE_EN);
        L10nStringHelper.setValue((L10nString)hold.getShortName(), (String)contragent.getName(), (Locale)LocaleUtil.LOCALE_RU);
        L10nStringHelper.setValue((L10nString)hold.getFullName(), (String)TextUtil.translit((String)contragent.getFullName(), (boolean)true), (Locale)LocaleUtil.LOCALE_EN);
        L10nStringHelper.setValue((L10nString)hold.getFullName(), (String)contragent.getFullName(), (Locale)LocaleUtil.LOCALE_RU);
        if (!TextUtil.isBlank((String)contragent.getLegalForm())) {
            hold.setLegalForm(VctXmlImportUtil.getLegalForm(hold.getShortName().toString(), contragent.getLegalForm(), messages));
        }
        hold.setForeign(!contragent.isResident());
        hold.setKpp(contragent.getKpp());
        hold.setRegistrationId(contragent.getInn());
        if (contragent.getLegalAddress() != null) {
            hold.getAddresses().add(VctXmlImportUtil.createAddress(contragent.getContragentCode(), contragent.getLegalAddress(), AddressType.LEGAL, messages, Address.class));
        }
        if (contragent.getFactualAddress() != null) {
            hold.getAddresses().add(VctXmlImportUtil.createAddress(contragent.getContragentCode(), contragent.getFactualAddress(), AddressType.FACTUAL, messages, Address.class));
        }
        for (VctXmlPhoneContact phone : contragent.getPhones()) {
            if (phone == null) continue;
            hold.getCommunications().add(VctXmlImportUtil.createPhoneCommunication(phone, messages, null, Communication.class));
        }
        for (VctXmlPhoneContact phone : contragent.getPhones()) {
            if (phone == null) continue;
            hold.getCommunications().add(VctXmlImportUtil.createPhoneCommunication(phone, messages, CommunicationType.FAX, Communication.class));
        }
        hold.setNotes(contragent.getComment());
    }

    private static DictionaryReference<LegalForm> getLegalForm(String orgName, String value, List<Message> messages) {
        for (Map.Entry<String, LegalForm> entry : VctXmlImportUtil.getLegalForms().entrySet()) {
            LegalForm lf = entry.getValue();
            for (String code : lf.getAbbreviations().values()) {
                if (!TextUtil.isSame((String)code, (String)value, (boolean)true)) continue;
                return lf.toReference();
            }
            for (String code : lf.getTranslations().values()) {
                if (!TextUtil.isSame((String)code, (String)value, (boolean)true)) continue;
                return lf.toReference();
            }
        }
        messages.add(MessageHelper.createWarningMessage((String)("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0424\u043e\u0440\u043c\u0430\u0421\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438: " + value + " \u0434\u043b\u044f " + orgName), (Object[])null));
        try {
            LegalForm newLegalForm = VctXmlImportUtil.createDictionaryContainer(LegalForm.class, UUIDGenerator.generate().toString());
            newLegalForm.getAbbreviations().put(LocaleUtil.LOCALE_RU, value);
            newLegalForm.getTranslations().put(LocaleUtil.LOCALE_RU, value);
            newDictionaryContainers.add((BaseDictionary)newLegalForm);
            newLegalForm.setDataSource("vct-xml-import-util");
            DictionaryStorage.get().save((BaseDictionary)newLegalForm);
            return newLegalForm.toReference();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static DictionaryReference<PersonPosition> getPersonPosition(String perName, String value, List<Message> messages) {
        PersonPosition pos;
        for (Map.Entry<String, PersonPosition> entry : VctXmlImportUtil.getPersonPositions().entrySet()) {
            pos = entry.getValue();
            for (String code : pos.getTranslations().values()) {
                if (!TextUtil.isSame((String)code, (String)value, (boolean)true)) continue;
                PersonPositionReference posRef = pos.toReference();
                posRef.setCaption(value);
                return posRef;
            }
        }
        for (Map.Entry<String, PersonPosition> entry : oldPositions.entrySet()) {
            pos = entry.getValue();
            for (String code : pos.getTranslations().values()) {
                if (!TextUtil.isSame((String)code, (String)value, (boolean)true)) continue;
                PersonPositionReference posRef = pos.toReference();
                posRef.setCaption(value);
                newDictionaryContainers.add((BaseDictionary)pos);
                VctXmlImportUtil.getPersonPositions().put(value, pos);
                return posRef;
            }
        }
        try {
            PersonPosition newPosition = VctXmlImportUtil.createDictionaryContainer(PersonPosition.class, UUIDGenerator.generate().toString());
            newPosition.getTranslations().put(LocaleUtil.LOCALE_RU, value);
            newDictionaryContainers.add((BaseDictionary)newPosition);
            PersonPositionReference perRef = newPosition.toReference();
            perRef.setCaption(value);
            newPosition.setDataSource("vct-xml-import-util");
            DictionaryStorage.get().save((BaseDictionary)newPosition);
            VctXmlImportUtil.getPersonPositions().put(value, newPosition);
            return perRef;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static DictionaryReference<ProfileGroup> getProfileGroup(String value, List<Message> messages) {
        if (newGroups.containsKey(value)) {
            return newGroups.get(value).toReference();
        }
        for (Map.Entry<String, ProfileGroup> entry : oldGroups.entrySet()) {
            ProfileGroup pg = entry.getValue();
            for (String code : pg.getTranslations().values()) {
                if (!TextUtil.isSame((String)code, (String)value, (boolean)true)) continue;
                ProfileGroupReference posRef = pg.toReference();
                posRef.setCaption(value);
                newDictionaryContainers.add((BaseDictionary)pg);
                newGroups.put(value, pg);
                return posRef;
            }
        }
        try {
            ProfileGroup newPG = VctXmlImportUtil.createDictionaryContainer(ProfileGroup.class, UUIDGenerator.generate().toString());
            newPG.getTranslations().put(LocaleUtil.LOCALE_RU, value);
            newDictionaryContainers.add((BaseDictionary)newPG);
            ProfileGroupReference pgRef = newPG.toReference();
            pgRef.setCaption(value);
            newGroups.put(value, newPG);
            return pgRef;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static <T extends BaseEntity> EntityContainer<T> createEntityContainer(Class<T> entityClass, String uid) throws Exception {
        EntityContainer entityContainer = new EntityContainer(entityClass, uid);
        entityContainer.setCreatedBy(IMPORTER);
        entityContainer.setModifiedBy(IMPORTER);
        VersionInfo versionInfo = entityContainer.getVersionInfo();
        String versionInfoUid = UUIDGenerator.generate((boolean)false).toString();
        versionInfo.setUid(versionInfoUid);
        versionInfo.setCreatedBy(IMPORTER);
        versionInfo.setModifiedBy(IMPORTER);
        String dataSource = "file";
        versionInfo.setDataSource(dataSource);
        return entityContainer;
    }

    public static <T extends BaseDictionary> T createDictionaryContainer(Class<T> dictionaryClass, String uid) throws Exception {
        BaseDictionary dictionaryContainer = (BaseDictionary)dictionaryClass.newInstance();
        dictionaryContainer.setUid(uid);
        dictionaryContainer.setCode(uid);
        dictionaryContainer.setCreatedBy(IMPORTER);
        dictionaryContainer.setModifiedBy(IMPORTER);
        return (T)dictionaryContainer;
    }

    public static void loadDictionaryFromFile(String path) {
        Document doc;
        List<Object> res = new ArrayList();
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.parse(path);
        }
        catch (Exception e) {
            doc = null;
            e.printStackTrace();
        }
        if (doc != null) {
            try {
                res = VctXmlImportUtil.getDictionariesFromXml(doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (BaseDictionary dict : res) {
            try {
                if (dict instanceof GeoLocation && ((GeoLocation)dict).getType() == LocationType.CITY) {
                    GeoLocation loc = (GeoLocation)dict;
                    String key = null;
                    if (loc.getTranslations().values().size() > 0) {
                        key = loc.getTranslations().containsKey(LocaleUtil.LOCALE_RU) ? (String)loc.getTranslations().get(LocaleUtil.LOCALE_RU) : (loc.getTranslations().containsKey(null) ? (String)loc.getTranslations().get(null) : (String)loc.getTranslations().values().iterator().next());
                    }
                    if (key == null) continue;
                    citiesReferences.put(key.toLowerCase(), (DictionaryReference<GeoLocation>)loc.toReference());
                    continue;
                }
                if (dict instanceof CostCodeCategory) {
                    CostCodeCategory cat = (CostCodeCategory)dict;
                    CostCodeCategoryReference catRef = cat.toReference();
                    if (cat.getName() == null) continue;
                    catRef.setCaption(cat.getName());
                    costCodeCategoryReferences.put(cat.getName().toUpperCase(), (DictionaryReference<CostCodeCategory>)catRef);
                    continue;
                }
                if (!(dict instanceof Country) && !(dict instanceof Airline) && !(dict instanceof LegalForm) && !(dict instanceof PersonPosition) && !(dict instanceof MetadataKeyDescriptor)) continue;
                dict.setDataSource("vct-xml-import-util");
                DictionaryStorage.get().save(dict);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static List<BaseDictionary> getDictionariesFromXml(Document doc) throws Exception {
        ArrayList<BaseDictionary> res = new ArrayList<BaseDictionary>();
        Element docEle = doc.getDocumentElement();
        NodeList containers = docEle.getElementsByTagName(NODE_OBJECT);
        if (containers.getLength() > 0) {
            for (int i = 0; i < containers.getLength(); ++i) {
                Node node = containers.item(i);
                if (node.getNodeType() != 1) continue;
                Element elm = (Element)node;
                String className = elm.getAttribute("class");
                Class<?> cls = Class.forName(className);
                BaseDictionary dictionary = (BaseDictionary)cls.newInstance();
                dictionary.fromXML(elm);
                res.add(dictionary);
            }
        }
        return res;
    }

    private static String getKeyForPerson(Person per, String dkNumber) {
        String res = "";
        if (per == null || TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true)) && TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
            return NULL_KEY;
        }
        if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
            res = L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        } else if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
            res = L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        }
        String firstName = "";
        if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
            firstName = L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        } else if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
            firstName = L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        }
        if (!res.contains(firstName)) {
            res = res + (res.length() > 0 ? " " : "") + firstName;
        }
        if (TextUtil.isBlank((String)res)) {
            res = NULL_KEY;
        }
        res = dkNumber != null ? dkNumber + "|" + res : "|" + res;
        return res.toUpperCase();
    }

    private static EntityContainer<Person> createPersonContainer(String name) {
        EntityContainer<Person> newPersonCont = null;
        try {
            newPersonCont = VctXmlImportUtil.createEntityContainer(Person.class, UUIDGenerator.generate().toString());
        }
        catch (Exception e) {
            return newPersonCont;
        }
        Person person = (Person)newPersonCont.getEntity();
        Pattern pat = Pattern.compile("(\\S*)\\s(.*)");
        Matcher mat = pat.matcher(name);
        if (mat.matches()) {
            L10nStringHelper.setValue((L10nString)person.getLastName(), (String)mat.group(1), (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)mat.group(2), (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)person.getLastName(), (String)TextUtil.translit((String)mat.group(1), (boolean)true), (Locale)LocaleUtil.LOCALE_EN);
            L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)TextUtil.translit((String)mat.group(2), (boolean)true), (Locale)LocaleUtil.LOCALE_EN);
        } else {
            L10nStringHelper.setValue((L10nString)person.getLastName(), (String)name, (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)person.getLastName(), (String)TextUtil.translit((String)name, (boolean)true), (Locale)LocaleUtil.LOCALE_EN);
        }
        return newPersonCont;
    }

    private static <D extends BaseDictionary> Element createDictionatyContainerElement(Document convertDocument, D dictionaryContainer) throws Exception {
        Element dictionaryContainerElement = convertDocument.createElementNS(null, NODE_OBJECT);
        dictionaryContainerElement.setAttribute("class", dictionaryContainer.getClass().getName());
        dictionaryContainer.toXML(dictionaryContainerElement);
        return dictionaryContainerElement;
    }

    private static CostCodeProperties createCostCodeProperties(String name, CostCodeType ccType, CostCodeCategory category) {
        CostCodeProperties ccp = new CostCodeProperties();
        ccp.setUid(UUIDGenerator.generate().toString());
        ccp.setName(name);
        ccp.setSabreShortName(name);
        ccp.setSabreName(name);
        ccp.setType(ccType);
        if (category != null) {
            ccp.setCategory((DictionaryReference)category.toReference());
        } else if (costCodeCategoryReferences.containsKey(name.toUpperCase())) {
            ccp.setCategory(costCodeCategoryReferences.get(name.toUpperCase()));
        } else {
            CostCodeCategory cat = null;
            try {
                cat = VctXmlImportUtil.createDictionaryContainer(CostCodeCategory.class, UUIDGenerator.generate().toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (cat != null) {
                cat.setName(name);
                cat.setShortName(name);
                cat.getTranslations().put(LocaleUtil.LOCALE_EN, name.toUpperCase());
                try {
                    cat.setDataSource("vct-xml-import-util");
                    DictionaryStorage.get().save((BaseDictionary)cat);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                newDictionaryContainers.add((BaseDictionary)cat);
                costCodeCategoryReferences.put(name.toUpperCase(), (DictionaryReference<CostCodeCategory>)cat.toReference());
                ccp.setCategory((DictionaryReference)cat.toReference());
            }
        }
        return ccp;
    }

    private static CostCode createCostCode(CostCodeProperties ccp, String value) {
        CostCode cc = new CostCode();
        cc.setUid(UUIDGenerator.generate().toString());
        cc.setCostCodeProperties(ccp);
        cc.setValue(value);
        return cc;
    }

    private static void clearAllOrganizationData(Organization org) {
        org.getAddresses().clear();
        org.getBankAccounts().clear();
        org.getCards().clear();
        org.getCommunications().clear();
        org.getCostCodeProperties().clear();
        org.getCostCodes().clear();
        org.getManagers().clear();
        org.getMetadata().clear();
        org.getPayers().clear();
        org.getResponsiblePersons().clear();
        org.getReasonCodes().clear();
        org.getSabreAdditionalCommand1Lines().clear();
        org.getSabreAdditionalCommand2Lines().clear();
        org.getSabreAdditionalCommand3Lines().clear();
        org.getSabreAdditionalProfileLines().clear();
        org.getTypes().clear();
        org.getVatLicenseNumberHistory().clear();
        org.getVatPayerHistory().clear();
        org.getWorkModes().clear();
        org.getKeyContacts().clear();
        org.setAfsSettings(null);
        org.setAirline(null);
        org.setClientID(null);
        org.setKpp(null);
        org.setLegalForm(null);
        org.setNotes(null);
        org.setOkpoCode(null);
        org.setOldShortName(null);
        org.setOldDkNumber(null);
        org.setParent(null);
        org.setPreferredLocale(null);
        org.setRegistrationId(null);
        org.setSabreNotes(null);
        org.setSigner(null);
        org.setVatLicenseNumber(null);
        org.setVatPayer(null);
        org.getFullName().setStringValue(null);
        org.getShortName().setStringValue(null);
    }

    private static void clearAllHoldingData(Holding org) {
        org.getAddresses().clear();
        org.getCommunications().clear();
        org.getMetadata().clear();
        org.getVatLicenseNumberHistory().clear();
        org.getVatPayerHistory().clear();
        org.setKpp(null);
        org.setLegalForm(null);
        org.setNotes(null);
        org.setOkpoCode(null);
        org.setPreferredLocale(null);
        org.setRegistrationId(null);
        org.setVatLicenseNumber(null);
        org.setVatPayer(null);
        org.getFullName().setStringValue(null);
        org.getShortName().setStringValue(null);
    }

    private static void clearAllPersonData(Person per) {
        per.getAddresses().clear();
        per.getAirlineBonusCards().clear();
        per.getBankAccounts().clear();
        per.getCards().clear();
        per.getCommunications().clear();
        per.getCostCodes().clear();
        per.getEmployments().clear();
        per.getGdsReferences().clear();
        per.getPassports().clear();
        per.getSabreAdditionalProfileLines().clear();
        per.getSabreEmailContacts().clear();
        per.getSabrePhoneContacts().clear();
        per.getSalesPoints().clear();
        per.getTypes().clear();
        per.getVisas().clear();
        per.setGender(null);
        per.setLoginName(null);
        per.setNotes(null);
        per.setOldFirstName(null);
        per.setOldLastName(null);
    }

    static {
        oldPositions = new HashMap<String, PersonPosition>();
        oldGroups = new HashMap<String, ProfileGroup>();
        newGroups = new HashMap<String, ProfileGroup>();
        citiesReferences = new HashMap<String, DictionaryReference<GeoLocation>>();
        oldOrganizationContainers = new HashMap<String, EntityContainer<Organization>>();
        oldHoldingContainers = new HashMap<String, EntityContainer<Holding>>();
        oldPersonContainers = new HashMap<String, EntityContainer<Person>>();
        oldContractContainers = new HashMap<String, EntityContainer<Contract>>();
        oldSalesPointContainers = new HashMap<String, EntityContainer<SalesPoint>>();
        newPersonContainers = new HashMap<String, EntityContainer<Person>>();
        holdingReferences = new HashMap<String, EntityReference<Holding>>();
        oldCostCodeCategories = new HashMap<String, CostCodeCategory>();
        oldMetadataKeyDescriptors = new HashMap<String, MetadataKeyDescriptor>();
        newOrganizationContainers = new HashMap<String, EntityContainer<Organization>>();
        newHoldingContainers = new ArrayList<EntityContainer<? extends BaseEntity>>();
        holdingNamesMap = new HashMap<String, String>();
        udidNamesMap = new HashMap<String, String>();
        afsNamesMap = new HashMap<String, String>();
        otherUdidNamesSet = new HashSet<String>();
        payersMap = new HashMap<String, Set<String>>();
        newContractContainers = new HashMap<String, EntityContainer<Contract>>();
        newSalesPointContainers = new HashMap<String, EntityContainer<SalesPoint>>();
        costCodeCategoryReferences = new HashMap<String, DictionaryReference<CostCodeCategory>>();
        newDictionaryContainers = new ArrayList<BaseDictionary>();
        clientOriginUdidCategory = null;
        udidsNotFound = new HashSet<String>();
        patternExtensionNumber = Pattern.compile("(.*)(\u0434\u043e\u0431|\u0434\u043e\u0431\u0430\u0432\u043e\u0447\u043d\u044b\u0439)\\.{0,1}\\s*([0-9\\-]+)");
        patternName = Pattern.compile("[0-9A-Za-z\u0410-\u042f\u0430-\u044f \\(\\)\\-\\.\u0451\u0401]+");
        patternCity1 = Pattern.compile("^([\u0433|\u0413][\\.|\\s+])\\s*(.*)");
        patternCity2 = Pattern.compile("(.*)\\s+([\u0433|\u0413]\\.{0,1})$");
        patternCityGeneral = Pattern.compile("(.*)([\u0433|\u0413][\\.|\\\\s+])\\s*([A-Za-z\u0410-\u042f\u0430-\u044f0-9\\-]+)(.*)");
    }
}

