/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.vat;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ContractRelationVatDetalization;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import java.util.List;
import org.junit.Test;

public class AirProductCloneTest
extends ModelTestBase {
    @Test
    public void testClone() throws Exception {
        EntityContainer bookingCtr = new TestBookingFileBuilder().client(TestBookingFileBuilder.client).reservation().airProduct().issueDate("2020-01-01 00:00:00").blankOwner(ProfileHelper.findOrganizationRef((String)"SU")).tax("YR", 100.0).segmentTariff().segment().departureLocation("MOW").arriveLocation("KJA").end().end().end().end().create();
        Product sell = (Product)((Reservation)((BookingFile)bookingCtr.getEntity()).getReservations().get(0)).getProducts().get(0);
        List components = sell.getVendorVatDetalization().getComponents();
        this.checkVendorVatDetalization(components, sell.getTaxes());
        this.checkContractRelationVatDetalization(sell);
        Product duplicate = AirProductHelper.clone((Product)sell, (boolean)true);
        List duplicateComponents = duplicate.getVendorVatDetalization().getComponents();
        this.checkVendorVatDetalization(duplicateComponents, duplicate.getTaxes());
        this.checkContractRelationVatDetalization(duplicate);
    }

    private void checkContractRelationVatDetalization(Product product) {
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations((Product)product)) {
            ContractRelationVatDetalization vat = relation.getServiceData().getDetalization().getVat();
            if (vat == null) continue;
            for (VatComponent comp : vat.getComponents()) {
                for (String taxUid : comp.getTaxesUids()) {
                    if (CollectionUtil.find((Iterable)relation.getServiceData().getDetalization().getTaxes(), (String)taxUid) != null) continue;
                    throw Xeption.forDeveloper((String)"tax with uid ={0} not found", (Object[])new Object[]{taxUid});
                }
            }
        }
    }

    private void checkVendorVatDetalization(List<VatComponent> components, List<Tax> taxes) {
        for (VatComponent comp : components) {
            for (String taxUid : comp.getTaxesUids()) {
                if (CollectionUtil.find(taxes, (String)taxUid) != null) continue;
                throw Xeption.forDeveloper((String)"tax with uid ={0} not found", (Object[])new Object[]{taxUid});
            }
        }
    }
}

