/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.vat;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestOrganizationBuilder;
import com.gridnine.xtrip.server.model.test.TestTemplateDocumentBuilder;
import com.gridnine.xtrip.server.model.test.TestUniversalProductBuilder;
import com.gridnine.xtrip.server.model.test.TestUniversalProductDescriptionBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class UniversalProductVatTest
extends ModelTestBase {
    @Test
    public void testPaymentVat() throws Exception {
        EntityReference descrRef = new TestUniversalProductDescriptionBuilder().create().toReference();
        EntityReference templateRef = new TestTemplateDocumentBuilder().metadata(MetadataKey.KEY_FINANCE_DOCUMENT_TYPE, (Object)FinanceDocumentType.INVOICE).create().toReference();
        EntityReference clientRef = new TestOrganizationBuilder((Organization)EntityStorage.get().resolve(TestBookingFileBuilder.client).getEntity()).financeProperties().invoice().template(templateRef).end().end().create().toReference();
        EntityContainer bookingCtr = ((TestUniversalProductBuilder)new TestBookingFileBuilder().client(clientRef).reservation().product(TestUniversalProductBuilder.class, new Object[]{descrRef})).hasVat(false).end().end().create();
        List availableDocs = FinanceDocumentsHelper.getAvailableFinanceDocuments((BookingFile)((BookingFile)bookingCtr.getEntity()));
        List products = Collections.singletonList(((Reservation)((BookingFile)bookingCtr.getEntity()).getReservations().get(0)).getProducts().get(0));
        Payment result = FinanceDocumentsHelper.addPayment(products, (List)availableDocs, new HashSet());
        BillingItem productItem = (BillingItem)result.getBillingItems().get(0);
        Assert.assertEquals((Object)ServiceType.TICKET, (Object)productItem.getServiceType());
        Assert.assertEquals((double)0.0, (double)productItem.getAmount().getVat(), (double)0.001);
    }
}

