<%@ page import="com.gridnine.xtrip.common.rules.RulesEnvironment" %>
<%@ page import="com.gridnine.xtrip.common.rules.elements.RuleProperty" %>
<%@ page import="com.gridnine.xtrip.common.rules.elements.RuleCondition" %>
<%@ page import="java.util.List" %>
<%@ page import="java.util.ArrayList" %>
<%@ page import="java.util.Collections" %>
<%@ page import="java.util.Comparator" %>
<%@ page import="com.gridnine.xtrip.common.util.TextUtil" %>
<%@ page import="java.io.File" %>
<%@ page import="org.apache.commons.io.FileUtils" %>
<%@ page import="com.gridnine.xtrip.common.model.rules.standard.UniversalProductPropertiesFactory" %>
<%@ page import="java.lang.reflect.Field" %>
<%@ page import="com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription" %>
<%@ page import="com.gridnine.xtrip.common.model.EntityReference" %>
<%@ page import="com.gridnine.xtrip.common.model.entity.EntityStorage" %>
<%@ page import="com.gridnine.xtrip.common.model.EntityContainer" %>
<%@ page import="com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterDescription" %>
<%@ page import="com.gridnine.xtrip.common.l10n.model.LocaleHelper" %>
<%@ page import="com.gridnine.xtrip.common.l10n.model.LocaleManager" %>
<%@ page language="java" pageEncoding="UTF-8"%>
<%
	LocaleManager.get().setCurrentLocale(LocaleHelper.RU_LOCALE);
	RuleProperty property= RulesEnvironment.get().findProperty(request.getParameter("propertyId"));
	String propertyId = property.getId();
	String fixedComment = null;
	if(property instanceof UniversalProductPropertiesFactory.BaseUniversalProductRulePropertyDescriptor){
		UniversalProductPropertiesFactory.BaseUniversalProductRulePropertyDescriptor upd = (UniversalProductPropertiesFactory.BaseUniversalProductRulePropertyDescriptor) property;
		Field field = UniversalProductPropertiesFactory.BaseUniversalProductRulePropertyDescriptor.class.getDeclaredField("ref");
		field.setAccessible(true);
		EntityReference<UniversalProductDescription> descr = (EntityReference<UniversalProductDescription>) field.get(upd);
		propertyId = "UNIVERSAL_PRODUCT_"+propertyId.substring(descr.getUid().length()+1);
		EntityContainer<UniversalProductDescription> descrCtr = EntityStorage.get().resolve(descr);
		if(descrCtr != null){
			for(UniversalProductCustomParameterDescription param: descrCtr.getEntity().getCustomParameters()){
				if(propertyId.contains(param.getId())){
					fixedComment = "Значение из поля \""+param.getDisplayName()+"\" из маски продукта";
					break;
				}
			}
		}
	}
%>
<h2>Описание свойства <%=property.getDisplayName()%></h2>
<table class="table table-striped" >
	<thead>
	<tr>
		<th scope="col">Условие</th>
		<th scope="col">Тип значения</th>
	</tr>
	</thead>
	<tbody>
	<%
		List<RuleCondition> conditions = new ArrayList<>(RulesEnvironment.get().getConditions(property));
		Collections.sort(conditions, new Comparator<RuleCondition>() {
			@Override
			public int compare(RuleCondition o1, RuleCondition o2) {
				return TextUtil.compare(o1.getDisplayName(), o2.getDisplayName(), false, false);
			}
		});
		for(RuleCondition condition: conditions){
			File valueTypeFile = new File(session.getServletContext().getRealPath("/")+"elements/value-types/"+property.getRendererId()+".html");
			File conditionFile = new File(session.getServletContext().getRealPath("/")+"elements/conditions/"+condition.getId()+".html");
	%>
	<tr>
		<%
			if(conditionFile.exists()){
		%>
		<td><a onclick="showPopup('elements/conditions/<%=condition.getId()%>.html')"><%=condition.getDisplayName()%></a></td>
		<%
		}else{
		%>
		<td><%=condition.getDisplayName()%></td>
		<%
			}
		%>
		<% if(condition.hasRightSide()){
			if(valueTypeFile.exists()){
		%>
		<td><a onclick="showPopup('elements/value-types/<%=property.getRendererId()%>.html')"><%=property.getRendererId()%></a></td>
		<% } else {
		%>
		<td><%=property.getRendererId()%></td>
		<% }
		%>
		<% } else {
		%>
		<td>без значения</td>
		<% }
		%>
	</tr>
	<%
		}
	%>
	</tbody>
</table>
<%
File commentFile = new File(session.getServletContext().getRealPath("/")+"elements/properties/"+propertyId+".html");
if(fixedComment != null || commentFile.exists()){
%>
<h3>Комментарии</h3>
<%
		out.print(fixedComment != null? fixedComment: FileUtils.readFileToString(commentFile,"UTF-8"));
	}
%>