package com.gridnine.xtrip.server.model.statistics

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.booking.CommonProductIndex
import com.gridnine.xtrip.common.model.booking.ProductStatus
import com.gridnine.xtrip.common.model.booking.WorkflowStatus
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.standard.helpers.URLConnectionHelper
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.util.IoUtil
import com.gridnine.xtrip.common.util.MiscUtil
import com.gridnine.xtrip.server.configuration.ServerConfiguration

import java.text.SimpleDateFormat


def startDateStr = "2019-07-22"
def endDateStr = "2019-07-22"
String url = "http://91.109.202.167:8080/licence/compare-statistics"


def sdf = new SimpleDateFormat("yyyy-MM-dd")

def query = new SearchQuery()
query.criteria.criterions.add(SearchCriterion.ge(CommonProductIndex.Property.issueDate.name(), MiscUtil.clearTime(sdf.parse(startDateStr))))
query.criteria.criterions.add(SearchCriterion.le(CommonProductIndex.Property.issueDate.name(), MiscUtil.setDayEndTime(sdf.parse(endDateStr))))
query.criteria.criterions.add(SearchCriterion.ne(CommonProductIndex.Property.status.name(), ProductStatus.EXCHANGE))
WorkflowStatus ws = null
for(WorkflowStatus st: WorkflowStatus.values()){
    if("ERROR".equals(st.name())){
        ws = st
        break
    }
}
query.criteria.criterions.add(SearchCriterion.ne(CommonProductIndex.Property.status.name(), ProductStatus.EXCHANGE))
if(ws != null){
    query.criteria.criterions.add(SearchCriterion.or(SearchCriterion.ne(CommonProductIndex.Property.workflowStatus.name(), ws), SearchCriterion.eq(CommonProductIndex.Property.workflowStatus.name(), null)))
}
query.preferredProperties.add("navigationKey")

def sb = new StringBuilder(String.format("%s||%s||%s", startDateStr, endDateStr, Environment.getPublished(ServerConfiguration.class).getConfiguration().getProperty("licenceKey")))
EntityStorage.get().search(CommonProductIndex.class, query).data.forEach{it ->
    sb.append("\n${it.source.uid}_${it.navigationKey}")
}


URLConnection connection = URLConnectionHelper.prepareURLConnection(new URL(url), null)
connection.setDoInput(true);
connection.setDoOutput(true);
connection.setUseCaches(false);
((HttpURLConnection) connection).setRequestMethod("POST"); //$NON-NLS-1$
connection.setRequestProperty("Content-Type", //$NON-NLS-1$
        "text/html; charset=utf-8"); //$NON-NLS-1$
OutputStream os = connection.getOutputStream();
try {
    IoUtil.copyStream(new ByteArrayInputStream(sb.toString().getBytes("utf-8")),
            os, 256);
    os.flush();
} finally {
    os.close();
}
def strm = new ByteArrayOutputStream();
InputStream is = connection.getInputStream();
try {
    IoUtil.copyStream(is, strm, 256);
} finally {
    is.close();
}

def result = new String(strm.toByteArray(), "utf-8")

message(result)