

import org.apache.commons.lang.StringUtils

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.dict.CodeSystem
import com.gridnine.xtrip.common.model.dict.DictionaryCache
import com.gridnine.xtrip.common.model.dict.GeoLocation
import com.gridnine.xtrip.common.model.dict.LocationType
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.system.ContentType
import com.gridnine.xtrip.common.model.system.Document
import com.gridnine.xtrip.common.model.system.DocumentType

def cache = Environment.getPublished(DictionaryCache.class);
def set = cache.getAll(GeoLocation.class);

def title = { buf ->

    buf.append StringUtils.rightPad('Код', 15)
    buf.append StringUtils.rightPad( 'Тип', 20)
    buf.append StringUtils.rightPad( 'Название', 50);

    buf.append StringUtils.rightPad('IATA', 15)
    buf.append StringUtils.rightPad('CRT', 15)
    buf.append '\n'
    buf.append '\n'
}

def printrow = { buf, geo ->

    buf.append StringUtils.rightPad(geo.code, 15)
    buf.append StringUtils.rightPad( geo.type.name(), 20)

    buf.append StringUtils.rightPad( (geo.translations.size() > 0 ?  geo.translations.values().iterator().next() : '' ), 50);

    def iata = geo.codeVariants[CodeSystem.IATA.name()]
    def crt = geo.codeVariants[CodeSystem.CRT.name()]
    buf.append  StringUtils.rightPad(( iata?.trim() ? iata : ''), 15)
    buf.append StringUtils.rightPad(( crt?.trim() ? crt : ''), 15)
    buf.append '\n'
}


def iata = []
def crt = []
def others = []


set.each {

    def code = it.key;
    def geo = it.value;

    if((geo.type == LocationType.CITY || geo.type ==LocationType.AIRPORT) && !geo.timeZoneId?.trim()){

        if(geo.codeVariants[CodeSystem.IATA.name()]){
            iata.add(geo)
        }
        else if(geo.codeVariants[CodeSystem.CRT.name()]){
            crt.add(geo)
        }
        else{
            //others.add(geo)
        }
    }
}

StringBuilder sb = new StringBuilder();
title(sb)

iata.each{     printrow(sb, it)     }
crt.each{ printrow(sb, it) }
others.each{ printrow(sb, it) }


def now = new Date()
def newDate = now.format( 'dd.MM.yyyy' )
def reportName = "Отчет по таймзонам геолокаций от " + newDate + '.txt'

def report = new Document();
report.setContent(sb.toString().getBytes('utf-8'));
report.setTitle(reportName);
report.setName(reportName)
report.setType(DocumentType.OTHER)
report.setCreated(now)
report.setContentType(ContentType.TEXT)
def es = EntityStorage.get();
es.save(EntityContainer.create(report), true)

message("generated: " + reportName)


