/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.setup;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.configuration.BasicAppConfiguration;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.setup.SetupHandler;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ModelSetupProcedure
implements SetupHandler {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public double getWeight() {
        return 0.0;
    }

    public void doCleanup(Properties configuration) throws Exception {
    }

    public void doSetup(Properties configuration) throws Exception {
        this.setupAssets();
        this.setupDictionaries();
        ServerApplication.registerDictionariesCache();
        DictionaryCache.get().check();
        this.setupEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupAssets() throws Exception {
        System.out.print("Assets setup ... ");
        Collection<URL> files = this.getAssetSetupFiles();
        if (files.isEmpty()) {
            System.out.println("none. No assets setup required.");
            return;
        }
        for (URL url : files) {
            Element root;
            try (InputStream strm = IoUtil.getResourceInputStream((URL)url);){
                root = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)strm)).getDocumentElement();
            }
            root.getOwnerDocument().setDocumentURI(url.toExternalForm());
            int count = 0;
            for (Element elm : XmlUtil.getElements((Element)root, (String)"object")) {
                BaseAsset asset = (BaseAsset)XHelper.getClass((String)XmlUtil.getValue((Element)elm, (String)"@class")).newInstance();
                asset.fromXML(elm);
                if (TextUtil.isBlank((String)asset.getUid())) {
                    asset.setUid(UUIDGenerator.generate((boolean)true).toString());
                }
                AssetsStorage.get().save(asset);
                ++count;
            }
            this.log.info(String.format("loaded %s assets from %s", count, url));
        }
        System.out.println("done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupDictionaries() throws Exception {
        System.out.print("Dictionaries setup ... ");
        LogicalStorage.get().getDbPropertiesStorage().putValue("dicts-version", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        Collection<URL> files = this.getDictionarySetupFiles();
        if (files.isEmpty()) {
            System.out.println("none. No dictionaries setup done.");
            return;
        }
        LogicalStorage sm = LogicalStorage.get();
        for (URL url : files) {
            Element root;
            try (InputStream strm = IoUtil.getResourceInputStream((URL)url);){
                root = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)strm)).getDocumentElement();
            }
            root.getOwnerDocument().setDocumentURI(url.toExternalForm());
            int count = 0;
            LogicalSession ss = sm.beginUnitOfWork();
            try {
                for (Element elm : XmlUtil.getElements((Element)root, (String)"object")) {
                    BaseDictionary dict = (BaseDictionary)XHelper.getClass((String)XmlUtil.getValue((Element)elm, (String)"@class")).newInstance();
                    dict.fromXML(elm);
                    if (TextUtil.isBlank((String)dict.getUid())) {
                        dict.setUid(UUIDGenerator.generate((boolean)true).toString());
                    }
                    if (TextUtil.isBlank((String)dict.getCreatedBy())) {
                        dict.setCreatedBy(sm.getUser());
                    }
                    if (TextUtil.isBlank((String)dict.getModifiedBy())) {
                        dict.setModifiedBy(sm.getUser());
                    }
                    dict.setDataSource("ModelSetupProcedure");
                    DictionaryStorage.get().save(dict);
                    if (++count % 1000 != 0) continue;
                    sm.endUnitOfWork(ss, false);
                }
                sm.endUnitOfWork(ss, true);
            }
            finally {
                sm.cancelUnitOfWork(ss);
            }
            this.log.info(String.format("loaded %s dictionary items from %s", count, url));
        }
        System.out.println("done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupEntities() throws Exception {
        System.out.print("Entities setup ... ");
        Collection<URL> files = this.getEntitySetupFiles();
        if (files.isEmpty()) {
            System.out.println("none. No entities setup done.");
            return;
        }
        LogicalStorage sm = LogicalStorage.get();
        for (URL url : files) {
            Element root;
            try (InputStream strm = IoUtil.getResourceInputStream((URL)url);){
                root = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)strm)).getDocumentElement();
            }
            root.getOwnerDocument().setDocumentURI(url.toExternalForm());
            int count = 0;
            for (Element elm : XmlUtil.getElements((Element)root, (String)"object")) {
                if (!EntityContainer.class.getName().equals(XmlUtil.getValue((Element)elm, (String)"@class"))) continue;
                EntityContainer etc = new EntityContainer(XHelper.getClass((String)XmlUtil.getValue((Element)elm, (String)"entityType")));
                etc.fromXML(elm);
                if (TextUtil.isBlank((String)etc.getUid())) {
                    etc.setUid(UUIDGenerator.generate((boolean)true).toString());
                }
                if (TextUtil.isBlank((String)etc.getCreatedBy())) {
                    etc.setCreatedBy(sm.getUser());
                }
                if (TextUtil.isBlank((String)etc.getModifiedBy())) {
                    etc.setModifiedBy(sm.getUser());
                }
                if (TextUtil.isBlank((String)etc.getVersionInfo().getCreatedBy())) {
                    etc.getVersionInfo().setCreatedBy(sm.getUser());
                }
                if (TextUtil.isBlank((String)etc.getVersionInfo().getModifiedBy())) {
                    etc.getVersionInfo().setModifiedBy(sm.getUser());
                }
                etc.setVersionsCount(1);
                etc.getVersionInfo().setVersionNumber(0);
                etc.getVersionInfo().setDataSource("model-setup");
                EntityStorage.get().save(etc, false);
                ++count;
            }
            this.log.info(String.format("loaded %s entities from %s", count, url));
        }
        System.out.println("done.");
    }

    protected Collection<URL> getAssetSetupFiles() throws Exception {
        ArrayList<File> folders = new ArrayList<File>();
        ArrayList<File> otherSetupFiles = new ArrayList<File>();
        PluginManager pm = PluginManager.lookup((Object)this);
        if (pm != null) {
            for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"SetupFolder")) {
                URL url;
                if (!BasicAppConfiguration.get().isExtensionLegal(ext) || (url = pm.getPluginClassLoader(ext.getDeclaringPluginDescriptor()).getResource(String.format("%s/assets", ext.getParameter("url").valueAsString()))) == null) continue;
                Extension.Parameter extParam = ext.getParameter("regionalVariation");
                if (extParam != null) {
                    folders.add(IoUtil.url2file((URL)url));
                    continue;
                }
                otherSetupFiles.add(IoUtil.url2file((URL)url));
            }
        }
        if (pm == null || folders.isEmpty()) {
            folders.add(0, new File(Environment.getConfigurationFolder(), "setup/assets"));
        }
        folders.addAll(otherSetupFiles);
        ArrayList<URL> result = new ArrayList<URL>();
        for (File folder : folders) {
            File[] files = folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().toLowerCase().endsWith(".xml");
                }
            });
            if (files == null || files.length == 0) {
                this.log.warn("no asset setup data files found in folder " + folder);
                continue;
            }
            for (File file : files) {
                result.add(IoUtil.file2url((File)file));
            }
        }
        return result;
    }

    protected Collection<URL> getDictionarySetupFiles() throws Exception {
        ArrayList<File> folders = new ArrayList<File>();
        ArrayList<File> otherSetupFiles = new ArrayList<File>();
        PluginManager pm = PluginManager.lookup((Object)this);
        if (pm != null) {
            for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"SetupFolder")) {
                URL url;
                if (!BasicAppConfiguration.get().isExtensionLegal(ext) || (url = pm.getPluginClassLoader(ext.getDeclaringPluginDescriptor()).getResource(String.format("%s/dict", ext.getParameter("url").valueAsString()))) == null) continue;
                Extension.Parameter extParam = ext.getParameter("regionalVariation");
                if (extParam != null) {
                    folders.add(IoUtil.url2file((URL)url));
                    continue;
                }
                otherSetupFiles.add(IoUtil.url2file((URL)url));
            }
        }
        if (pm == null || folders.isEmpty()) {
            folders.add(0, new File(Environment.getConfigurationFolder(), "setup/dict"));
        }
        folders.addAll(otherSetupFiles);
        ArrayList<URL> result = new ArrayList<URL>();
        for (File folder : folders) {
            File[] files = folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().toLowerCase().endsWith(".xml");
                }
            });
            if (files == null || files.length == 0) {
                this.log.warn("no dictionary setup data files found in folder " + folder);
                continue;
            }
            for (File file : files) {
                result.add(IoUtil.file2url((File)file));
            }
        }
        return result;
    }

    protected Collection<URL> getEntitySetupFiles() throws Exception {
        ArrayList<File> folders = new ArrayList<File>();
        ArrayList<File> otherSetupFiles = new ArrayList<File>();
        PluginManager pm = PluginManager.lookup((Object)this);
        if (pm != null) {
            for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"SetupFolder")) {
                URL url;
                if (!BasicAppConfiguration.get().isExtensionLegal(ext) || (url = pm.getPluginClassLoader(ext.getDeclaringPluginDescriptor()).getResource(String.format("%s/entity", ext.getParameter("url").valueAsString()))) == null) continue;
                Extension.Parameter extParam = ext.getParameter("regionalVariation");
                if (extParam != null) {
                    folders.add(IoUtil.url2file((URL)url));
                    continue;
                }
                otherSetupFiles.add(IoUtil.url2file((URL)url));
            }
        }
        if (pm == null || folders.isEmpty()) {
            folders.add(0, new File(Environment.getConfigurationFolder(), "setup/entity"));
        }
        folders.addAll(otherSetupFiles);
        ArrayList<URL> result = new ArrayList<URL>();
        for (File folder : folders) {
            File[] files = folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().toLowerCase().endsWith(".xml");
                }
            });
            if (files == null || files.length == 0) {
                this.log.warn("no entitiy setup data files found in folder " + folder);
                continue;
            }
            for (File file : files) {
                result.add(IoUtil.file2url((File)file));
            }
        }
        return result;
    }
}

