/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.standard.index;

import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.BaseSystemSettings;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndexData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSystemSettingsIndexHandler
implements IndexHandler<BaseSystemSettings, BasicSystemSettingsIndex> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static StandardSystemSettingsCompaundKeyProvider standardCompaundKeyProvider = new StandardSystemSettingsCompaundKeyProvider();
    private static StandardSystemSettingsActiveProvider standardActiveProvider = new StandardSystemSettingsActiveProvider();
    private final ConcurrentHashMap<String, SystemSettingsCompaundKeyProvider<BaseSystemSettings>> compaundKeysProvidersCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SystemSettingsActiveProvider<BaseSystemSettings>> activeProvidersCache = new ConcurrentHashMap();

    public Class<? extends BaseIndexData<BaseSystemSettings, BasicSystemSettingsIndex>> getDataClass() {
        return BasicSystemSettingsIndexData.class;
    }

    public Class<BasicSystemSettingsIndex> getIndexClass() {
        return BasicSystemSettingsIndex.class;
    }

    public Class<BaseSystemSettings> getEntityType() {
        return BaseSystemSettings.class;
    }

    public void create(EntityContainer<BaseSystemSettings> etc, Collection<BaseIndexData<BaseSystemSettings, BasicSystemSettingsIndex>> indexes) {
        BaseSystemSettings ett = (BaseSystemSettings)etc.getEntity();
        BasicSystemSettingsIndexData data = new BasicSystemSettingsIndexData();
        data.setCompoundKey(this.getCompaundKeyProvider(etc.getEntityType().getName()).getCompaundKey(ett));
        data.setActive(this.getActiveKeyProvider(etc.getEntityType().getName()).isActive(ett));
        data.setName(ett.getName());
        data.setInstallationId(ett.getInstallationId());
        data.setType(ett.getType());
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate((Object)ett.getInstallationId());
        aggregator.aggregate((Enum)ett.getType());
        aggregator.aggregate((Object)ett.getName());
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<BaseSystemSettings, BasicSystemSettingsIndex>)data);
    }

    private SystemSettingsCompaundKeyProvider<BaseSystemSettings> getCompaundKeyProvider(String name) {
        EntityType et = (EntityType)MetaRegistry.get().getEntities().get(name);
        if (et == null) {
            return standardCompaundKeyProvider;
        }
        String className = this.getCompaundKeyProviderClassName(et);
        if (TextUtil.isBlank((String)className)) {
            return standardCompaundKeyProvider;
        }
        SystemSettingsCompaundKeyProvider<BaseSystemSettings> res = this.compaundKeysProvidersCache.get(className);
        if (res != null) {
            return res;
        }
        try {
            res = (SystemSettingsCompaundKeyProvider<BaseSystemSettings>)XHelper.getClass((String)className).newInstance();
        }
        catch (Exception e) {
            this.log.error("unable to instantiate class " + className, (Throwable)e);
            res = standardCompaundKeyProvider;
        }
        SystemSettingsCompaundKeyProvider<BaseSystemSettings> lastValue = this.compaundKeysProvidersCache.putIfAbsent(className, res);
        if (lastValue != null) {
            res = lastValue;
        }
        return res;
    }

    private SystemSettingsActiveProvider<BaseSystemSettings> getActiveKeyProvider(String name) {
        EntityType et = (EntityType)MetaRegistry.get().getEntities().get(name);
        if (et == null) {
            return standardActiveProvider;
        }
        String className = this.getActiveProviderClassName(et);
        if (TextUtil.isBlank((String)className)) {
            return standardActiveProvider;
        }
        SystemSettingsActiveProvider<BaseSystemSettings> res = this.activeProvidersCache.get(className);
        if (res != null) {
            return res;
        }
        try {
            res = (SystemSettingsActiveProvider<BaseSystemSettings>)XHelper.getClass((String)className).newInstance();
        }
        catch (Exception e) {
            this.log.error("unable to instantiate class " + className, (Throwable)e);
            res = standardActiveProvider;
        }
        SystemSettingsActiveProvider<BaseSystemSettings> lastValue = this.activeProvidersCache.putIfAbsent(className, res);
        if (lastValue != null) {
            res = lastValue;
        }
        return res;
    }

    private String getCompaundKeyProviderClassName(EntityType et) {
        String result = (String)et.getParameters().get("compound-key-provider");
        if (!TextUtil.isBlank((String)result)) {
            return result;
        }
        if (et.getExtendsId() == null) {
            return null;
        }
        return this.getCompaundKeyProviderClassName((EntityType)MetaRegistry.get().getEntities().get(et.getExtendsId()));
    }

    private String getActiveProviderClassName(EntityType et) {
        String result = (String)et.getParameters().get("active-provider");
        if (!TextUtil.isBlank((String)result)) {
            return result;
        }
        if (et.getExtendsId() == null) {
            return null;
        }
        return this.getActiveProviderClassName((EntityType)MetaRegistry.get().getEntities().get(et.getExtendsId()));
    }

    static class StandardSystemSettingsActiveProvider
    implements SystemSettingsActiveProvider<BaseSystemSettings> {
        StandardSystemSettingsActiveProvider() {
        }

        @Override
        public Boolean isActive(BaseSystemSettings settings) {
            return null;
        }
    }

    static class StandardSystemSettingsCompaundKeyProvider
    implements SystemSettingsCompaundKeyProvider<BaseSystemSettings> {
        StandardSystemSettingsCompaundKeyProvider() {
        }

        @Override
        public String getCompaundKey(BaseSystemSettings settings) {
            return String.format("%s_%s", settings.getInstallationId(), settings.getType() == null ? null : settings.getType().name());
        }
    }

    public static interface SystemSettingsActiveProvider<E extends BaseSystemSettings> {
        public Boolean isActive(E var1);
    }

    public static interface SystemSettingsCompaundKeyProvider<E extends BaseSystemSettings> {
        public String getCompaundKey(E var1);
    }
}

