/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.model.profile.PCCIndex;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.EMDSegment;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCONumber;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.parsers.model.amadeus.TravellerData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class AmadeusParserHelper {
    public static String getEmdNumber(AirFile airFile) {
        MCONumber mcoNumber = AmadeusParserHelper.getMCONumber(airFile);
        return mcoNumber == null ? null : mcoNumber.getTicketNumber();
    }

    public static MCONumber getMCONumber(AirFile airFile) {
        TicketData ticketData = airFile.getTickets().isEmpty() ? null : (TicketData)airFile.getTickets().get(0);
        return ticketData == null || ticketData.getMcoNumbers().isEmpty() ? null : (MCONumber)ticketData.getMcoNumbers().get(0);
    }

    public static String getEmdRelatedNumber(AirFile airFile) {
        String doc = AmadeusParserHelper.getEmdRelatedDoc(airFile);
        return doc != null ? doc.substring(3) : null;
    }

    public static String getEmdRelatedCarrierCode(AirFile airFile) {
        String doc = AmadeusParserHelper.getEmdRelatedDoc(airFile);
        return doc != null ? doc.substring(0, 3) : null;
    }

    public static Collection<Integer> parseValues(String value) {
        int minusPos = value.indexOf("-");
        if (minusPos == -1) {
            return Collections.singleton(Integer.valueOf(value));
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        int start = Integer.valueOf(value.substring(0, minusPos));
        int end = Integer.valueOf(value.substring(minusPos + 1));
        for (int i = start; i <= end; ++i) {
            result.add(i);
        }
        return result;
    }

    private AmadeusParserHelper() {
    }

    public static Traveller getTravellerOfCurrentBf(MessageContext ctx) {
        TicketData ticketData = (TicketData)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
        Map travellers = (Map)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TRAVELLERS_DATA);
        TravellerData travellerData = (TravellerData)travellers.get(ticketData.getPassenger().getNumberInPNR());
        if (travellerData == null) {
            return null;
        }
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        Traveller traveller = (Traveller)CollectionUtil.find((Iterable)((BookingFile)bookingCtr.getEntity()).getTravellers(), (String)travellerData.getTraveller().getUid());
        if (traveller != null && TextUtil.isBlank((String)traveller.getCyrillicName())) {
            traveller.setCyrillicName(TextUtil.translit((String)traveller.getName(), (boolean)false));
        }
        return traveller;
    }

    public static Traveller getNewTraveller(MessageContext ctx) {
        TicketData ticketData = (TicketData)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
        Map travellers = (Map)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TRAVELLERS_DATA);
        TravellerData travellerData = (TravellerData)travellers.get(ticketData.getPassenger().getNumberInPNR());
        if (travellerData == null) {
            return null;
        }
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        ((BookingFile)bookingCtr.getEntity()).getTravellers().add(travellerData.getTraveller());
        return travellerData.getTraveller();
    }

    public static boolean isTravellersEqualsByPassport(Traveller traveller1, Traveller traveller2) {
        if (traveller1 == null || traveller2 == null) {
            return false;
        }
        if (traveller1.getPassport() == null || traveller2.getPassport() == null) {
            return false;
        }
        return MiscUtil.equals((Object)traveller1.getPassport().getNumber(), (Object)traveller2.getPassport().getNumber(), (boolean)false);
    }

    public static boolean isTravellersEqualsByName(Traveller traveller1, Traveller traveller2) {
        if (traveller1 == null || traveller2 == null) {
            return false;
        }
        if (TextUtil.isBlank((String)traveller1.getName()) || TextUtil.isBlank((String)traveller2.getName())) {
            return false;
        }
        return TextUtil.isSame((String)traveller1.getName(), (String)traveller2.getName(), (boolean)true);
    }

    public static GdsName getGdsName(MessageContext ctx) {
        return (GdsName)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AMADEUS_GDS_NAME);
    }

    public static String getGdsCurrency(AirFile airFile, GdsName gdsName) {
        String equivalentCurrencyCode = airFile.getFare().getEquivalentCurrencyCode();
        if (TextUtil.nonBlank((String)equivalentCurrencyCode)) {
            return equivalentCurrencyCode;
        }
        String totalCurrencyCode = airFile.getFare().getTotalCurrencyCode();
        if (totalCurrencyCode != null) {
            return totalCurrencyCode;
        }
        String agencyOfficeID = airFile.getHeader().getTicketingAgencyOfficeID();
        if (TextUtil.isBlank((String)agencyOfficeID)) {
            return DictHelper.getEquivCurrency();
        }
        Date issueDate = airFile.getPnrDate().getChangeDate();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PCCIndex.Property.gdsName.name(), (Object)gdsName));
        query.getCriteria().getCriterions().add(SearchCriterion.ieq((String)PCCIndex.Property.code.name(), (String)agencyOfficeID));
        if (issueDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PCCIndex.Property.opened.name(), null), SearchCriterion.le((String)PCCIndex.Property.opened.name(), (Object)MiscUtil.setDayEndTime((Date)issueDate))}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PCCIndex.Property.closed.name(), null), SearchCriterion.ge((String)PCCIndex.Property.closed.name(), (Object)MiscUtil.clearTime((Date)issueDate))}));
        }
        List data = EntityStorage.get().search(PCCIndex.class, query).getData();
        for (PCCIndex idx : data) {
            EntityContainer spCtr = EntityStorage.get().resolve(idx.getSource());
            Pcc pcc = (Pcc)CollectionUtil.find((Iterable)((SalesPoint)spCtr.getEntity()).getPccs(), (String)idx.getNavigationKey());
            if (pcc == null || pcc.getCurrency() == null) continue;
            return pcc.getCurrency().getCode();
        }
        return DictHelper.getEquivCurrency();
    }

    public static boolean isSameCity(String cityCode, DictionaryReference<GeoLocation> location) {
        if (cityCode == null || location == null) {
            return false;
        }
        GeoLocation cityByCode = DictHelper.findCityByCode((String)cityCode, (CodeSystem)CodeSystem.IATA);
        GeoLocation cityByLocation = DictHelper.findCity(location);
        return cityByCode != null && cityByCode.equals((Object)cityByLocation);
    }

    public static boolean hasMainSell(AirFile file) {
        TicketData ticketData;
        if (file.getRefund() != null) {
            return false;
        }
        if (file.getHeader().isVoided()) {
            return false;
        }
        return !file.getTickets().isEmpty() && !TextUtil.isBlank((String)(ticketData = (TicketData)file.getTickets().get(0)).getTicketNumber());
    }

    public static Product createFakeSell(String previousTicketNumber, String carrierCode, Reservation res, MCOCategory mcoCategory, MessageContext ctx) {
        Product sell = new Product();
        sell.setSystemNumber(previousTicketNumber);
        sell.setStatus(ProductStatus.SELL);
        sell.setProductCategory(mcoCategory == null ? ProductCategory.AIR : ProductCategory.MCO);
        sell.setMcoCategory(mcoCategory);
        sell.setTicketType(TicketType.FAKE);
        sell.setTraveller(AmadeusParserHelper.getTravellerOfCurrentBf(ctx));
        if (!TextUtil.isBlank((String)carrierCode)) {
            sell.setCarrierNumber(carrierCode);
            AirFile airFile = (AirFile)ctx.getObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
            Airline carrier = DictHelper.findAirlineByAnyCode((String)carrierCode, (Date)airFile.getPnrDate().getCreationDate());
            if (carrier != null) {
                sell.setCarrier((DictionaryReference)carrier.toReference());
            }
        }
        sell.setReservation(res);
        res.getProducts().add(sell);
        return sell;
    }

    public static Product createExchange(Product sell, MCOCategory mcoCategory) throws Exception {
        Product exchange = AirProductHelper.clone((Product)sell, (boolean)true);
        exchange.setPenalty(null);
        exchange.setVendorVatDetalization(null);
        exchange.setVendorVatCalculated(false);
        exchange.setStatus(ProductStatus.EXCHANGE);
        exchange.setCreatedByParser(true);
        exchange.setBspCommissionRate(null);
        exchange.setBspCommissionValue(null);
        sell.setNextProduct(exchange);
        exchange.setPreviousProduct(sell);
        Product product = new Product();
        product.setStatus(ProductStatus.SELL);
        product.setProductCategory(mcoCategory == null ? ProductCategory.AIR : ProductCategory.MCO);
        product.setMcoCategory(mcoCategory);
        product.setTicketType(TicketType.OWN);
        product.setTraveller(sell.getTraveller());
        product.setReservation(sell.getReservation());
        sell.getReservation().getProducts().add(product);
        exchange.setNextProduct(product);
        product.setPreviousProduct(exchange);
        return product;
    }

    public static void linkFakeExchange(Product sell, Product fake, MCOCategory mcoCategory) throws Exception {
        Product exchange = AirProductHelper.clone((Product)sell, (boolean)true);
        exchange.setPenalty(null);
        exchange.setVendorVatDetalization(null);
        exchange.setVendorVatCalculated(false);
        exchange.setStatus(ProductStatus.EXCHANGE);
        exchange.setCreatedByParser(true);
        exchange.setBspCommissionRate(null);
        exchange.setBspCommissionValue(null);
        sell.setNextProduct(exchange);
        exchange.setPreviousProduct(sell);
        fake.setStatus(ProductStatus.SELL);
        fake.setProductCategory(mcoCategory == null ? ProductCategory.AIR : ProductCategory.MCO);
        fake.setMcoCategory(mcoCategory);
        fake.setTicketType(TicketType.OWN);
        ProductHandler.of((BaseProduct)fake).setOrReplaceTraveller((BaseProduct)fake, sell.getTraveller());
        exchange.setNextProduct(fake);
        fake.setPreviousProduct(exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void split(Product product, String newPnr, GdsName gdsName) throws Exception {
        Reservation reservation = product.getReservation();
        BookingFile bf = reservation.getBookingFile();
        ArrayList products = new ArrayList(reservation.getProducts());
        reservation.setBookingFile(null);
        reservation.getProducts().clear();
        try {
            Reservation newReservation = (Reservation)XCloneHelper.clone((XCloneable)reservation, (boolean)true);
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)newReservation, (GdsName)gdsName, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)newPnr);
            newReservation.setBookingFile(bf);
            bf.getReservations().add(newReservation);
            newReservation.getProducts().add(product);
            newReservation.getProducts().add(product.getPreviousProduct());
            newReservation.getProducts().add(product.getPreviousProduct().getPreviousProduct());
            products.remove(product);
            products.remove(product.getPreviousProduct());
            products.remove(product.getPreviousProduct().getPreviousProduct());
            product.setReservation(newReservation);
            product.getPreviousProduct().setReservation(newReservation);
            product.getPreviousProduct().getPreviousProduct().setReservation(newReservation);
        }
        finally {
            reservation.setBookingFile(bf);
            reservation.getProducts().addAll(products);
        }
    }

    public static void correctStandardExchangeFields(Product exchange, MessageContext ctx) {
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        exchange.setIssueDate(airFile.getPnrDate().getChangeDate());
        exchange.setContractRulesApplied(false);
        exchange.setChecked(false);
        String agentCode = (String)ctx.getObject((Enum)IBusProfileContextKeys.AGENT_CODE);
        exchange.setCashierCode(agentCode);
        EntityReference agent = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.AGENT);
        exchange.setCashier(agent);
        exchange.setPcc((String)ctx.getObject((Enum)IBusProfileContextKeys.PCC));
        AirProductHelper.setSubagency((Product)exchange, (EntityReference)AirProductHelper.getSubagency((Product)exchange.getPreviousProduct()));
        exchange.setSalesPoint(exchange.getPreviousProduct().getSalesPoint());
    }

    public static String getEmdType(AirFile file, EMDSegment emdSegment, boolean checkMainSell) {
        if (emdSegment.getReasonDescription() != null) {
            if (emdSegment.getReasonDescription().contains("CANCELLATION FEE") || emdSegment.getReasonDescription().contains("PENALTY FEE")) {
                if (checkMainSell && AmadeusParserHelper.hasMainSell(file)) {
                    return "SELL";
                }
                return "PENALTY";
            }
            if (emdSegment.getReasonDescription().contains("PRE RESERVED SEAT") || emdSegment.getReasonSubCodeDescription() != null && emdSegment.getReasonSubCodeDescription().contains("MY SEAT")) {
                if (checkMainSell && AmadeusParserHelper.hasMainSell(file)) {
                    return "SELL";
                }
                return "SEAT_RESERVATION";
            }
            if (emdSegment.getReasonDescription().contains("DEPOSITS DOWN PAYMENTS")) {
                return "GROUP_PREPAYMENT";
            }
            if (emdSegment.getReasonDescription().contains("RESIDUAL VALUE FOR REFUN") || emdSegment.getReasonSubCodeDescription() != null && emdSegment.getReasonSubCodeDescription().contains("RESIDUAL VALUE FOR REFUN")) {
                if (checkMainSell && AmadeusParserHelper.hasMainSell(file)) {
                    return "SELL";
                }
                return "RESIDUAL_VALUE_FOR_REFUND";
            }
            if (emdSegment.getReasonDescription().contains("TICKET AMENDMENT") || emdSegment.getReasonSubCodeDescription() != null && emdSegment.getReasonSubCodeDescription().contains("RESIDUAL VALUE FOR FUTURE")) {
                if (checkMainSell && AmadeusParserHelper.hasMainSell(file)) {
                    return "SELL";
                }
                return "VOUCHER";
            }
            if (emdSegment.getReasonDescription().startsWith("PET ")) {
                if (checkMainSell && AmadeusParserHelper.hasMainSell(file)) {
                    return "SELL";
                }
                return "ANIMALS";
            }
            if (emdSegment.getReasonDescription().contains(" MEAL")) {
                if (checkMainSell && AmadeusParserHelper.hasMainSell(file)) {
                    return "SELL";
                }
                return "SPECIAL_FOOD";
            }
            if (emdSegment.getReasonDescription().equals("TRAIN AEROEXPRESS")) {
                return "AEROEXPRESS";
            }
            if (emdSegment.getReasonDescription().equals("INSURANCE")) {
                return "INSURANCE_ACCIDENT";
            }
        }
        if (emdSegment.getReasonSubCodeDescription() != null && emdSegment.getReasonSubCodeDescription().contains("GROUP DEPOSITS/DOWNPAYMENTS")) {
            return "GROUP_PREPAYMENT";
        }
        if (!TextUtil.isBlank((String)emdSegment.getExcessBaggageTotalNumber())) {
            if (checkMainSell && AmadeusParserHelper.hasMainSell(file)) {
                return "SELL";
            }
            return "LUGGAGE";
        }
        if (checkMainSell && AmadeusParserHelper.hasMainSell(file)) {
            return "SELL";
        }
        MCOCategory mcoCategory = AirProductHelper.getMcoCategory((String)emdSegment.getReasonCode(), (String)emdSegment.getReasonSubCode(), (String)emdSegment.getReasonDescription(), null);
        switch (mcoCategory) {
            case SEAT_RESERVATION: 
            case ANIMALS: 
            case SPECIAL_FOOD: 
            case TICKET_REFUNDABILITY: {
                return mcoCategory.name();
            }
        }
        return "PENALTY";
    }

    public static BigDecimal getVoucherAmount(AirFile file, MCONumber mcoNumber) {
        return file.getEmdSegments().stream().filter(segmentData -> mcoNumber.getTsmNumber() != null && mcoNumber.getTsmNumber().equals(segmentData.getTsmNumber())).filter(segmentData -> "VOUCHER".equals(AmadeusParserHelper.getEmdType(file, segmentData, false))).map(EMDSegment::getTotalBaseAmount).filter(Objects::nonNull).map(Money::getValue).filter(Objects::nonNull).findFirst().orElse(BigDecimal.ZERO);
    }

    private static String getEmdRelatedDoc(AirFile airFile) {
        for (EMDSegment emdSegment : airFile.getEmdSegments()) {
            String doc;
            if (emdSegment.getIssuedInConnectionWithData() == null || (doc = emdSegment.getIssuedInConnectionWithData().getIssuedDocumentNumber()) == null || doc.length() <= 10) continue;
            return doc;
        }
        return null;
    }
}

