/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AIAN_RecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "AITAN";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(AIAN_Parameters.AIAN);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) throws AbstractRecordProcessor.StopProcessingException {
        if (parameter instanceof AIAN_Parameters && !TextUtil.isBlank((String)value)) {
            String customerCode = value.indexOf(";") > 0 ? value.substring(0, value.indexOf(";")) : value;
            EntityReference customerProfile = ProfileHelper.findOrganizationRef((String)customerCode);
            if (customerProfile != null) {
                result.setCustomerProfile(customerProfile);
            }
            context.put(((AIAN_Parameters)parameter).name(), customerCode);
        }
    }

    private static enum AIAN_Parameters implements AbstractRecordProcessor.IValue
    {
        AIAN(500, true, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private AIAN_Parameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

