/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.Header;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AirFileUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AMDRecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "AMD";
    private final DateFormat voidDateFormat = new SimpleDateFormat("ddMMM", Locale.US);

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(AMDParameters.RETRANS);
        result.add(AMDParameters.DOM);
        result.add(AMDParameters.AIRSEQ);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.AIRSEC);
        result.add(AbstractRecordProcessor.Separator.SLASH);
        result.add(AMDParameters.AIRTOTAL);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.ACTTAG);
        result.add(AMDParameters.DATE);
        result.add(AbstractRecordProcessor.Separator.SEMICOLON);
        result.add(AMDParameters.AGTSIN);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        result.add(AMDParameters.NETID_1);
        result.add(AMDParameters.ADDRTKT_1);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.NETID_2);
        result.add(AMDParameters.ADDRTKT_2);
        result.add(AbstractRecordProcessor.Separator.SEMICOLON);
        result.add(AMDParameters.IDENTBOS);
        result.add(AbstractRecordProcessor.Separator.SEMICOLON);
        result.add(AMDParameters.BOSTYPE);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        result.add(AMDParameters.CTYID);
        result.add(AMDParameters.AIRCDE);
        result.add(AMDParameters.RECLOC);
        result.add(AMDParameters.PNRENV);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.TOTPSG);
        result.add(AMDParameters.AIRPSG);
        result.add(AMDParameters.HNPNR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.IDBKG);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.BKGAGCY);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.IDFIRST);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.OWNAGY);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.IDENTCO);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.CURAGCY);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.IDENTT);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.TKTAGCY);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.OFFID);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.CPNID);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.IDENTT2);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.TKTAGCY2);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.OFFID2);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.CPNID2);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.IDENTT3);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.TKTAGCY3);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.OFFID3);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.CPNID3);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.IDENTT4);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.TKTAGCY4);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.OFFID4);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.CPNID4);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.IDENTT5);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.TKTAGCY5);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.OFFID5);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.CPNID5);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.ACCTNUM);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.ORDNUM);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.ERSP);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(AMDParameters.NSAIR);
        result.add(AMDParameters.NSRECLOCAIR);
        result.add(AbstractRecordProcessor.Separator.SEMICOLON);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        Header header = result.getHeader();
        if (parameter instanceof AMDParameters) {
            switch ((AMDParameters)parameter) {
                case ADDRTKT_1: {
                    if (TextUtil.isBlank((String)value)) break;
                    header.setRequestingTerminalId(Integer.parseInt(value));
                    break;
                }
                case ADDRTKT_2: {
                    if (TextUtil.isBlank((String)value)) break;
                    header.setActivatingTerminalId(Integer.parseInt(value));
                    break;
                }
                case RECLOC: {
                    header.setPnrRecordLocator(value);
                    break;
                }
                case TOTPSG: {
                    if (StringUtils.isEmpty((String)value)) break;
                    header.setPnrNumberOfPassengers(Integer.parseInt(value));
                    break;
                }
                case AIRPSG: {
                    if (TextUtil.isBlank((String)value)) break;
                    header.setAirNumberOfPassengers(Integer.parseInt(value));
                    break;
                }
                case IDENTCO: {
                    header.setCurrentOwnerOfficeID(value);
                    break;
                }
                case CURAGCY: {
                    header.setCurrentOwnerIATANumber(value);
                    break;
                }
                case IDENTT: {
                    if (TextUtil.isBlank((String)value)) break;
                    header.setTicketingAgencyOfficeID(value);
                    break;
                }
                case TKTAGCY: {
                    if (TextUtil.isBlank((String)value)) break;
                    header.setTicketingAgencyIATANumber(value);
                    break;
                }
                case ACTTAG: {
                    header.setVoided(value.equals("VOID"));
                    break;
                }
                case DATE: {
                    if (!header.isVoided()) break;
                    try {
                        header.setVoidDate(MiscUtil.setToDate((Date)AirFileUtils.correctYear(this.voidDateFormat.parse(value)), (int)12, (int)11));
                        break;
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                case NSRECLOCAIR: {
                    header.setNsRecordLocator(value);
                    break;
                }
            }
        }
    }

    private static enum AMDParameters implements AbstractRecordProcessor.IValue
    {
        RETRANS(1, true, true),
        DOM(2, true, true),
        AIRSEQ(8, true, true),
        AIRSEC(2, false, false),
        AIRTOTAL(2, false, false),
        ACTTAG(4, false, true),
        DATE(5, false, true),
        AGTSIN(4, false, true),
        NETID_1(2, true, true),
        ADDRTKT_1(8, true, false),
        NETID_2(2, true, true),
        ADDRTKT_2(8, true, false),
        IDENTBOS(9, false, false),
        BOSTYPE(3, false, true),
        CTYID(3, true, true),
        AIRCDE(3, true, true),
        RECLOC(6, true, true),
        PNRENV(3, true, true),
        TOTPSG(2, true, true),
        AIRPSG(2, true, true),
        HNPNR(1, false, true),
        IDBKG(9, false, false),
        BKGAGCY(8, false, false),
        IDFIRST(9, false, false),
        OWNAGY(8, false, false),
        IDENTCO(9, false, false),
        CURAGCY(8, false, false),
        IDENTT(9, false, false),
        TKTAGCY(8, false, false),
        OFFID(2, false, true),
        CPNID(15, false, false),
        IDENTT2(9, false, false),
        TKTAGCY2(8, false, false),
        OFFID2(2, false, true),
        CPNID2(15, false, false),
        IDENTT3(9, false, false),
        TKTAGCY3(8, false, false),
        OFFID3(2, false, true),
        CPNID3(15, false, false),
        IDENTT4(9, false, false),
        TKTAGCY4(8, false, false),
        OFFID4(2, false, true),
        CPNID4(15, false, false),
        IDENTT5(9, false, false),
        TKTAGCY5(8, false, false),
        OFFID5(2, false, true),
        CPNID5(15, false, false),
        ACCTNUM(10, false, false),
        ORDNUM(10, false, false),
        ERSP(8, false, false),
        NSAIR(3, false, true),
        NSRECLOCAIR(7, false, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private AMDParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

