/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.Fare;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ATC_RecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "ATC-";
    private String previousCurrency;

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(ATC_Parameters.OCURCOD1);
        result.add(ATC_Parameters.OBASE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(ATC_Parameters.OCURCOD2);
        result.add(ATC_Parameters.NBASE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(ATC_Parameters.RCURCOD);
        result.add(ATC_Parameters.BBASE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) throws AbstractRecordProcessor.StopProcessingException {
        Fare fare = result.getFare();
        if (fare == null) {
            fare = new Fare();
            result.setFare(fare);
        }
        if (parameter instanceof ATC_Parameters) {
            switch ((ATC_Parameters)parameter) {
                case RCURCOD: {
                    if (!TextUtil.nonBlank((String)value)) break;
                    this.previousCurrency = value.trim();
                    break;
                }
                case BBASE: {
                    if (!TextUtil.nonBlank((String)value)) break;
                    fare.setFareCollectedAmount(MoneyHelper.buildMoney((String)value.trim(), (String)this.previousCurrency));
                    break;
                }
            }
        }
    }

    private static enum ATC_Parameters implements AbstractRecordProcessor.IValue
    {
        OCURCOD1(3, false, true),
        OBASE(11, false, true),
        OCURCOD2(3, false, true),
        NBASE(11, false, true),
        RCURCOD(3, false, true),
        BBASE(12, false, true);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private ATC_Parameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

