/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.ValidatingCarrier;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class A_RecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "A-";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(A_Parameters.TKTAIR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(A_Parameters.ALCDE);
        result.add(A_Parameters.NUMCDE);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        ValidatingCarrier carrier = result.getValidatingCarrier();
        if (carrier == null) {
            carrier = new ValidatingCarrier();
            result.setValidatingCarrier(carrier);
        }
        if (parameter instanceof A_Parameters) {
            switch ((A_Parameters)parameter) {
                case ALCDE: {
                    carrier.setAirlineCode(value);
                    break;
                }
                case NUMCDE: {
                    carrier.setAirlineNumbericNumber(value);
                    break;
                }
            }
        }
    }

    private static enum A_Parameters implements AbstractRecordProcessor.IValue
    {
        TKTAIR(24, true, false),
        ALCDE(3, true, true),
        NUMCDE(4, true, true);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private A_Parameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

