/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.Fare;
import com.gridnine.xtrip.common.parsers.model.amadeus.Tax;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractFareRecordProcessor
extends AbstractRecordProcessor {
    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(FareParameters.ISSUE);
        result.add(FareParameters.CURRTYP);
        result.add(FareParameters.BASE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(FareParameters.CURCODE);
        result.add(FareParameters.EQVAMT);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        for (int i = 0; i < 10; ++i) {
            result.add(FareParameters.OTAXI);
            result.add(FareParameters.TCURR);
            result.add(FareParameters.TAXA);
            result.add(FareParameters.TAXC);
            result.add(FareParameters.TAXN);
            result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        }
        result.add(FareParameters.CURRCDE);
        result.add(FareParameters.TOTAMT);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(FareParameters.SELLBUY1);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(FareParameters.SELLBUY2);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(FareParameters.TRANCURR);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) throws AbstractRecordProcessor.StopProcessingException {
        Fare fare = result.getFare();
        if (fare == null) {
            fare = new Fare();
            result.setFare(fare);
        }
        if (parameter instanceof FareParameters) {
            switch ((FareParameters)parameter) {
                case ISSUE: {
                    if (TextUtil.isBlank((String)value)) {
                        throw new AbstractRecordProcessor.StopProcessingException(this);
                    }
                    fare.setIssue(value);
                    break;
                }
                case CURRTYP: {
                    fare.setBaseCurrencyCode(value);
                    break;
                }
                case BASE: {
                    if (!TextUtil.isBlank((String)value)) {
                        fare.setBaseFare(new BigDecimal(value));
                        break;
                    }
                    fare.setBaseFare(BigDecimal.ZERO);
                    break;
                }
                case CURCODE: {
                    fare.setEquivalentCurrencyCode(value);
                    break;
                }
                case EQVAMT: {
                    if (value.isEmpty()) break;
                    fare.setEquivalentFare(new BigDecimal(value));
                    break;
                }
                case OTAXI: {
                    Tax tax = new Tax();
                    tax.setTaxIndicator(value);
                    fare.getTaxes().add(tax);
                    break;
                }
                case TCURR: {
                    this.getTax(fare).setCurrency(value);
                    break;
                }
                case TAXA: {
                    this.getTax(fare).setTaxAmount(new BigDecimal(value));
                    break;
                }
                case TAXC: {
                    this.getTax(fare).setTaxCode(value);
                    break;
                }
                case TAXN: {
                    this.getTax(fare).setNatureCode(value);
                    break;
                }
                case CURRCDE: {
                    fare.setTotalCurrencyCode(value);
                    break;
                }
                case TOTAMT: {
                    fare.setTotalAmount(new BigDecimal(value));
                    break;
                }
                case SELLBUY1: {
                    fare.setSellbuy1(new BigDecimal(value));
                    break;
                }
                case SELLBUY2: {
                    fare.setSellbuy2(new BigDecimal(value));
                    break;
                }
                case TRANCURR: {
                    fare.setTransitionalCurrencyCode(value.isEmpty() ? null : value);
                    break;
                }
            }
        }
    }

    private Tax getTax(Fare fare) {
        if (!fare.getTaxes().isEmpty()) {
            return (Tax)fare.getTaxes().get(fare.getTaxes().size() - 1);
        }
        throw Xeption.forDeveloper((String)"Tax not found", (Object[])new Object[0]);
    }

    private static enum FareParameters implements AbstractRecordProcessor.IValue
    {
        ISSUE(1, true, true),
        CURRTYP(3, false, true),
        BASE(11, true, true),
        CURCODE(3, false, true),
        EQVAMT(11, false, true),
        OTAXI(1, false, true),
        TCURR(3, false, true),
        TAXA(7, false, true),
        TAXC(3, false, true),
        TAXN(2, false, true),
        CURRCDE(3, false, true),
        TOTAMT(11, true, true),
        SELLBUY1(11, false, true),
        SELLBUY2(11, false, true),
        TRANCURR(3, false, true);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private FareParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

