/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.IProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractRecordProcessor
implements IProcessor {
    protected static final List<IParameter> EMPTY_PARAMETER_LIST = Collections.unmodifiableList(new ArrayList(0));

    public abstract int getTagLength();

    public abstract String getTagName();

    public abstract boolean isEnd();

    protected abstract List<IParameter> getRecordParameters();

    private void processString(IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) throws StopProcessingException {
        this.processValue(parameter, value.trim(), result, context, ctx);
    }

    protected abstract void processValue(IValue var1, String var2, AirFile var3, Map<String, Object> var4, MessageContext var5) throws StopProcessingException;

    @Override
    public void process(BufferedReader reader, AirFile result, MessageContext ctx) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public void process(BufferedReader reader, AirFile result, Map<String, Object> context, MessageContext ctx) throws IOException {
        Iterator<IParameter> parameters = this.getRecordParameters().iterator();
        try {
            block2: while (parameters.hasNext()) {
                IParameter parameter = parameters.next();
                if (parameter.mandatory()) {
                    this.processMandatoryParameter(parameter, reader, result, parameters, context, ctx);
                    continue;
                }
                if (parameter instanceof ISeparator && !parameter.mandatory()) {
                    reader.mark(1);
                    String prefix = this.read(reader, 1);
                    reader.reset();
                    if (!prefix.equals(String.valueOf(((ISeparator)parameter).value()))) {
                        while (true) {
                            if (parameter.mandatory()) continue block2;
                            parameter = parameters.next();
                        }
                    }
                }
                ArrayList<IParameter> parametersList = new ArrayList<IParameter>();
                boolean isFinished = false;
                do {
                    parametersList.add(parameter);
                    parameter = parameters.next();
                    if (!(parameter instanceof ISeparator)) continue;
                    isFinished = ((ISeparator)parameter).mandatory();
                } while (parameters.hasNext() && !isFinished);
                this.processNonMandatoryParameters(parametersList, reader, (ISeparator)parameter, result, context, ctx);
            }
            return;
        }
        catch (StopProcessingException stopProcessingException) {
            // empty catch block
        }
    }

    private void processNonMandatoryParameters(List<IParameter> parameters, Reader reader, ISeparator separator, AirFile result, Map<String, Object> context, MessageContext ctx) throws IOException, StopProcessingException {
        char c;
        StringBuilder content = new StringBuilder();
        while ((c = (char)reader.read()) != separator.value()) {
            content.append(c);
        }
        this.processNonMandatoryParameters(parameters, content.toString(), result, context, ctx);
    }

    private void processNonMandatoryParameters(List<IParameter> parameters, String content, AirFile result, Map<String, Object> context, MessageContext ctx) throws StopProcessingException {
        if (content.length() > 0) {
            Iterator<IParameter> iterator = parameters.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                IParameter parameter = iterator.next();
                if (parameter instanceof ISeparator) {
                    ++index;
                    continue;
                }
                if (!(parameter instanceof IValue)) continue;
                IValue value = (IValue)parameter;
                if (value.fixedLength()) {
                    int length = Math.min(content.length() - index, value.maxLength());
                    if (length <= 0) continue;
                    this.processString(value, content.substring(index, index + length), result, context, ctx);
                    if (content.length() - (index += length) != 0) continue;
                    break;
                }
                if (!iterator.hasNext()) {
                    this.processString(value, content.substring(index), result, context, ctx);
                    continue;
                }
                IParameter next = iterator.next();
                if (next instanceof ISeparator) {
                    ISeparator separator = (ISeparator)next;
                    int lastIndex = content.indexOf(separator.value(), index);
                    if (lastIndex <= -1 || lastIndex < index) {
                        if (content.length() <= index) break;
                        this.processString(value, content.substring(index), result, context, ctx);
                        break;
                    }
                    this.processString(value, content.substring(index, lastIndex), result, context, ctx);
                    index = lastIndex + 1;
                    if (content.length() - index != 0) continue;
                    break;
                }
                throw new IllegalStateException();
            }
        }
    }

    private void processMandatoryParameter(IParameter parameter, BufferedReader reader, AirFile result, Iterator<IParameter> parameters, Map<String, Object> context, MessageContext ctx) throws IOException, StopProcessingException {
        if (parameter instanceof IValue) {
            IValue value = (IValue)parameter;
            String content = null;
            if (value.fixedLength()) {
                content = this.read(reader, value.maxLength());
            } else {
                char c;
                ISeparator separator = (ISeparator)parameters.next();
                StringBuilder contentBuilder = new StringBuilder();
                while ((c = (char)reader.read()) != separator.value() && !(!separator.mandatory() ? c == Separator.CARRIAGE_RETURN.value() || c == Separator.MANDATORY_SEMICOLON.value() : c == Separator.CARRIAGE_RETURN.value())) {
                    contentBuilder.append(c);
                }
                if (c != separator.value()) {
                    IParameter next;
                    while (parameters.hasNext() && (!((next = parameters.next()) instanceof ISeparator) || ((ISeparator)next).value() != c)) {
                    }
                }
                content = contentBuilder.toString();
            }
            this.processString(value, content, result, context, ctx);
        } else if (parameter instanceof ISeparator) {
            ISeparator separator = (ISeparator)parameter;
            String content = this.read(reader, 1);
            if (content.equals("\r")) {
                content = this.read(reader, 1);
            }
            if (!String.valueOf(separator.value()).equals(content)) {
                throw new IllegalStateException();
            }
        }
    }

    protected String read(Reader reader, int length) throws IOException {
        char[] content = new char[length];
        reader.read(content);
        return String.valueOf(content);
    }

    public boolean skipNextLine() {
        List<IParameter> parameters = this.getRecordParameters();
        if (parameters.size() > 0) {
            return parameters.get(parameters.size() - 1) == Separator.CARRIAGE_RETURN;
        }
        return false;
    }

    public String[] getPossibleConflicts() {
        return new String[0];
    }

    public boolean isAppropriateLine(Reader reader) throws IOException {
        return true;
    }

    public static enum Separator implements ISeparator
    {
        MANDATORY_SEMICOLON(';', true),
        SLASH('/', false),
        CARRIAGE_RETURN('\n', true),
        SEMICOLON(';', false),
        MANDATORY_SPACE(' ', true),
        MANDATORY_MINUS('-', true),
        MINUS('-', false),
        COMMA(',', false),
        BRACKET_OPEN('(', false),
        BRACKET_CLOSE(')', false);

        private final char value;
        private final boolean mandatory;

        private Separator(char value, boolean mandatory) {
            this.value = value;
            this.mandatory = mandatory;
        }

        @Override
        public char value() {
            return this.value;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }
    }

    public static interface ISeparator
    extends IParameter {
        public char value();
    }

    public static interface IValue
    extends IParameter {
        public int maxLength();

        public boolean fixedLength();
    }

    public static interface IParameter {
        public boolean mandatory();
    }

    protected class StopProcessingException
    extends Exception {
        private static final long serialVersionUID = -7797031030988464700L;

        protected StopProcessingException() {
        }
    }
}

