/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.Fare;
import com.gridnine.xtrip.common.parsers.model.amadeus.Tax;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractTaxProcessor
extends AbstractRecordProcessor {
    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        for (int i = 0; i < this.getRepeatCount(); ++i) {
            if (this.hasTaxTag()) {
                result.add(TaxParameters.TAXTAG);
            }
            result.add(TaxParameters.OTAXI);
            result.add(TaxParameters.TCURR);
            result.add(TaxParameters.TAXA);
            result.add(TaxParameters.TAXC);
            result.add(TaxParameters.TAXN);
            result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        }
        return result;
    }

    protected abstract int getRepeatCount();

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        Fare fare = result.getFare();
        if (fare == null) {
            fare = new Fare();
            result.setFare(fare);
        }
        if (parameter instanceof TaxParameters) {
            if (parameter == this.enumToAdd()) {
                this.addTax(fare, new Tax());
            }
            switch ((TaxParameters)parameter) {
                case OTAXI: {
                    this.getTax(fare).setTaxIndicator(value.isEmpty() ? " " : value);
                    break;
                }
                case TCURR: {
                    this.getTax(fare).setCurrency(value);
                    break;
                }
                case TAXA: {
                    this.getTax(fare).setTaxAmount(TextUtil.isBlank((String)value) ? BigDecimal.ZERO : new BigDecimal(value));
                    break;
                }
                case TAXC: {
                    this.getTax(fare).setTaxCode(value);
                    break;
                }
                case TAXN: {
                    this.getTax(fare).setNatureCode(value);
                    break;
                }
            }
        }
    }

    protected abstract TaxParameters enumToAdd();

    protected abstract void addTax(Fare var1, Tax var2);

    protected abstract Tax getTax(Fare var1);

    protected boolean hasTaxTag() {
        return false;
    }

    protected static enum TaxParameters implements AbstractRecordProcessor.IValue
    {
        TAXTAG(2, false, true),
        OTAXI(1, false, true),
        TCURR(3, false, true),
        TAXA(9, false, true),
        TAXC(3, false, true),
        TAXN(2, false, true);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private TaxParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

