/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.TimeService;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AirFileUtils {
    private static final Logger log = LoggerFactory.getLogger(AirFileUtils.class);

    private AirFileUtils() {
    }

    public static Date correctYear(Date originalDate, Date dateWithYear) {
        Calendar calendarWithYear = DateUtils.toCalendar((Date)dateWithYear);
        return DateUtils.setYears((Date)originalDate, (int)calendarWithYear.get(1));
    }

    public static Date correctYear(Date originalDate) {
        Date currentDate = ((TimeService)Environment.getPublished(TimeService.class)).currentDate();
        Date originalWithCurrentYear = AirFileUtils.correctYear(originalDate, currentDate);
        if (originalWithCurrentYear.after(currentDate)) {
            originalWithCurrentYear = DateUtils.addYears((Date)originalWithCurrentYear, (int)-1);
        }
        return originalWithCurrentYear;
    }

    public static Date getDate(String value, DateFormat format, boolean correctYear) {
        if (!StringUtils.isEmpty((String)value)) {
            try {
                Date result = format.parse(value);
                if (correctYear) {
                    result = AirFileUtils.correctYear(result);
                }
                return result;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public static Money getMoney(String currency, String amount) {
        try {
            Money result = new Money();
            result.setCurrency(currency);
            result.setValue(TextUtil.isBlank((String)amount) ? BigDecimal.ZERO : new BigDecimal(amount));
            return result;
        }
        catch (NumberFormatException e) {
            log.error(String.format("failed to determine amount from value %s", amount));
            return null;
        }
    }
}

