/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.Tax;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.FileProcessor;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.activemq.util.ByteArrayInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class AmadeusAirFileParserProcessor
extends BaseProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageContext ctx) throws Exception {
        AirFile result = new AirFile();
        byte[] content = (byte[])ctx.getMandatoryObject((Enum)IBusParsersContextKeys.DOCUMENT_CONTENT);
        String contentStr = new String(content);
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(contentStr.split("\n")));
        boolean changed = lines.removeIf(it -> it.startsWith("I-GRP") || it.startsWith("SSR") && !it.startsWith("SSR DOCS") && !it.startsWith("SSR FQTV"));
        String line2 = (String)lines.get(2);
        if (line2.startsWith(";;AIR")) {
            lines.set(2, "000000000;000000000;000000000;AIR");
            changed = true;
        }
        for (int n = 0; n < lines.size(); ++n) {
            String line = (String)lines.get(n);
            if (line.startsWith("C-") && line.length() > 8 && line.charAt(8) == '-') {
                lines.set(n, line.substring(0, 8) + line.substring(9));
                changed = true;
            }
            if (line.startsWith("T-") && line.length() <= 3) {
                lines.remove(n);
                changed = true;
                --n;
            }
            if (!line.startsWith("MFP")) continue;
            if (StringUtils.countMatches((String)line, (String)";") == 1) {
                line = line.replace(";", ";;;");
                lines.set(n, line);
            }
            changed = true;
        }
        if (changed) {
            content = TextUtil.join((String)"\n", lines).getBytes();
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(content)));
            new FileProcessor().process(reader, result, ctx);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        if (result.getRefund() != null && result.getFare() != null) {
            for (Tax tax : result.getFare().getRefundableTaxes()) {
                if (!"CP".equals(tax.getTaxCode())) continue;
                if (result.getRefund().getCancellationFee() == null) {
                    Money money = new Money();
                    money.setCurrency(tax.getCurrency());
                    money.setValue(tax.getTaxAmount());
                    result.getRefund().setCancellationFee(money);
                }
                result.getFare().getRefundableTaxes().remove(tax);
                break;
            }
        }
        ctx.putObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE, (Object)result);
    }
}

