/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.ServicingCarrier;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class C_RecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "C-";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(C_Parameters.SVCCAR);
        result.add(C_Parameters.TKTIND);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SPACE);
        result.add(C_Parameters.BKAGT);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_MINUS);
        result.add(C_Parameters.TKTAGT);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_MINUS);
        result.add(C_Parameters.PRCDE);
        result.add(AbstractRecordProcessor.Separator.MINUS);
        result.add(C_Parameters.FCMI);
        result.add(AbstractRecordProcessor.Separator.MINUS);
        result.add(C_Parameters.JRNYTYPE);
        result.add(AbstractRecordProcessor.Separator.MINUS);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        ServicingCarrier carrier = result.getServicingCarrier();
        if (carrier == null) {
            carrier = new ServicingCarrier();
            result.setServicingCarrier(carrier);
        }
        if (parameter instanceof C_Parameters) {
            switch ((C_Parameters)parameter) {
                case BKAGT: {
                    carrier.setPnrCreatorAgentSine(this.removeDutyCode(value));
                    break;
                }
                case TKTAGT: {
                    carrier.setTicketingAgentSine(this.removeDutyCode(value));
                    break;
                }
                case PRCDE: 
                case JRNYTYPE: {
                    result.setNdc(false);
                    break;
                }
                case FCMI: {
                    if (!result.isNdc()) break;
                    result.setNdc("0".equals(value) || "1".equals(value));
                    break;
                }
            }
        }
    }

    private String removeDutyCode(String value) {
        if (value == null) {
            return null;
        }
        String correctedValue = value.trim();
        return correctedValue.length() == 8 ? correctedValue.substring(0, 6) : correctedValue;
    }

    private static enum C_Parameters implements AbstractRecordProcessor.IValue
    {
        SVCCAR(4, true, true),
        TKTIND(1, true, true),
        BKAGT(8, true, true),
        TKTAGT(8, false, true),
        PRCDE(1, false, true),
        FCMI(1, false, true),
        JRNYTYPE(1, false, true);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private C_Parameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

