/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.PNRDate;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class D_RecordProcessor
extends AbstractRecordProcessor {
    private static final long HOUR = 3600000L;
    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
    private static final String RECORD_NAME = "D-";
    private final DateFormat dateFormat = new SimpleDateFormat("yyMMdd", Locale.US);

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(D_Parameters.PNRDTE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(D_Parameters.CHNGDTE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(D_Parameters.AIRDTE);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        PNRDate pnrDate = result.getPnrDate();
        if (pnrDate == null) {
            pnrDate = new PNRDate();
            result.setPnrDate(pnrDate);
        }
        if (parameter instanceof D_Parameters) {
            Date date = this.getDate(value);
            if (this.sdf.format(date).equals("00:00")) {
                date = new Date(date.getTime() + 43200000L);
            }
            switch ((D_Parameters)parameter) {
                case AIRDTE: {
                    pnrDate.setAirCreationDate(date);
                    break;
                }
                case CHNGDTE: {
                    pnrDate.setChangeDate(date);
                    break;
                }
                case PNRDTE: {
                    pnrDate.setCreationDate(date);
                    break;
                }
            }
        }
    }

    private Date getDate(String value) {
        try {
            return this.dateFormat.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static enum D_Parameters implements AbstractRecordProcessor.IValue
    {
        PNRDTE(6, true, true),
        CHNGDTE(6, true, true),
        AIRDTE(6, true, true);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private D_Parameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

