/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.google.common.collect.Iterables;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.EMDSegment;
import com.gridnine.xtrip.common.parsers.model.amadeus.Fare;
import com.gridnine.xtrip.common.parsers.model.amadeus.Tax;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractTaxProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AirFileUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EMDRecordProcessor
extends AbstractTaxProcessor {
    private static final String RECORD_NAME = "EMD";
    public static final String EMD_SEGMENT_OBJECT = "EMD_SEGMENT_OBJECT";
    private EMDSegment currentSegment;
    private String previousCurrency;
    private final DateFormat dayMonthDateFormat = new SimpleDateFormat("ddMMM", Locale.US);
    private final DateFormat dayMonthYearDateFormat = new SimpleDateFormat("ddMMMyy", Locale.US);

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        int i;
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(EMDParameters.TTONBR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.ELMNBR);
        result.add(EMDParameters.AIRCDE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.NUMAIR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.ISSAIR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.PRCNDATE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.TSDID);
        result.add(EMDParameters.TSDNBR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.EMDCPN);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.OPECAR_1);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.OPECAR_2);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.FEEOWN);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.ORIGIN);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.DESTIN);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.TOTAG);
        result.add(EMDParameters.TOINFO);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.ATTAG);
        result.add(EMDParameters.ATINFO);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.EMDTYPE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.REASON);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.RFICDESC);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.RFISC);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.RFISCDESC);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.DOCRMKRS);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.SVCRMKS);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.NVBDATE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.NVADATE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.XSBTOTAL);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.XSBQUALIF);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.CURCODE_1);
        result.add(EMDParameters.XSBRATE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.CPVALTAG);
        result.add(EMDParameters.CPNVALUE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.ISSUE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.CURCODE_2);
        result.add(EMDParameters.BASE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.TAX);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.CURCODE_3);
        result.add(EMDParameters.EQVAMNT);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.CURCODE_4);
        result.add(EMDParameters.EXCHVAL);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.CURCODE_5);
        result.add(EMDParameters.RFNDVAL);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.addAll(super.getRecordParameters());
        result.add(EMDParameters.CURCODE_6);
        result.add(EMDParameters.TOTAMT);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.SELLBUY1);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.CURCODE_7);
        result.add(EMDParameters.NETFARE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(EMDParameters.INTIND);
        result.add(AbstractRecordProcessor.Separator.SEMICOLON);
        result.add(EMDSeparator.P);
        for (i = 0; i < 99; ++i) {
            result.add(EMDParameters.PSGNBR_1);
            result.add(AbstractRecordProcessor.Separator.MINUS);
            result.add(EMDParameters.PSGNBR_2);
            result.add(AbstractRecordProcessor.Separator.COMMA);
        }
        result.add(AbstractRecordProcessor.Separator.SEMICOLON);
        result.add(EMDSeparator.S);
        for (i = 0; i < 99; ++i) {
            result.add(EMDParameters.SEGNBR_1);
            result.add(AbstractRecordProcessor.Separator.MINUS);
            result.add(EMDParameters.SEGNBR_2);
        }
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        EMDSegment segment = new EMDSegment();
        if (!result.getEmdSegments().isEmpty()) {
            segment = (EMDSegment)Iterables.getLast((Iterable)result.getEmdSegments());
        }
        context.put(EMD_SEGMENT_OBJECT, segment);
        this.currentSegment = segment;
        if (parameter instanceof EMDParameters) {
            switch ((EMDParameters)parameter) {
                case TTONBR: {
                    segment = new EMDSegment();
                    context.put(EMD_SEGMENT_OBJECT, segment);
                    result.getEmdSegments().add(segment);
                    segment.setTattooNumberInPNR(Integer.parseInt(value));
                    break;
                }
                case ELMNBR: {
                    segment.setElementNumberInPNR(Integer.parseInt(value));
                    break;
                }
                case AIRCDE: {
                    segment.setAirlineCode(value);
                    break;
                }
                case NUMAIR: {
                    segment.setValidatingAirlineCode(value);
                    break;
                }
                case ISSAIR: {
                    segment.setValidatingAirlineName(value);
                    break;
                }
                case PRCNDATE: {
                    segment.setPricingRecordCreationDate(AirFileUtils.getDate(value, this.dayMonthDateFormat, true));
                    break;
                }
                case TSDID: {
                    if (value.equals("D")) break;
                    throw new IllegalArgumentException("TSDID value should be 'D'");
                }
                case TSDNBR: {
                    segment.setTsmNumber(value);
                    break;
                }
                case EMDCPN: {
                    segment.setEmdCouponNumber(value);
                    break;
                }
                case OPECAR_1: {
                    segment.setMarketingCarrierAirlineCode(value);
                    break;
                }
                case OPECAR_2: {
                    segment.setServicingCarrierAirlineCode(value);
                    break;
                }
                case FEEOWN: {
                    segment.setCarrierFeeOwner(value);
                    break;
                }
                case ORIGIN: {
                    segment.setOriginCityCode(value);
                    break;
                }
                case DESTIN: {
                    segment.setDestinationCityCode(value);
                    break;
                }
                case TOTAG: {
                    if (value.equals("TO-")) break;
                    throw new IllegalArgumentException("TOTAG value should be 'TO-'");
                }
                case TOINFO: {
                    segment.setTo(value);
                    break;
                }
                case ATTAG: {
                    if (value.equals("AT-")) break;
                    throw new IllegalArgumentException("ATTAG value should be 'AT-'");
                }
                case ATINFO: {
                    segment.setAt(value);
                    break;
                }
                case EMDTYPE: {
                    segment.setEmdType(value);
                    break;
                }
                case REASON: {
                    segment.setReasonCode(value);
                    break;
                }
                case RFICDESC: {
                    segment.setReasonDescription(value);
                    break;
                }
                case RFISC: {
                    segment.setReasonSubCode(value);
                    break;
                }
                case RFISCDESC: {
                    segment.setReasonSubCodeDescription(value);
                    break;
                }
                case DOCRMKRS: {
                    segment.setEmdRemarks(value);
                    break;
                }
                case SVCRMKS: {
                    segment.setServiceRemarks(value);
                    break;
                }
                case NVBDATE: {
                    segment.setNotValidBeforeDate(AirFileUtils.getDate(value, this.dayMonthYearDateFormat, false));
                    break;
                }
                case NVADATE: {
                    segment.setNotValidAfterDate(AirFileUtils.getDate(value, this.dayMonthYearDateFormat, false));
                    break;
                }
                case XSBTOTAL: {
                    segment.setExcessBaggageTotalNumber(value);
                    break;
                }
                case XSBQUALIF: {
                    segment.setExcessBaggageChargeQualifier(value);
                    break;
                }
                case CURCODE_1: 
                case CURCODE_2: 
                case CURCODE_3: 
                case CURCODE_4: 
                case CURCODE_5: 
                case CURCODE_6: 
                case CURCODE_7: {
                    this.previousCurrency = value;
                    break;
                }
                case XSBRATE: {
                    segment.setExceessBaggageRatePerUnit(AirFileUtils.getMoney(this.previousCurrency, value));
                    break;
                }
                case CPVALTAG: {
                    if (value.equals("CV-")) break;
                    throw new IllegalArgumentException("CPVALTAG value should be 'CV-'");
                }
                case CPNVALUE: {
                    segment.setCoupon(value);
                    break;
                }
                case ISSUE: {
                    segment.setIssueIdentifier(value);
                    break;
                }
                case BASE: {
                    segment.setTotalBaseAmount(AirFileUtils.getMoney(this.previousCurrency, value));
                    break;
                }
                case TAX: {
                    segment.setTaxIncludedInBaseFare(value.equals("Y"));
                    break;
                }
                case EQVAMNT: {
                    segment.setEquivalentAmount(AirFileUtils.getMoney(this.previousCurrency, value));
                    break;
                }
                case EXCHVAL: {
                    segment.setExchangeAmount(AirFileUtils.getMoney(this.previousCurrency, value));
                    break;
                }
                case RFNDVAL: {
                    segment.setRefundableAmount(AirFileUtils.getMoney(this.previousCurrency, value));
                    break;
                }
                case TOTAMT: {
                    segment.setTotalCollectedAmount(AirFileUtils.getMoney(this.previousCurrency, value));
                    break;
                }
                case SELLBUY1: {
                    if (TextUtil.isBlank((String)value)) break;
                    segment.setSellbuy(new BigDecimal(value));
                    break;
                }
                case NETFARE: {
                    segment.setNetFareAmount(AirFileUtils.getMoney(this.previousCurrency, value));
                    break;
                }
                case INTIND: {
                    segment.setInternationalIndicator(value);
                    break;
                }
                case PSGNBR_1: {
                    Pattern p;
                    Matcher m;
                    if (TextUtil.isBlank((String)value)) break;
                    String correctedValue = value;
                    int idx = value.indexOf(";");
                    if (idx != -1) {
                        correctedValue = value.substring(0, idx);
                    }
                    if (!(m = (p = Pattern.compile("[0-9]+")).matcher(correctedValue)).find()) break;
                    segment.getPassengerNumbers().add(Integer.parseInt(m.group(0)));
                    break;
                }
                case PSGNBR_2: {
                    int passStart = (Integer)Iterables.getLast((Iterable)segment.getPassengerNumbers());
                    int passEnd = Integer.parseInt(value);
                    for (int i = passStart + 1; i <= passEnd; ++i) {
                        segment.getPassengerNumbers().add(i);
                    }
                    break;
                }
                case SEGNBR_1: {
                    segment.getSegmentNumbers().add(Integer.valueOf(value));
                    break;
                }
                case SEGNBR_2: {
                    int segStart = (Integer)Iterables.getLast((Iterable)segment.getSegmentNumbers());
                    int segEnd = Integer.parseInt(value);
                    for (int i = segStart + 1; i <= segEnd; ++i) {
                        segment.getSegmentNumbers().add(i);
                    }
                    break;
                }
            }
        }
        super.processValue(parameter, value, result, context, ctx);
    }

    @Override
    protected int getRepeatCount() {
        return 99;
    }

    @Override
    protected AbstractTaxProcessor.TaxParameters enumToAdd() {
        return AbstractTaxProcessor.TaxParameters.OTAXI;
    }

    @Override
    protected void addTax(Fare result, Tax tax) {
        this.currentSegment.getTaxes().add(tax);
    }

    @Override
    protected Tax getTax(Fare result) {
        if (this.currentSegment.getTaxes().isEmpty()) {
            return new Tax();
        }
        return (Tax)Iterables.getLast((Iterable)this.currentSegment.getTaxes());
    }

    @Override
    protected boolean hasTaxTag() {
        return true;
    }

    private static enum EMDParameters implements AbstractRecordProcessor.IValue
    {
        TTONBR(3, true, true),
        ELMNBR(3, true, true),
        AIRCDE(3, true, false),
        NUMAIR(4, true, true),
        ISSAIR(24, true, false),
        PRCNDATE(5, true, true),
        TSDID(1, false, true),
        TSDNBR(2, true, false),
        EMDCPN(2, true, false),
        OPECAR_1(2, true, true),
        OPECAR_2(2, false, true),
        FEEOWN(2, false, true),
        ORIGIN(3, false, true),
        DESTIN(3, false, true),
        TOTAG(3, true, true),
        TOINFO(62, false, false),
        ATTAG(3, true, true),
        ATINFO(62, false, false),
        EMDTYPE(1, true, true),
        REASON(1, true, true),
        RFICDESC(87, false, false),
        RFISC(3, true, true),
        RFISCDESC(87, true, false),
        DOCRMKRS(221, false, false),
        SVCRMKS(221, false, false),
        NVBDATE(7, false, true),
        NVADATE(7, false, true),
        XSBTOTAL(3, false, true),
        XSBQUALIF(2, false, true),
        CURCODE_1(3, false, true),
        XSBRATE(11, false, true),
        CPVALTAG(3, false, true),
        CPNVALUE(9, false, true),
        ISSUE(1, false, true),
        CURCODE_2(3, false, true),
        BASE(11, true, true),
        TAX(1, false, true),
        CURCODE_3(3, false, true),
        EQVAMNT(11, false, true),
        CURCODE_4(3, false, true),
        EXCHVAL(11, false, true),
        CURCODE_5(3, false, true),
        RFNDVAL(11, false, true),
        CURCODE_6(3, false, true),
        TOTAMT(11, true, true),
        SELLBUY1(11, false, true),
        CURCODE_7(3, false, true),
        NETFARE(11, false, true),
        INTIND(1, false, true),
        PSGNBR_1(2, true, false),
        PSGNBR_2(2, false, false),
        SEGNBR_1(2, true, false),
        SEGNBR_2(2, false, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private EMDParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }

    private static enum EMDSeparator implements AbstractRecordProcessor.ISeparator
    {
        S('S', false),
        P('P', false);

        private final char value;
        private final boolean mandatory;

        private EMDSeparator(char value, boolean mandatory) {
            this.value = value;
            this.mandatory = mandatory;
        }

        @Override
        public char value() {
            return this.value;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }
    }
}

