/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FERecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "FE";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        int i;
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(FEParameters.ENDORSE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(FESeparator.S);
        for (i = 0; i < 99; ++i) {
            if (i > 0) {
                result.add(AbstractRecordProcessor.Separator.COMMA);
            }
            result.add(FEParameters.SEGNBR);
        }
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(FESeparator.P);
        for (i = 0; i < 99; ++i) {
            if (i > 0) {
                result.add(AbstractRecordProcessor.Separator.COMMA);
            }
            result.add(FEParameters.PSGNBR);
        }
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        TicketData ticket = (TicketData)context.get("i_object");
        if (parameter instanceof FEParameters) {
            switch ((FEParameters)parameter) {
                case ENDORSE: {
                    ticket.setEndorsement(value);
                    break;
                }
                case SEGNBR: {
                    ticket.getSegmentNumbers().addAll(AmadeusParserHelper.parseValues(value));
                    break;
                }
                case PSGNBR: {
                    ticket.getPassengerNumbers().addAll(AmadeusParserHelper.parseValues(value));
                    break;
                }
            }
        }
    }

    private static enum FEParameters implements AbstractRecordProcessor.IValue
    {
        ENDORSE(127, true, false),
        SEGNBR(7, false, false),
        PSGNBR(5, false, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private FEParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }

    private static enum FESeparator implements AbstractRecordProcessor.ISeparator
    {
        S('S', false),
        P('P', false);

        private final char value;
        private final boolean mandatory;

        private FESeparator(char value, boolean mandatory) {
            this.value = value;
            this.mandatory = mandatory;
        }

        @Override
        public char value() {
            return this.value;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }
    }
}

