/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketedAirSegment;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FHRecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "FH";
    private String ticketNumber;
    private int segmentFrom;
    private int passengerFrom;

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        int i;
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(FHParameters.HANDTKT);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(FHSeparator.S);
        for (i = 0; i < 99; ++i) {
            result.add(FHParameters.SEGNBR_1);
            result.add(AbstractRecordProcessor.Separator.MINUS);
            result.add(FHParameters.SEGNBR_2);
            result.add(AbstractRecordProcessor.Separator.SEMICOLON);
        }
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(FHSeparator.P);
        for (i = 0; i < 99; ++i) {
            result.add(FHParameters.PSGNBR_1);
            result.add(AbstractRecordProcessor.Separator.MINUS);
            result.add(FHParameters.PSGNBR_2);
            result.add(AbstractRecordProcessor.Separator.SEMICOLON);
        }
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        if (parameter instanceof FHParameters) {
            switch ((FHParameters)parameter) {
                case HANDTKT: {
                    String correctedValue = value;
                    if (!TextUtil.isBlank((String)correctedValue) && correctedValue.length() > 10) {
                        correctedValue = correctedValue.substring(correctedValue.length() - 10);
                    }
                    this.ticketNumber = correctedValue;
                    break;
                }
                case SEGNBR_1: {
                    this.segmentFrom = Integer.valueOf(value);
                    TicketedAirSegment segmentData = this.getSegmentData(result, this.segmentFrom);
                    if (segmentData == null) break;
                    segmentData.setHandTicketNumber(this.ticketNumber);
                    break;
                }
                case SEGNBR_2: {
                    int end = Integer.parseInt(value);
                    for (int i = this.segmentFrom + 1; i <= end; ++i) {
                        TicketedAirSegment segment = this.getSegmentData(result, i);
                        if (segment == null) continue;
                        segment.setHandTicketNumber(this.ticketNumber);
                    }
                    break;
                }
                case PSGNBR_1: {
                    this.passengerFrom = Integer.valueOf(value);
                    TicketData ticketData = this.getTicketData(result, this.passengerFrom);
                    if (ticketData == null) break;
                    ticketData.setHandTicketNumber(this.ticketNumber);
                    break;
                }
                case PSGNBR_2: {
                    int end = Integer.parseInt(value);
                    for (int i = this.passengerFrom + 1; i <= end; ++i) {
                        TicketData ticket = this.getTicketData(result, i);
                        if (ticket == null) continue;
                        ticket.setHandTicketNumber(this.ticketNumber);
                    }
                    break;
                }
            }
        }
    }

    private TicketedAirSegment getSegmentData(AirFile result, int segmentNumber) {
        for (TicketedAirSegment segment : result.getTicketedAirSegments()) {
            if (segment.getNumberInPNR() != segmentNumber) continue;
            return segment;
        }
        return null;
    }

    private TicketData getTicketData(AirFile result, int passengerNumber) {
        for (TicketData ticket : result.getTickets()) {
            if (ticket.getPassenger().getNumberInPNR() != passengerNumber) continue;
            return ticket;
        }
        return null;
    }

    private static enum FHParameters implements AbstractRecordProcessor.IValue
    {
        HANDTKT(127, true, false),
        SEGNBR_1(3, false, false),
        SEGNBR_2(3, false, false),
        PSGNBR_1(2, false, false),
        PSGNBR_2(2, false, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private FHParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }

    private static enum FHSeparator implements AbstractRecordProcessor.ISeparator
    {
        S('S', false),
        P('P', false);

        private final char value;
        private final boolean mandatory;

        private FHSeparator(char value, boolean mandatory) {
            this.value = value;
            this.mandatory = mandatory;
        }

        @Override
        public char value() {
            return this.value;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }
    }
}

