/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FMRecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "FM";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        int i;
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(FMParameters.FARECOM);
        result.add(AbstractRecordProcessor.Separator.SEMICOLON);
        result.add(FMSeparator.S);
        for (i = 0; i < 99; ++i) {
            if (i > 0) {
                result.add(AbstractRecordProcessor.Separator.COMMA);
            }
            result.add(FMParameters.SEGNBR);
        }
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(FMSeparator.P);
        for (i = 0; i < 99; ++i) {
            if (i > 0) {
                result.add(AbstractRecordProcessor.Separator.COMMA);
            }
            result.add(FMParameters.PSGNBR);
        }
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        TicketData ticket = (TicketData)context.get("i_object");
        if (parameter instanceof FMParameters) {
            switch ((FMParameters)parameter) {
                case FARECOM: {
                    this.parseCommission(ticket, value);
                    break;
                }
            }
        }
    }

    private void parseCommission(TicketData ticket, String value) {
        if (TextUtil.isBlank((String)value)) {
            return;
        }
        Matcher matcher = Pattern.compile("\\D*([\\d.]+)([AP]?)").matcher(value);
        if (!matcher.matches()) {
            return;
        }
        if ("A".equals(matcher.group(2))) {
            BigDecimal commissionValue = new BigDecimal(matcher.group(1));
            ticket.setCommissionValue(commissionValue);
        } else {
            Double commissionRate = Double.valueOf(matcher.group(1));
            ticket.setCommissionRate(commissionRate);
        }
    }

    private static enum FMParameters implements AbstractRecordProcessor.IValue
    {
        FARECOM(127, true, false),
        SEGNBR(7, false, false),
        PSGNBR(5, false, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private FMParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }

    private static enum FMSeparator implements AbstractRecordProcessor.ISeparator
    {
        S('S', false),
        P('P', false);

        private final char value;
        private final boolean mandatory;

        private FMSeparator(char value, boolean mandatory) {
            this.value = value;
            this.mandatory = mandatory;
        }

        @Override
        public char value() {
            return this.value;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }
    }
}

