/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FORecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "FO";
    private static final Pattern TICKET_NUMBER_PATTERN = Pattern.compile("-(\\d{10})");
    private static final Pattern CARRIER_CODE_PATTERN = Pattern.compile("(.{3}(?=-(\\d{10})))");

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(FEParameters.ORIGEXCH);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(FEParameters.OTHER);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        if (parameter instanceof FEParameters) {
            switch ((FEParameters)parameter) {
                case ORIGEXCH: {
                    result.setOriginalIssueTicketNumber(this.extractTicketNumber(value, 0));
                    result.setOriginalIssueCarrierCode(this.extractCarrierCode(value, 0));
                    result.setInExchangeForTicketNumber(this.extractTicketNumber(value, 1));
                    result.setInExchangeForCarrierCode(this.extractCarrierCode(value, 1));
                    break;
                }
            }
        }
    }

    private String extractTicketNumber(String fullLine, int index) {
        Matcher matcher = TICKET_NUMBER_PATTERN.matcher(fullLine);
        int i = 0;
        while (matcher.find()) {
            if (i == index) {
                return matcher.group(1);
            }
            ++i;
        }
        return null;
    }

    private String extractCarrierCode(String fullLine, int index) {
        Matcher matcher = CARRIER_CODE_PATTERN.matcher(fullLine);
        int i = 0;
        while (matcher.find()) {
            if (i == index) {
                return matcher.group(0);
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isAppropriateLine(Reader reader) throws IOException {
        reader.reset();
        String firstThreeLetters = this.read(reader, 3);
        return !"FOI".equals(firstThreeLetters);
    }

    private static enum FEParameters implements AbstractRecordProcessor.IValue
    {
        ORIGEXCH(127, true, false),
        OTHER(127, false, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private FEParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

