/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FPRecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "FP";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(FPParameters.PAYMNT);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        TicketData ticket = (TicketData)context.get("i_object");
        if (parameter instanceof FPParameters) {
            switch ((FPParameters)parameter) {
                case PAYMNT: {
                    int end = value.indexOf(";");
                    String paymentLine = value;
                    if (end > -1) {
                        paymentLine = paymentLine.substring(0, end);
                    }
                    this.parsePayment(ticket, paymentLine, result, ctx);
                    break;
                }
            }
        }
    }

    private void parsePayment(TicketData ticket, String paymentLine, AirFile result, MessageContext ctx) {
        String[] parts = paymentLine.split("[/*]");
        boolean exchangeForm = parts[0].equals("DE");
        if (exchangeForm) {
            if (parts.length > 4) {
                this.parsePaymentTypes(ticket, parts, 3);
            }
        } else {
            int amountOrClientCodeIndex;
            boolean extendedForm = parts[0].equals("O");
            int creditCardOrPaymentTypeIndex = extendedForm ? 2 : 0;
            int n = amountOrClientCodeIndex = extendedForm ? 4 : 2;
            if (extendedForm) {
                this.parsePaymentTypes(ticket, parts, 1);
            }
            if (parts.length > creditCardOrPaymentTypeIndex) {
                this.processCreditCardOrPaymentType(ticket, parts, creditCardOrPaymentTypeIndex);
            }
            if (parts.length > amountOrClientCodeIndex) {
                if ("IN".equals(parts[0]) && "A".equals(parts[1])) {
                    this.processClientCode(parts[amountOrClientCodeIndex], result, ctx);
                } else {
                    this.processAmount(ticket, parts[amountOrClientCodeIndex]);
                }
            }
            if (parts.length > 1 && (parts[1].toUpperCase().startsWith("QUW") || parts[1].toUpperCase().startsWith("QUY"))) {
                String tourCode = parts[1];
                this.setContractCode(tourCode, ctx, result);
            }
        }
        String contractCode = this.matcherContractCode(parts);
        if (result.getTripartiteContractDetails() != null && result.getTripartiteContractDetails().getContractCode() == null && !TextUtil.isBlank((String)contractCode)) {
            this.setContractCode(contractCode, ctx, result);
        }
        if (result.getTripartiteContractDetails() != null && !TextUtil.isBlank((String)result.getTripartiteContractDetails().getContractCode())) {
            result.setTourCode(result.getTripartiteContractDetails().getContractCode());
        }
        LinkedHashSet uniquePaymentTypes = new LinkedHashSet(ticket.getPaymentTypes());
        ticket.getPaymentTypes().clear();
        ticket.getPaymentTypes().addAll(uniquePaymentTypes);
    }

    private int getNumberStartIndex(String line) {
        for (int i = 0; i < line.length(); ++i) {
            if (!Character.isDigit(line.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private void setContractCode(String tourCode, MessageContext ctx, AirFile result) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.tourCode.name(), (Object)tourCode));
        List contracts = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
        if (contracts.isEmpty()) {
            ctx.addMessage(MessageHelper.createWarningMessage((String)"AmadeusParser_ContractNotFound", null, (Object[])new Object[]{tourCode}));
        } else if (contracts.size() > 1) {
            ctx.addMessage(MessageHelper.createWarningMessage((String)"AmadeusParser_FewContractsFound", null, (Object[])new Object[]{tourCode}));
        } else {
            result.setCustomerProfile(((ContractCustomerIndex)contracts.get(0)).getCustomer());
            result.getTripartiteContractDetails().setContract(((ContractCustomerIndex)contracts.get(0)).getSource());
        }
        result.getTripartiteContractDetails().setContractCode(tourCode);
    }

    private String matcherContractCode(String[] allParts) {
        Pattern compile;
        Matcher matcher;
        if (allParts.length > 0 && (matcher = (compile = Pattern.compile("(^Q)\\D{1,2}\\d{5}$")).matcher(allParts[allParts.length - 1])).find()) {
            return allParts[allParts.length - 1];
        }
        return "";
    }

    private void processCreditCardOrPaymentType(TicketData ticket, String[] allParts, int index) {
        String possibleCreditCard = allParts[index];
        int cardNumberIndex = this.getNumberStartIndex(possibleCreditCard);
        if (cardNumberIndex > -1) {
            String cardNumber = possibleCreditCard.substring(cardNumberIndex);
            ticket.setCreditCardNumber(cardNumber);
            String cardType = possibleCreditCard.substring(cardNumberIndex - 2, cardNumberIndex);
            ticket.setCreditCardVendor(this.getVendor(cardType));
            String paymentTypes = possibleCreditCard.substring(0, cardNumberIndex - 2);
            ticket.getPaymentTypes().addAll(this.getPaymentTypes(paymentTypes));
        } else {
            this.parsePaymentTypes(ticket, allParts, index);
        }
    }

    private void parsePaymentTypes(TicketData ticket, String[] allParts, int index) {
        PassengerStatus mtdPassengerStatus = null;
        if (allParts.length > index + 1) {
            if ("MO".equalsIgnoreCase(allParts[index + 1])) {
                mtdPassengerStatus = PassengerStatus.VS_MO;
            } else if ("MVD".equalsIgnoreCase(allParts[index + 1])) {
                mtdPassengerStatus = PassengerStatus.VS_MVD;
            }
        }
        if (mtdPassengerStatus != null) {
            Matcher mtdNumberMatcher;
            ticket.getPaymentTypes().add(PaymentType.MTD);
            ticket.setPassengerStatus(mtdPassengerStatus);
            if (allParts.length > index + 2 && (mtdNumberMatcher = Pattern.compile("\\d+").matcher(allParts[index + 2])).find()) {
                ticket.setDocumentNumber(mtdNumberMatcher.group(0));
            }
        } else {
            ticket.getPaymentTypes().addAll(this.getPaymentTypes(allParts[index]));
        }
    }

    private List<PaymentType> getPaymentTypes(String paymentTypes) {
        ArrayList<PaymentType> result = new ArrayList<PaymentType>();
        for (String type : paymentTypes.split("\\+")) {
            PaymentType paymentType = this.getPaymentType(type);
            if (paymentType == null) continue;
            result.add(paymentType);
        }
        return result;
    }

    private PaymentType getPaymentType(String type) {
        if (type.equals("CC")) {
            return PaymentType.CREDIT_CARD;
        }
        if (type.equals("CASH")) {
            return PaymentType.CASH;
        }
        if (type.equals("INVOICE")) {
            return PaymentType.INVOICE;
        }
        if (type.equals("IN")) {
            return PaymentType.INVOICE;
        }
        if (type.equals("CHECK")) {
            return PaymentType.BANK;
        }
        return null;
    }

    private CardVendor getVendor(String cardType) {
        if (cardType.equals("VI")) {
            return CardVendor.VISA;
        }
        return null;
    }

    private void processClientCode(String amountOrClientCode, AirFile result, MessageContext ctx) {
        try {
            EntityReference customerProfile = ProfileHelper.findOrganizationRef((String)amountOrClientCode);
            if (customerProfile == null && (amountOrClientCode.startsWith("PP") || amountOrClientCode.startsWith("pp") || amountOrClientCode.startsWith("\u0440\u0440"))) {
                amountOrClientCode = amountOrClientCode.substring(2).trim();
                customerProfile = ProfileHelper.findOrganizationRef((String)amountOrClientCode);
            }
            if (customerProfile == null) {
                ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"AmadeusParser_ClientNotFound", (Object[])new Object[]{amountOrClientCode}));
                return;
            }
            result.setCustomerProfile(customerProfile);
        }
        catch (Exception e) {
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"AmadeusParser_ClientNotFound", (Throwable)e, (Object[])new Object[]{amountOrClientCode}));
        }
    }

    private void processAmount(TicketData ticket, String amountOrClientCode) {
        Pattern pattern = Pattern.compile("^[a-zA-Z\u0430-\u044f\u0410-\u042f]{3}\\d+$");
        Matcher matcher = pattern.matcher(amountOrClientCode);
        if (!matcher.matches()) {
            return;
        }
        CurrencyInfo currencyInfo = DictHelper.getCurrencyInfoByAnyCode((String)amountOrClientCode.substring(0, 3));
        if (currencyInfo != null) {
            String currency = currencyInfo.getCode();
            String amount = amountOrClientCode.substring(3);
            ticket.setCreditCardAmount(MoneyHelper.buildMoney((String)amount, (String)currency));
        }
    }

    private static enum FPParameters implements AbstractRecordProcessor.IValue
    {
        PAYMNT(500, true, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private FPParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

