/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AIAN_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AMDRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.ATC_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.A_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.B_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.C_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.D_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.EMDRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.EndProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.FERecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.FHRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.FMRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.FORecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.FPRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.H_Open_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.H_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.H_Surface_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.ICWRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.IProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.I_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.KFTRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.KRFRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.KSTRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.KS_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.K_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.MFORecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.MFPRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.M_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.Q_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.RFDRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.RM_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.R_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.SSRRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.TAX_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.TKRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.TMCRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.T_RecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.Y_RecordProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileProcessor
implements IProcessor {
    private final List<AbstractRecordProcessor> subProcessors = new ArrayList<AbstractRecordProcessor>();

    public FileProcessor() {
        this.subProcessors.add(new EndProcessor());
        this.subProcessors.add(new AMDRecordProcessor());
        this.subProcessors.add(new ATC_RecordProcessor());
        this.subProcessors.add(new A_RecordProcessor());
        this.subProcessors.add(new B_RecordProcessor());
        this.subProcessors.add(new C_RecordProcessor());
        this.subProcessors.add(new D_RecordProcessor());
        this.subProcessors.add(new H_Surface_RecordProcessor());
        this.subProcessors.add(new H_Open_RecordProcessor());
        this.subProcessors.add(new H_RecordProcessor());
        this.subProcessors.add(new Y_RecordProcessor());
        this.subProcessors.add(new K_RecordProcessor());
        this.subProcessors.add(new TAX_RecordProcessor());
        this.subProcessors.add(new KFTRecordProcessor());
        this.subProcessors.add(new KS_RecordProcessor());
        this.subProcessors.add(new KSTRecordProcessor());
        this.subProcessors.add(new M_RecordProcessor());
        this.subProcessors.add(new Q_RecordProcessor());
        this.subProcessors.add(new I_RecordProcessor());
        this.subProcessors.add(new SSRRecordProcessor());
        this.subProcessors.add(new T_RecordProcessor());
        this.subProcessors.add(new FERecordProcessor());
        this.subProcessors.add(new FMRecordProcessor());
        this.subProcessors.add(new FPRecordProcessor());
        this.subProcessors.add(new TKRecordProcessor());
        this.subProcessors.add(new FHRecordProcessor());
        this.subProcessors.add(new RFDRecordProcessor());
        this.subProcessors.add(new R_RecordProcessor());
        this.subProcessors.add(new KRFRecordProcessor());
        this.subProcessors.add(new EMDRecordProcessor());
        this.subProcessors.add(new ICWRecordProcessor());
        this.subProcessors.add(new TMCRecordProcessor());
        this.subProcessors.add(new MFPRecordProcessor());
        this.subProcessors.add(new MFORecordProcessor());
        this.subProcessors.add(new FORecordProcessor());
        this.subProcessors.add(new RM_RecordProcessor());
        this.subProcessors.add(new AIAN_RecordProcessor());
    }

    @Override
    public void process(BufferedReader reader, AirFile result, MessageContext ctx) throws IOException {
        this.process(reader, result, new HashMap<String, Object>(), ctx);
    }

    private AbstractRecordProcessor defineProcessor(BufferedReader reader) throws IOException {
        AbstractRecordProcessor processor = null;
        for (AbstractRecordProcessor recordProcessor : this.subProcessors) {
            String recordTagName = recordProcessor.getTagName();
            reader.mark(recordTagName.length());
            char[] tagName = new char[recordTagName.length()];
            reader.read(tagName);
            if (String.valueOf(tagName).equals(recordProcessor.getTagName()) && recordProcessor.isAppropriateLine(reader)) {
                processor = recordProcessor;
                if (recordTagName.length() == recordProcessor.getTagLength()) break;
                reader.reset();
                reader.skip(recordProcessor.getTagLength());
                break;
            }
            reader.reset();
        }
        if (processor != null) {
            reader.reset();
            reader.skip(processor.getTagLength());
        }
        return processor;
    }

    private boolean skipToNextLine(BufferedReader reader) throws IOException {
        return reader.readLine() == null;
    }

    @Override
    public void process(BufferedReader reader, AirFile result, Map<String, Object> context, MessageContext ctx) throws IOException {
        AbstractRecordProcessor recordProcessor = null;
        boolean isFinished = false;
        do {
            if ((recordProcessor = this.defineProcessor(reader)) != null) {
                recordProcessor.process(reader, result, context, ctx);
            }
            if (recordProcessor != null && recordProcessor.skipNextLine()) continue;
            isFinished = this.skipToNextLine(reader);
        } while (!isFinished && (recordProcessor == null || !recordProcessor.isEnd()));
    }
}

