/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketedAirSegment;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;

public class H_RecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "H-";
    private final DateFormat dateFormat = new SimpleDateFormat("ddMMM", Locale.US);
    private final DateFormat dateFormatWithYear = new SimpleDateFormat("ddMMMyyyy", Locale.US);
    private final DateFormat timeFormat = new SimpleDateFormat("HHmm", Locale.US);

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(H_Parameters.TTONBR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.SEGNBR);
        result.add(H_Parameters.STOP);
        result.add(H_Parameters.ORIGAIR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.ORIGCTY);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.DESTAIR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.DESTCTY);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.AIRCDE);
        result.add(H_Parameters.FLTNBR);
        result.add(H_Parameters.CLSSVC);
        result.add(H_Parameters.CLSBKG);
        result.add(H_Parameters.DEPDTE);
        result.add(H_Parameters.DEPTIM);
        result.add(H_Parameters.ARRTIM);
        result.add(H_Parameters.ARRDTE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.STATUS);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.PNRSTAT);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.MEAL);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.NBRSTOP);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.EQUIP);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.ENTER);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.SHRCOMM);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.BAGALL);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.CKINTRM);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.CKINTIM);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.TKTT);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.FLTDUR);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) throws AbstractRecordProcessor.StopProcessingException {
        TicketedAirSegment segment = new TicketedAirSegment();
        if (!result.getTicketedAirSegments().isEmpty()) {
            segment = (TicketedAirSegment)result.getTicketedAirSegments().get(result.getTicketedAirSegments().size() - 1);
        }
        if (parameter instanceof H_Parameters) {
            switch ((H_Parameters)parameter) {
                case TTONBR: {
                    segment = new TicketedAirSegment();
                    result.getTicketedAirSegments().add(segment);
                    segment.setNumberInPNR(Integer.parseInt(value));
                    break;
                }
                case STOP: {
                    segment.setStopover(value.equals("O"));
                    break;
                }
                case SEGNBR: {
                    segment.setSegmentNumber(Integer.parseInt(value));
                    break;
                }
                case ORIGAIR: {
                    segment.setOriginAirportCode(value);
                    break;
                }
                case ORIGCTY: {
                    segment.setOriginCityName(value);
                    break;
                }
                case DESTAIR: {
                    segment.setDestinationAirportCode(value);
                    break;
                }
                case DESTCTY: {
                    segment.setDestinationCityName(value);
                    break;
                }
                case AIRCDE: {
                    segment.setAirlineCode(value);
                    if (!value.equals("VOID")) break;
                    throw new AbstractRecordProcessor.StopProcessingException();
                }
                case FLTNBR: {
                    segment.setFlightNumber(value.replaceFirst("^0+", ""));
                    break;
                }
                case CLSSVC: {
                    segment.setClassOfService(value);
                    break;
                }
                case CLSBKG: {
                    segment.setClassOfBooking(value);
                    break;
                }
                case DEPDTE: {
                    segment.setDeparture(this.setDate(segment.getDeparture(), value, result.getPnrDate().getAirCreationDate()));
                    break;
                }
                case DEPTIM: {
                    Date time = this.getTime(value);
                    segment.setDeparture(this.setTime(segment.getDeparture(), time));
                    break;
                }
                case ARRTIM: {
                    Date time = this.getTime(value);
                    segment.setArrival(this.setTime(segment.getArrival(), time));
                    break;
                }
                case ARRDTE: {
                    segment.setArrival(this.setDate(segment.getArrival(), value, result.getPnrDate().getAirCreationDate()));
                    segment.setArrival(this.validateArrivalDate(segment.getDeparture(), segment.getArrival()));
                    break;
                }
                case STATUS: {
                    segment.setStatus(value);
                    break;
                }
                case PNRSTAT: {
                    segment.setPnrStatus(value);
                    break;
                }
                case MEAL: {
                    segment.setMeal(value);
                    break;
                }
                case NBRSTOP: {
                    segment.setNumberOfStops(Integer.parseInt(value));
                    break;
                }
                case EQUIP: {
                    segment.setEquipmentType(value);
                    break;
                }
                case ENTER: {
                    segment.setEntertainmentCode(value);
                    break;
                }
                case SHRCOMM: {
                    segment.setSharedDesignatorCommuterAirlineName(value);
                    break;
                }
                case BAGALL: {
                    segment.setBaggageAllowance(value);
                    break;
                }
                case CKINTRM: {
                    segment.setCheckinTerminal(value);
                    break;
                }
                case CKINTIM: {
                    segment.setCheckinTime(this.getTime(value));
                    break;
                }
                case TKTT: {
                    segment.setETicketSegmentIndicator(value);
                    break;
                }
                case FLTDUR: {
                    segment.setFlightDurationTime(this.getTime(value));
                    break;
                }
            }
        }
    }

    private Date setDate(Date original, String dateStr, Date airCreationDate) {
        try {
            Date result;
            Date value = this.dateFormat.parse(dateStr);
            int year = MiscUtil.getYear((Date)airCreationDate);
            Calendar valueCal = Calendar.getInstance();
            valueCal.setTime(value);
            valueCal.set(1, year);
            if (MiscUtil.clearTime((Date)valueCal.getTime()).before(MiscUtil.clearTime((Date)airCreationDate))) {
                ++year;
            }
            if ((result = original) == null) {
                result = new Date(0L);
            }
            value = this.dateFormatWithYear.parse(dateStr + year);
            valueCal.setTime(value);
            result = DateUtils.setYears((Date)result, (int)valueCal.get(1));
            result = DateUtils.setMonths((Date)result, (int)valueCal.get(2));
            result = DateUtils.setDays((Date)result, (int)valueCal.get(5));
            return result;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Date setTime(Date original, Date value) {
        Date result = original;
        if (result == null) {
            result = new Date(0L);
        }
        Calendar valueCalendar = Calendar.getInstance();
        valueCalendar.setTime(value);
        result = DateUtils.setMinutes((Date)result, (int)valueCalendar.get(12));
        result = DateUtils.setHours((Date)result, (int)valueCalendar.get(11));
        return result;
    }

    private Date getTime(String value) {
        if (TextUtil.isBlank((String)value)) {
            return null;
        }
        if (!value.matches("[0-9]{4}")) {
            return null;
        }
        try {
            return this.timeFormat.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Date validateArrivalDate(Date departureDate, Date arrivalDate) {
        LocalDateTime dep = MiscUtil.toLocalDateTime((Date)departureDate);
        LocalDateTime arr = MiscUtil.toLocalDateTime((Date)arrivalDate);
        if (dep.getMonth() == Month.DECEMBER && arr.getMonth() == Month.JANUARY && dep.getYear() >= arr.getYear()) {
            return DateUtils.addYears((Date)arrivalDate, (int)(dep.getYear() - arr.getYear() + 1));
        }
        return arrivalDate;
    }

    private Instant convertToServerTime(String airportCode, Date date) {
        GeoLocation city = DictHelper.findCityByAirport((String)airportCode);
        if (city == null || city.getTimeZoneId() == null) {
            return date.toInstant();
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime().atZone(ZoneId.of(city.getTimeZoneId())).toInstant();
    }

    @Override
    public boolean isAppropriateLine(Reader reader) throws IOException {
        reader.reset();
        String targetPart = this.read(reader, 100).split(";")[5];
        return !"OPEN".equals(targetPart.substring(6, 10));
    }

    private static enum H_Parameters implements AbstractRecordProcessor.IValue
    {
        TTONBR(3, true, true),
        SEGNBR(3, true, true),
        STOP(1, true, true),
        ORIGAIR(5, true, false),
        ORIGCTY(17, true, false),
        DESTAIR(5, true, false),
        DESTCTY(17, true, false),
        AIRCDE(6, true, true),
        FLTNBR(5, true, true),
        CLSSVC(2, true, true),
        CLSBKG(2, true, true),
        DEPDTE(5, true, true),
        DEPTIM(5, true, true),
        ARRTIM(5, true, true),
        ARRDTE(5, true, true),
        STATUS(20, true, false),
        PNRSTAT(4, true, false),
        MEAL(2, false, true),
        NBRSTOP(1, true, true),
        EQUIP(3, false, true),
        ENTER(1, false, true),
        SHRCOMM(50, false, false),
        BAGALL(3, false, true),
        CKINTRM(2, false, true),
        CKINTIM(5, false, true),
        TKTT(2, false, true),
        FLTDUR(5, false, true);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private H_Parameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

