/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketedAirSegment;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AirFileUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;

public class H_Surface_RecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "H-000;000";
    private final DateFormat dateFormat = new SimpleDateFormat("ddMMM", Locale.US);
    private final DateFormat timeFormat = new SimpleDateFormat("HHmm", Locale.US);

    @Override
    public int getTagLength() {
        return 2;
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(H_Parameters.TTONBR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.SEGNBR);
        result.add(H_Parameters.STOP);
        result.add(H_Parameters.ORIGAIR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.ORIGCTY);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.DESTAIR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.DESTCTY);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(H_Parameters.HVOID);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) throws AbstractRecordProcessor.StopProcessingException {
        TicketedAirSegment segment = new TicketedAirSegment();
        if (!result.getTicketedAirSegments().isEmpty()) {
            segment = (TicketedAirSegment)result.getTicketedAirSegments().get(result.getTicketedAirSegments().size() - 1);
        }
        if (parameter instanceof H_Parameters) {
            switch ((H_Parameters)parameter) {
                case TTONBR: {
                    segment = new TicketedAirSegment();
                    result.getTicketedAirSegments().add(segment);
                    segment.setNumberInPNR(Integer.parseInt(value));
                    break;
                }
                case STOP: {
                    segment.setStopover(value.equals("O"));
                    break;
                }
                case SEGNBR: {
                    segment.setSegmentNumber(Integer.parseInt(value));
                    break;
                }
                case ORIGAIR: {
                    segment.setOriginAirportCode(value);
                    break;
                }
                case ORIGCTY: {
                    segment.setOriginCityName(value);
                    break;
                }
                case DESTAIR: {
                    segment.setDestinationAirportCode(value);
                    break;
                }
                case DESTCTY: {
                    segment.setDestinationCityName(value);
                    break;
                }
                case HVOID: {
                    segment.setAirlineCode(value);
                    if (!value.equals("VOID")) {
                        throw new IllegalArgumentException("value " + value + " must be VOID");
                    }
                    throw new AbstractRecordProcessor.StopProcessingException();
                }
            }
        }
    }

    private Date setDate(Date original, Date value, Date airCreationDate) {
        Date result = original;
        if (result == null) {
            result = new Date(0L);
        }
        Calendar valueCalendar = Calendar.getInstance();
        valueCalendar.setTime(value);
        result = DateUtils.setDays((Date)result, (int)valueCalendar.get(5));
        result = DateUtils.setMonths((Date)result, (int)valueCalendar.get(2));
        result = AirFileUtils.correctYear(result, airCreationDate);
        return result;
    }

    private Date setTime(Date original, Date value) {
        Date result = original;
        if (result == null) {
            result = new Date(0L);
        }
        Calendar valueCalendar = Calendar.getInstance();
        valueCalendar.setTime(value);
        result = DateUtils.setMinutes((Date)result, (int)valueCalendar.get(12));
        result = DateUtils.setHours((Date)result, (int)valueCalendar.get(11));
        return result;
    }

    private Date getDate(String value) {
        try {
            return this.dateFormat.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Date getTime(String value) {
        try {
            return this.timeFormat.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Date validateArrivalDate(Date departureDate, Date arrivalDate) {
        if (departureDate.after(arrivalDate)) {
            return DateUtils.addYears((Date)arrivalDate, (int)1);
        }
        return arrivalDate;
    }

    private static enum H_Parameters implements AbstractRecordProcessor.IValue
    {
        TTONBR(3, true, true),
        SEGNBR(3, true, true),
        STOP(1, true, true),
        ORIGAIR(5, true, false),
        ORIGCTY(17, true, false),
        DESTAIR(5, true, false),
        DESTCTY(17, true, false),
        HVOID(4, true, true);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private H_Parameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

