/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.EMDSegment;
import com.gridnine.xtrip.common.parsers.model.amadeus.IssuedInConnectionWithData;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ICWRecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "ICW";
    private static final String ICW_OBJECT = "ICW_OBJECT";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        for (int i = 0; i < 20; ++i) {
            result.add(ICWParameters.ICWTKT_1);
            result.add(ICWParameters.CPNQUAL_1);
            result.add(ICWParameters.CPNNBR_1);
            result.add(AbstractRecordProcessor.Separator.MINUS);
            result.add(ICWParameters.ICWTKT_2);
            result.add(ICWParameters.CPNQUAL_2);
            result.add(ICWParameters.CPNNBR_2);
            if (i == 19) continue;
            result.add(AbstractRecordProcessor.Separator.SEMICOLON);
        }
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(ICWParameters.TSMID);
        result.add(ICWParameters.TSMNBR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(ICWParameters.LINEID);
        result.add(ICWParameters.LINENBR);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        EMDSegment emdSegment = (EMDSegment)context.get("EMD_SEGMENT_OBJECT");
        if (parameter instanceof ICWParameters) {
            switch ((ICWParameters)parameter) {
                case ICWTKT_1: {
                    IssuedInConnectionWithData data = new IssuedInConnectionWithData();
                    emdSegment.setIssuedInConnectionWithData(data);
                    data.setIssuedDocumentNumber(value);
                    break;
                }
                case CPNQUAL_1: {
                    emdSegment.getIssuedInConnectionWithData().setCouponQualifier(value);
                    break;
                }
                case CPNNBR_1: {
                    emdSegment.getIssuedInConnectionWithData().setCouponNumber(value);
                    break;
                }
                case TSMID: {
                    if (value.equals("D")) break;
                    break;
                }
                case TSMNBR: {
                    if (emdSegment.getIssuedInConnectionWithData() == null) {
                        emdSegment.setIssuedInConnectionWithData(new IssuedInConnectionWithData());
                    }
                    emdSegment.getIssuedInConnectionWithData().setTsmNumber(value);
                    break;
                }
                case LINEID: {
                    if (value.equals("L")) break;
                    break;
                }
                case LINENBR: {
                    if (emdSegment.getIssuedInConnectionWithData() == null) {
                        emdSegment.setIssuedInConnectionWithData(new IssuedInConnectionWithData());
                    }
                    emdSegment.getIssuedInConnectionWithData().setLineNumber(value);
                    break;
                }
            }
        }
    }

    private static enum ICWParameters implements AbstractRecordProcessor.IValue
    {
        ICWTKT_1(13, false, true),
        CPNQUAL_1(1, false, true),
        CPNNBR_1(1, false, true),
        ICWTKT_2(13, false, true),
        CPNQUAL_2(1, false, true),
        CPNNBR_2(1, false, true),
        TSMID(1, false, true),
        TSMNBR(3, true, false),
        LINEID(1, false, true),
        LINENBR(3, true, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private ICWParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

