/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.Passenger;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class I_RecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "I-";
    public static final String I_OBJECT = "i_object";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(I_Parameters.GCPSGR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(I_Parameters.PSGRNBR);
        result.add(I_Parameters.PSGRNME);
        result.add(AbstractRecordProcessor.Separator.BRACKET_OPEN);
        result.add(I_Parameters.PSGRID);
        result.add(AbstractRecordProcessor.Separator.BRACKET_CLOSE);
        result.add(AbstractRecordProcessor.Separator.BRACKET_OPEN);
        result.add(I_Parameters.IDFLD);
        result.add(I_Parameters.IDNBR);
        result.add(AbstractRecordProcessor.Separator.BRACKET_CLOSE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(I_Parameters.CRRMK);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(I_Parameters.APINFO);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(I_Parameters.TRARL);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(I_Parameters.COMRL);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        TicketData ticketData;
        Passenger passenger;
        if (parameter == I_Parameters.GCPSGR) {
            result.getTickets().add(new TicketData());
        }
        if ((passenger = (ticketData = (TicketData)result.getTickets().get(result.getTickets().size() - 1)).getPassenger()) == null) {
            passenger = new Passenger();
            ticketData.setPassenger(passenger);
        }
        if (parameter instanceof I_Parameters) {
            switch ((I_Parameters)parameter) {
                case GCPSGR: {
                    passenger.setNumber(value);
                    break;
                }
                case PSGRNBR: {
                    passenger.setNumberInPNR(Integer.parseInt(value));
                    break;
                }
                case PSGRNME: {
                    String currentValue = value;
                    for (char symbol : currentValue.toCharArray()) {
                        if (!Character.isDigit(symbol)) break;
                        currentValue = currentValue.substring(1);
                    }
                    passenger.setName(currentValue);
                    break;
                }
                case PSGRID: {
                    passenger.setType(value);
                    break;
                }
                case IDNBR: {
                    passenger.setId(value);
                    break;
                }
                case CRRMK: {
                    passenger.setCr(value);
                    break;
                }
                case APINFO: {
                    passenger.setPhoneData(value.substring(2));
                    break;
                }
                case TRARL: {
                    passenger.setTravellerProfileRecord(value);
                    break;
                }
                case COMRL: {
                    passenger.setCompanyProfileRecord(value.isEmpty() ? null : value);
                    break;
                }
            }
        }
        context.put(I_OBJECT, ticketData);
    }

    private static enum I_Parameters implements AbstractRecordProcessor.IValue
    {
        GCPSGR(3, true, true),
        PSGRNBR(2, true, true),
        PSGRNME(64, true, false),
        PSGRID(3, false, true),
        IDFLD(2, false, true),
        IDNBR(29, false, true),
        CRRMK(45, false, false),
        APINFO(460, false, true),
        TRARL(6, false, true),
        COMRL(6, false, true);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private I_Parameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

