/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.Fare;
import com.gridnine.xtrip.common.parsers.model.amadeus.Tax;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractTaxProcessor;
import java.util.ArrayList;
import java.util.List;

public class KFTRecordProcessor
extends AbstractTaxProcessor {
    private static final String RECORD_NAME = "KFT";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(KFTParameters.ISSUE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.addAll(super.getRecordParameters());
        return result;
    }

    @Override
    protected Tax getTax(Fare fare) {
        if (!fare.getAllTaxes().isEmpty()) {
            return (Tax)fare.getAllTaxes().get(fare.getAllTaxes().size() - 1);
        }
        return null;
    }

    @Override
    protected int getRepeatCount() {
        return 29;
    }

    @Override
    protected void addTax(Fare fare, Tax tax) {
        fare.getAllTaxes().add(tax);
    }

    @Override
    protected AbstractTaxProcessor.TaxParameters enumToAdd() {
        return AbstractTaxProcessor.TaxParameters.OTAXI;
    }

    private static enum KFTParameters implements AbstractRecordProcessor.IValue
    {
        ISSUE(1, true, true);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private KFTParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

