/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCOExchangeNumber;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MFORecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "MFO";
    private static final Pattern TICKET_NUMBER_PATTERN = Pattern.compile("[0-9]{3}-(\\d{10})");
    private static final Pattern CARRIER_CODE_PATTERN = Pattern.compile("(.{3}(?=-(\\d{10})))");
    private static final Pattern tsmNumberPattern = Pattern.compile(";D([0-9]{1,2})");

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(MFOParameters.ORIGEXCH);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        TicketData ticket = (TicketData)context.get("i_object");
        if (ticket != null) {
            MCOExchangeNumber number;
            if (parameter == MFOParameters.ORIGEXCH) {
                number = new MCOExchangeNumber();
                ticket.getMcoExchangeNumbers().add(number);
            } else {
                number = (MCOExchangeNumber)ticket.getMcoExchangeNumbers().get(ticket.getMcoExchangeNumbers().size() - 1);
            }
            if (parameter instanceof MFOParameters) {
                switch ((MFOParameters)parameter) {
                    case ORIGEXCH: {
                        number.setOriginalIssueTicketNumber(this.extractTicketNumber(value, 0));
                        number.setOriginalIssueCarrierCode(this.extractCarrierCode(value, 0));
                        number.setInExchangeForTicketNumber(this.extractTicketNumber(value, 1));
                        number.setInExchangeForCarrierCode(this.extractCarrierCode(value, 1));
                        number.setTsmNumber(this.extractTsmNumber(value));
                        break;
                    }
                }
            }
        }
    }

    private String extractTsmNumber(String value) {
        Matcher matcher = tsmNumberPattern.matcher(value);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String extractTicketNumber(String fullLine, int index) {
        Matcher matcher = TICKET_NUMBER_PATTERN.matcher(fullLine);
        int i = 0;
        while (matcher.find()) {
            if (i == index) {
                return matcher.group(1);
            }
            ++i;
        }
        return null;
    }

    private String extractCarrierCode(String fullLine, int index) {
        Matcher matcher = CARRIER_CODE_PATTERN.matcher(fullLine);
        int i = 0;
        while (matcher.find()) {
            if (i == index) {
                return matcher.group(1);
            }
            ++i;
        }
        return null;
    }

    private static enum MFOParameters implements AbstractRecordProcessor.IValue
    {
        ORIGEXCH(254, true, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private MFOParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

