/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.google.common.collect.Iterables;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.EMDPayment;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MFPRecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "MFP";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(TMCParameters.PAYMNT);
        result.add(AbstractRecordProcessor.Separator.SEMICOLON);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(TMCParameters.LINEID);
        for (int i = 0; i < 99; ++i) {
            result.add(TMCParameters.LINENBR_1);
            result.add(AbstractRecordProcessor.Separator.MINUS);
            result.add(TMCParameters.LINENBR_2);
            if (i == 98) continue;
            result.add(AbstractRecordProcessor.Separator.SEMICOLON);
        }
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(TMCParameters.TSMID);
        result.add(TMCParameters.TSMNBR);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        EMDPayment payment = result.getEmdPayment();
        if (payment == null) {
            payment = new EMDPayment();
            result.setEmdPayment(payment);
        }
        if (parameter instanceof TMCParameters) {
            switch ((TMCParameters)parameter) {
                case PAYMNT: {
                    payment.setFormOfPayment(this.parsePaymentType(value));
                    break;
                }
                case LINEID: {
                    if (value.equals("L")) break;
                    break;
                }
                case LINENBR_1: {
                    payment.getLineNumbers().add(Integer.valueOf(value));
                    break;
                }
                case LINENBR_2: {
                    int start = (Integer)Iterables.getLast((Iterable)payment.getLineNumbers());
                    int end = Integer.parseInt(value);
                    for (int i = start + 1; i <= end; ++i) {
                        payment.getLineNumbers().add(i);
                    }
                    break;
                }
                case TSMID: {
                    if (value.equals("D")) break;
                    break;
                }
                case TSMNBR: {
                    payment.setTsmNumber(value);
                    break;
                }
            }
        }
    }

    private PaymentType parsePaymentType(String value) {
        if ("INVOICE".equals(value)) {
            return PaymentType.INVOICE;
        }
        return PaymentType.CASH;
    }

    private static enum TMCParameters implements AbstractRecordProcessor.IValue
    {
        PAYMNT(248, true, false),
        LINEID(1, false, true),
        LINENBR_1(3, true, false),
        LINENBR_2(3, true, false),
        TSMID(1, false, true),
        TSMNBR(3, true, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private TMCParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

