/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.Fare;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class M_RecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "M-";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(M_Parameters.VALUE);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        Fare fare = result.getFare();
        if (fare == null) {
            fare = new Fare();
            result.setFare(fare);
        }
        if (parameter instanceof M_Parameters) {
            switch ((M_Parameters)parameter) {
                case VALUE: {
                    for (String basicCode : value.split(";")) {
                        if (basicCode.split(" ").length > 1) {
                            basicCode = basicCode.trim().replaceAll("[ ]+", "/");
                        }
                        fare.getFareBasisCodes().add(basicCode.trim());
                    }
                    break;
                }
            }
        }
    }

    private static enum M_Parameters implements AbstractRecordProcessor.IValue
    {
        VALUE(1, true, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private M_Parameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

