/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.ItineraryType;
import com.gridnine.xtrip.common.parsers.model.amadeus.Refund;
import com.gridnine.xtrip.common.parsers.model.amadeus.RefundType;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RFDRecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "RFD";
    private static final String CONTEXT_CURRENCY = "rfd_currency";
    private final DateFormat dateFormat = new SimpleDateFormat("ddMMMyy", Locale.US);

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(RFDParameters.DSOURCE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(RFDParameters.DOCDATE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(RFDParameters.ITNTYP);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(RFDParameters.CURRTYP);
        result.add(RFDParameters.FPAID);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(RFDParameters.FUSED);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(RFDParameters.FRFD);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(RFDParameters.NRFD_1);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(RFDParameters.NRFD_2);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(RFDParameters.CXFEE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(RFDParameters.CXFEECOM);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(RFDParameters.MSFEE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(RFDParameters.TAXCDE);
        result.add(RFDParameters.TAXRFD);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(RFDParameters.TOTRFD);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(RFDParameters.DEPDTE);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        Refund refund = result.getRefund();
        if (refund == null) {
            refund = new Refund();
            result.setRefund(refund);
        }
        if (parameter instanceof RFDParameters) {
            switch ((RFDParameters)parameter) {
                case DSOURCE: {
                    refund.setRefundType(RefundTypeMapping.getRefundType(value));
                    break;
                }
                case DOCDATE: {
                    try {
                        refund.setDocumentIssueDate(this.dateFormat.parse(value));
                        break;
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                case ITNTYP: {
                    refund.setItineraryType(ItineraryTypeMapping.getItineraryType(value));
                    break;
                }
                case CURRTYP: {
                    this.putCurrency(context, value);
                    break;
                }
                case FPAID: {
                    if (StringUtils.isEmpty((String)value)) break;
                    refund.setFarePaid(this.getMoney(this.getCurrency(context), value));
                    break;
                }
                case FUSED: {
                    if (StringUtils.isEmpty((String)value)) break;
                    refund.setFareUsed(this.getMoney(this.getCurrency(context), value));
                    break;
                }
                case FRFD: {
                    if (StringUtils.isEmpty((String)value)) break;
                    refund.setFareRefund(this.getMoney(this.getCurrency(context), value));
                    break;
                }
                case NRFD_1: {
                    refund.setHaveNetRefund(value.equals("NF"));
                    break;
                }
                case NRFD_2: {
                    if (StringUtils.isEmpty((String)value)) break;
                    refund.setNetRefund(this.getMoney(this.getCurrency(context), value));
                    break;
                }
                case CXFEE: {
                    if (StringUtils.isEmpty((String)value)) break;
                    refund.setCancellationFee(this.getMoney(this.getCurrency(context), value));
                    break;
                }
                case CXFEECOM: {
                    if (StringUtils.isEmpty((String)value)) break;
                    refund.setCancellationFeeCommission(this.getMoney(this.getCurrency(context), value));
                    break;
                }
                case MSFEE: {
                    if (StringUtils.isEmpty((String)value)) break;
                    refund.setMiscellaneousFee(this.getMoney(this.getCurrency(context), value));
                    break;
                }
                case TAXCDE: {
                    refund.setTaxCode(value);
                    break;
                }
                case TAXRFD: {
                    if (StringUtils.isEmpty((String)value)) break;
                    refund.setTaxRefund(this.getMoney(this.getCurrency(context), value));
                    break;
                }
                case TOTRFD: {
                    if (StringUtils.isEmpty((String)value)) break;
                    refund.setTotalRefund(this.getMoney(this.getCurrency(context), value));
                    break;
                }
                case DEPDTE: {
                    try {
                        if (StringUtils.isEmpty((String)value)) break;
                        refund.setDepartureDate(this.dateFormat.parse(value));
                        break;
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
        }
    }

    private String getCurrency(Map<String, Object> context) {
        return (String)context.get(CONTEXT_CURRENCY);
    }

    private void putCurrency(Map<String, Object> context, String currency) {
        context.put(CONTEXT_CURRENCY, currency);
    }

    private Money getMoney(String currency, String amount) {
        Money result = new Money();
        result.setCurrency(currency);
        result.setValue(new BigDecimal(amount));
        return result;
    }

    private static enum RefundTypeMapping {
        MANUAL(RefundType.MANUAL, "M"),
        AUTOMATED(RefundType.AUTOMATED, "F"),
        MIXED(RefundType.MIXED, "L"),
        CP(RefundType.FULL_WITH_CP, "A"),
        ATC(RefundType.AUTOMATED_ATC, "C"),
        ATC_CP_MF(RefundType.ATC_WITH_CP_OR_MF_UPDATE, "P"),
        ATC_OTHER(RefundType.ATC_WITH_OTHER_UPDATE, "N");

        private final RefundType type;
        private final String value;

        private RefundTypeMapping(RefundType type, String value) {
            this.type = type;
            this.value = value;
        }

        public static RefundType getRefundType(String value) {
            for (RefundTypeMapping mapping : RefundTypeMapping.values()) {
                if (!mapping.value.equals(value)) continue;
                return mapping.type;
            }
            return null;
        }
    }

    private static enum ItineraryTypeMapping {
        DOMESTIC(ItineraryType.DOMESTIC, "D"),
        INTERNATIONAL(ItineraryType.INTERNATIONAL, "I");

        private final ItineraryType type;
        private final String value;

        private ItineraryTypeMapping(ItineraryType type, String value) {
            this.type = type;
            this.value = value;
        }

        public static ItineraryType getItineraryType(String value) {
            for (ItineraryTypeMapping mapping : ItineraryTypeMapping.values()) {
                if (!mapping.value.equals(value)) continue;
                return mapping.type;
            }
            return null;
        }
    }

    private static enum RFDParameters implements AbstractRecordProcessor.IValue
    {
        DSOURCE(1, true, true),
        DOCDATE(7, true, true),
        ITNTYP(1, false, true),
        CURRTYP(3, true, true),
        FPAID(11, true, false),
        FUSED(11, true, false),
        FRFD(11, true, false),
        NRFD_1(2, false, true),
        NRFD_2(11, false, false),
        CXFEE(11, false, false),
        CXFEECOM(11, false, false),
        MSFEE(11, false, false),
        TAXCDE(2, false, true),
        TAXRFD(11, false, false),
        TOTRFD(11, true, false),
        DEPDTE(7, false, true);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private RFDParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

