/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RM_RecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "RM";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(RM_Parameters.REMARKS);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) throws AbstractRecordProcessor.StopProcessingException {
        if (parameter instanceof RM_Parameters) {
            if (value.startsWith("*AN") && result.getCustomerProfile() == null) {
                String customerCode = value.substring(value.indexOf("AN") + 2).trim();
                this.processClientCode(customerCode, result, ctx);
            } else if (result.getCustomerProfile() == null && context.get("AIAN") != null) {
                String aianCustomerCode = (String)context.get("AIAN");
                this.processClientCode(aianCustomerCode, result, ctx);
            }
        }
    }

    private void processClientCode(String clientCode, AirFile result, MessageContext ctx) {
        EntityReference customerProfile = ProfileHelper.findOrganizationRef((String)clientCode);
        if (clientCode != null) {
            ctx.putObject((Enum)IBusAmadeusParserContextKeys.CUSTOMER_CODE, (Object)clientCode);
        }
        if (customerProfile != null) {
            result.setCustomerProfile(customerProfile);
        }
    }

    private static enum RM_Parameters implements AbstractRecordProcessor.IValue
    {
        REMARKS(500, true, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private RM_Parameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

