/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.Refund;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class R_RecordProcessor
extends AbstractRecordProcessor {
    private static final long HOUR = 3600000L;
    private static final String RECORD_NAME = "R-";
    private final DateFormat dateFormat = new SimpleDateFormat("ddMMMyy", Locale.US);
    private final DateFormat timeFormat = new SimpleDateFormat("HH:mm");

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(R_Parameters.RFDNBR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(R_Parameters.RFDDATE);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        Refund refund = result.getRefund();
        if (refund == null) {
            refund = new Refund();
            result.setRefund(refund);
        }
        if (parameter instanceof R_Parameters) {
            switch ((R_Parameters)parameter) {
                case RFDNBR: {
                    refund.setRefundNumber(value);
                    break;
                }
                case RFDDATE: {
                    try {
                        Date date = this.dateFormat.parse(value);
                        if (this.timeFormat.format(date).equals("00:00")) {
                            date = new Date(date.getTime() + 43200000L);
                        }
                        refund.setRefundDate(date);
                        break;
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
        }
    }

    private static enum R_Parameters implements AbstractRecordProcessor.IValue
    {
        RFDNBR(14, true, false),
        RFDDATE(7, true, true);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private R_Parameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

