/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.ServiceRequest;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SSRRecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "SSR ";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        int i;
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(SSRDocsParameters.SSRTYPE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SPACE);
        result.add(SSRDocsParameters.AIRCDE);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SPACE);
        result.add(SSRDocsParameters.STATCDE);
        result.add(SSRDocsParameters.NBRPTY);
        result.add(AbstractRecordProcessor.Separator.SLASH);
        result.add(SSRDocsParameters.FREE);
        result.add(AbstractRecordProcessor.Separator.SEMICOLON);
        result.add(SSRDocsSeparator.S);
        for (i = 0; i < 99; ++i) {
            if (i > 0) {
                result.add(AbstractRecordProcessor.Separator.COMMA);
            }
            result.add(SSRDocsParameters.SEGNBR);
        }
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(SSRDocsSeparator.P);
        for (i = 0; i < 99; ++i) {
            if (i > 0) {
                result.add(AbstractRecordProcessor.Separator.COMMA);
            }
            result.add(SSRDocsParameters.PSGNBR);
        }
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        TicketData ticketData = (TicketData)context.get("i_object");
        if (parameter == SSRDocsParameters.SSRTYPE) {
            ticketData.getServiceRequests().add(new ServiceRequest());
        }
        ServiceRequest request = (ServiceRequest)ticketData.getServiceRequests().get(ticketData.getServiceRequests().size() - 1);
        if (parameter instanceof SSRDocsParameters) {
            switch ((SSRDocsParameters)parameter) {
                case SSRTYPE: {
                    request.setSsrType(value);
                    break;
                }
                case AIRCDE: {
                    request.setAirlineCode(value);
                    break;
                }
                case FREE: {
                    request.setMessage(value);
                    break;
                }
                case NBRPTY: {
                    if (!TextUtil.nonBlank((String)value)) break;
                    request.setNumberInParty(Integer.parseInt(value));
                    break;
                }
                case STATCDE: {
                    request.setStatusCode(value);
                    break;
                }
                case PSGNBR: {
                    request.getPassengerNumbers().addAll(AmadeusParserHelper.parseValues(value));
                    break;
                }
            }
        }
    }

    private static enum SSRDocsParameters implements AbstractRecordProcessor.IValue
    {
        SSRTYPE(4, true, true),
        AIRCDE(3, true, true),
        STATCDE(2, false, true),
        NBRPTY(2, false, false),
        FREE(112, false, false),
        SEGNBR(7, false, false),
        PSGNBR(5, false, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private SSRDocsParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }

    private static enum SSRDocsSeparator implements AbstractRecordProcessor.ISeparator
    {
        S('S', false),
        P('P', false);

        private final char value;
        private final boolean mandatory;

        private SSRDocsSeparator(char value, boolean mandatory) {
            this.value = value;
            this.mandatory = mandatory;
        }

        @Override
        public char value() {
            return this.value;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }
    }
}

