/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.Fare;
import com.gridnine.xtrip.common.parsers.model.amadeus.Tax;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractTaxProcessor;
import java.util.List;

public class TAX_RecordProcessor
extends AbstractTaxProcessor {
    private static final String RECORD_NAME = "TAX-";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        List<AbstractRecordProcessor.IParameter> result = super.getRecordParameters();
        this.remove(result, AbstractTaxProcessor.TaxParameters.OTAXI);
        this.remove(result, AbstractTaxProcessor.TaxParameters.TAXN);
        return result;
    }

    private void remove(List<AbstractRecordProcessor.IParameter> list, AbstractRecordProcessor.IParameter parameter) {
        while (list.contains(parameter)) {
            list.remove(parameter);
        }
    }

    @Override
    protected Tax getTax(Fare result) {
        if (!result.getFormattedTaxes().isEmpty()) {
            return (Tax)result.getFormattedTaxes().get(result.getFormattedTaxes().size() - 1);
        }
        return null;
    }

    @Override
    protected int getRepeatCount() {
        return 3;
    }

    @Override
    protected void addTax(Fare result, Tax tax) {
        result.getFormattedTaxes().add(tax);
    }

    @Override
    protected AbstractTaxProcessor.TaxParameters enumToAdd() {
        return AbstractTaxProcessor.TaxParameters.TCURR;
    }
}

