/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TKRecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "TK";
    private final DateFormat dateFormat = new SimpleDateFormat("ddMMM/HHmm", Locale.US);
    private final DateFormat shortDateFormat = new SimpleDateFormat("ddMMM", Locale.US);

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(M_Parameters.TKTARR);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        TicketData ticket = (TicketData)context.get("i_object");
        if (parameter instanceof M_Parameters) {
            switch ((M_Parameters)parameter) {
                case TKTARR: {
                    this.processTicketData(ticket, value);
                    break;
                }
            }
        }
    }

    private void processTicketData(TicketData ticket, String tktarr) {
        if (tktarr.length() < 2) {
            return;
        }
        String value = tktarr.substring(2);
        int partCount = StringUtils.countMatches((String)value, (String)"/");
        String timeLimit = null;
        DateFormat format = null;
        if (partCount == 2) {
            timeLimit = value.substring(0, 10);
            format = this.dateFormat;
        } else if (partCount == 1) {
            timeLimit = value.substring(0, 5);
            format = this.shortDateFormat;
        }
        if (format != null) {
            try {
                ticket.setTimeLimit(format.parse(timeLimit));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static enum M_Parameters implements AbstractRecordProcessor.IValue
    {
        TKTARR(127, true, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private M_Parameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

