/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.google.common.collect.Iterables;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCONumber;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCOTicketType;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TMCRecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "TMC";
    private static final Pattern tsmNumberPattern = Pattern.compile("D([0-9]{1,2})");

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(TMCParameters.TKTTYPE);
        result.add(TMCParameters.NUMAIR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_MINUS);
        result.add(TMCParameters.TKTNBR);
        result.add(TMCParameters.FREE);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        TicketData ticket = (TicketData)context.get("i_object");
        if (ticket != null) {
            MCONumber number;
            if (parameter == TMCParameters.TKTTYPE) {
                number = new MCONumber();
                ticket.getMcoNumbers().add(number);
            } else {
                number = (MCONumber)ticket.getMcoNumbers().get(ticket.getMcoNumbers().size() - 1);
            }
            if (parameter instanceof TMCParameters) {
                switch ((TMCParameters)parameter) {
                    case TKTTYPE: {
                        number.setTicketType(MCOTicketTypeMapping.getTicketType(value));
                        break;
                    }
                    case NUMAIR: {
                        number.setNumericAirlineCode(Integer.parseInt(value));
                        break;
                    }
                    case TKTNBR: {
                        number.setTicketNumber(value);
                        break;
                    }
                    case ICWNBR: {
                        number.setInConnectionWithNumber(Long.parseLong(value));
                        break;
                    }
                    case FREE: {
                        Matcher matcher;
                        number.setFreeText(value);
                        if (TextUtil.isBlank((String)value) || !(matcher = tsmNumberPattern.matcher(value)).find()) break;
                        number.setTsmNumber(matcher.group(1));
                        break;
                    }
                    case LINEID: {
                        if (value.equals("L")) break;
                        throw new IllegalArgumentException("LINEID value should be 'L'");
                    }
                    case LINENBR_1: {
                        number.getLineNumbers().add(Integer.valueOf(value));
                        break;
                    }
                    case LINENBR_2: {
                        int start = (Integer)Iterables.getLast((Iterable)number.getLineNumbers());
                        int end = Integer.parseInt(value);
                        for (int i = start + 1; i <= end; ++i) {
                            number.getLineNumbers().add(i);
                        }
                        break;
                    }
                    case TSMID: {
                        if (value.equals(";D")) break;
                        throw new IllegalArgumentException("TSMID value should be ';D'");
                    }
                    case TSMNBR: {
                        number.setTsmNumber(value);
                        break;
                    }
                }
            }
        }
    }

    private static enum TMCParameters implements AbstractRecordProcessor.IValue
    {
        TKTTYPE(1, true, true),
        NUMAIR(3, true, true),
        TKTNBR(10, true, true),
        ICWNBR(13, false, true),
        FREE(50, false, false),
        LINEID(1, false, true),
        LINENBR_1(3, true, false),
        LINENBR_2(3, true, false),
        TSMID(2, false, true),
        TSMNBR(3, true, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private TMCParameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }

    private static enum MCOTicketTypeMapping {
        MCO(MCOTicketType.MCO, "M"),
        MPD(MCOTicketType.MPD, "P"),
        EMD(MCOTicketType.EMD, "D"),
        EEBT(MCOTicketType.EEBT, "X"),
        EBT(MCOTicketType.EBT, "B"),
        TTM_BTK(MCOTicketType.TTM_BTK, "O");

        private final MCOTicketType type;
        private final String name;

        private MCOTicketTypeMapping(MCOTicketType type, String name) {
            this.type = type;
            this.name = name;
        }

        public static MCOTicketType getTicketType(String name) {
            for (MCOTicketTypeMapping mapping : MCOTicketTypeMapping.values()) {
                if (!mapping.name.equals(name)) continue;
                return mapping.type;
            }
            return null;
        }
    }
}

