/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class T_RecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "T-";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(T_Parameters.TKTTYPE);
        result.add(T_Parameters.NUMAIR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_MINUS);
        result.add(T_Parameters.TKTNBR);
        result.add(AbstractRecordProcessor.Separator.MINUS);
        result.add(T_Parameters.DIGIT);
        result.add(AbstractRecordProcessor.Separator.SLASH);
        result.add(T_Parameters.FREE);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        TicketData ticket = (TicketData)context.get("i_object");
        if (ticket != null && parameter instanceof T_Parameters) {
            switch ((T_Parameters)parameter) {
                case NUMAIR: {
                    ticket.setValidatingAirlineNumber(value);
                    break;
                }
                case TKTNBR: {
                    ticket.setTicketNumber(value);
                    break;
                }
                case DIGIT: {
                    if (StringUtils.isEmpty((String)value)) break;
                    ticket.setConjunctionsCount(this.getConjunctionCount(ticket.getTicketNumber(), Integer.parseInt(value)));
                    break;
                }
            }
        }
    }

    private int getConjunctionCount(String originalNumber, int conjunctionValue) {
        String twoDigitValue = StringUtils.right((String)originalNumber, (int)2);
        int twoDigits = Integer.parseInt(twoDigitValue);
        int conjunctionCount = conjunctionValue - twoDigits;
        return conjunctionCount < 0 ? conjunctionCount + 100 : conjunctionCount;
    }

    private static enum T_Parameters implements AbstractRecordProcessor.IValue
    {
        TKTTYPE(1, true, true),
        NUMAIR(3, true, true),
        TKTNBR(10, true, true),
        DIGIT(2, false, true),
        FREE(50, false, false);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private T_Parameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

