/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketedAirSegment;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.internal.AbstractRecordProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Y_RecordProcessor
extends AbstractRecordProcessor {
    private static final String RECORD_NAME = "Y-";

    @Override
    public int getTagLength() {
        return RECORD_NAME.length();
    }

    @Override
    public String getTagName() {
        return RECORD_NAME;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    protected List<AbstractRecordProcessor.IParameter> getRecordParameters() {
        ArrayList<AbstractRecordProcessor.IParameter> result = new ArrayList<AbstractRecordProcessor.IParameter>();
        result.add(Y_Parameters.TTONBR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(Y_Parameters.SEGNBR);
        result.add(Y_Parameters.ORIGAIR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(Y_Parameters.ORIGCTY);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(Y_Parameters.DESTAIR);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(Y_Parameters.DESTCTY);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(Y_Parameters.OWNER);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(Y_Parameters.OWNNAME);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(Y_Parameters.COCKPIT);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(Y_Parameters.CPITNAME);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(Y_Parameters.CABIN);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(Y_Parameters.CABINNAME);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(Y_Parameters.EQUIP);
        result.add(AbstractRecordProcessor.Separator.MANDATORY_SEMICOLON);
        result.add(Y_Parameters.GAUGE);
        result.add(AbstractRecordProcessor.Separator.CARRIAGE_RETURN);
        return result;
    }

    @Override
    protected void processValue(AbstractRecordProcessor.IValue parameter, String value, AirFile result, Map<String, Object> context, MessageContext ctx) {
        TicketedAirSegment segment = new TicketedAirSegment();
        if (!result.getTicketedAirSegments().isEmpty()) {
            segment = (TicketedAirSegment)result.getTicketedAirSegments().get(result.getTicketedAirSegments().size() - 1);
        }
        if (parameter instanceof Y_Parameters) {
            switch ((Y_Parameters)parameter) {
                case OWNER: {
                    segment.setCodeShareCarrier(value);
                }
            }
        }
    }

    private static enum Y_Parameters implements AbstractRecordProcessor.IValue
    {
        TTONBR(3, true, true),
        SEGNBR(3, true, true),
        ORIGAIR(5, true, false),
        ORIGCTY(17, true, false),
        DESTAIR(5, true, false),
        DESTCTY(17, true, false),
        OWNER(6, true, false),
        OWNNAME(50, false, false),
        COCKPIT(6, true, false),
        CPITNAME(50, false, false),
        CABIN(6, true, false),
        CABINNAME(50, false, false),
        EQUIP(3, true, true),
        GAUGE(1, true, true);

        private final int length;
        private final boolean mandatory;
        private final boolean fixedLength;

        private Y_Parameters(int length, boolean mandatory, boolean fixedLength) {
            this.length = length;
            this.mandatory = mandatory;
            this.fixedLength = fixedLength;
        }

        @Override
        public int maxLength() {
            return this.length;
        }

        @Override
        public boolean mandatory() {
            return this.mandatory;
        }

        @Override
        public boolean fixedLength() {
            return this.fixedLength;
        }
    }
}

