/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.parsers.model.amadeus.AdditionalServiceData;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.EMDSegment;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class AmadeusAdditionalServicesDataProvider
extends BaseTargetsProvider<AdditionalServiceData> {
    private String emdType;

    public void configure(Map<String, String> parameters) {
        this.emdType = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"emdType");
    }

    public Collection<AdditionalServiceData> getTargets(MessageContext ctx) throws Exception {
        ArrayList<AdditionalServiceData> result = new ArrayList<AdditionalServiceData>();
        AirFile file = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        file.getTickets().forEach(td -> td.getMcoNumbers().forEach(mcoNumber -> {
            boolean matches = false;
            for (EMDSegment segmentData : file.getEmdSegments()) {
                if (mcoNumber.getTsmNumber() == null || !mcoNumber.getTsmNumber().equals(segmentData.getTsmNumber()) || !this.emdType.equals(AmadeusParserHelper.getEmdType(file, segmentData, false))) continue;
                matches = true;
            }
            if (matches) {
                AdditionalServiceData item = new AdditionalServiceData();
                item.setTicketData(td);
                item.setMcoNumber(mcoNumber);
                result.add(item);
            }
        }));
        return result;
    }
}

