/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.CalculationLineParsingResult;
import com.gridnine.xtrip.common.parsers.model.CalculationLineSegmentParsingResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class AmadeusCorrectPartialExchangeProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        if (AirProductHelper.getSegments((Collection)product.getSegmentTariffs()).size() == AirProductHelper.getSegments((Collection)product.getPreviousProduct().getSegmentTariffs()).size()) {
            return;
        }
        CalculationLineParsingResult res = (CalculationLineParsingResult)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.CALCULATION_LINE_PARSING_RESULT);
        if (AirProductHelper.getSegments((Collection)product.getSegmentTariffs()).isEmpty()) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u0447\u0430\u0441\u0442\u0438\u0447\u043d\u043e\u043c \u043e\u0431\u043c\u0435\u043d\u0435 \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u044b, \u043f\u0440\u0438\u043d\u044f\u0442\u044b\u0435 \u043a \u043e\u0431\u043c\u0435\u043d\u0443", (Object[])new Object[0]));
            return;
        }
        int usedSegmentsCount = 0;
        List calculationLineSegments = res.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).collect(Collectors.toList());
        Segment firstSegment = (Segment)((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().get(0);
        for (CalculationLineSegmentParsingResult calcSegment : calculationLineSegments) {
            boolean sameSegments;
            boolean bl = sameSegments = AmadeusParserHelper.isSameCity(calcSegment.getArrivalCode(), (DictionaryReference<GeoLocation>)firstSegment.getArriveLocation()) && AmadeusParserHelper.isSameCity(calcSegment.getDepartureCode(), (DictionaryReference<GeoLocation>)firstSegment.getDepartureLocation());
            if (sameSegments) break;
            ++usedSegmentsCount;
        }
        for (SegmentTariff segmentTariff : product.getPreviousProduct().getSegmentTariffs()) {
            Iterator iterator = segmentTariff.getSegments().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                if (usedSegmentsCount <= 0) continue;
                iterator.remove();
                --usedSegmentsCount;
            }
        }
        product.getPreviousProduct().getSegmentTariffs().removeIf(st -> st.getSegments().isEmpty());
        BigDecimal ef = AirProductHelper.getEquivalentFare((Product)product.getPreviousProduct());
        Money baseFare = AirProductHelper.getBaseFare((Product)product.getPreviousProduct());
        product.getPreviousProduct().getFares().clear();
        AirProductHelper.setEquivalentFare((Product)product.getPreviousProduct(), (BigDecimal)ef);
        AirProductHelper.setBaseFare((Product)product.getPreviousProduct(), (Money)baseFare);
    }
}

