/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.parsers.model.amadeus.AdditionalServiceData;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.EMDSegment;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCONumber;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import com.gridnine.xtrip.server.parsers2.common.Parsers2GeneralHelper;
import com.gridnine.xtrip.server.parsers2.common.avia.Parsers2AviaHelper;
import java.util.List;

public class AmadeusCreateEmdSegmentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SegmentTariff segmentTariff;
        TicketData ticketData;
        AirFile airFile = (AirFile)ctx.getObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        int segNo = 0;
        List fareBasisCodes = airFile.getFare().getFareBasisCodes();
        String rfisc = null;
        Product relatedProduct = (Product)CollectionUtil.head((Iterable)product.getRelatedProducts());
        AdditionalServiceData asd = (AdditionalServiceData)ctx.getObject((Enum)IBusAmadeusParserContextKeys.ADDITIONAL_SERVICE_DATA);
        MCONumber mcoNumber = asd != null ? asd.getMcoNumber() : ((ticketData = (TicketData)ctx.getObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA)) == null ? AmadeusParserHelper.getMCONumber(airFile) : (MCONumber)ticketData.getMcoNumbers().get(0));
        for (EMDSegment segmentData : airFile.getEmdSegments()) {
            Segment relatedSegment;
            if (mcoNumber != null && segmentData.getTsmNumber() != null && !segmentData.getTsmNumber().equals(mcoNumber.getTsmNumber())) continue;
            ++segNo;
            if (this.isVoidSegment(segmentData)) continue;
            if (TextUtil.nonBlank((String)segmentData.getReasonSubCode())) {
                if (rfisc != null && !rfisc.equals(segmentData.getReasonSubCode())) {
                    throw Xeption.forEndUser((String)"\u041f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 EMD {0} \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 1 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f rfisc.", (Object[])new Object[]{product.getSystemNumber()});
                }
                rfisc = segmentData.getReasonSubCode();
            }
            segmentTariff = new SegmentTariff();
            product.getSegmentTariffs().add(segmentTariff);
            Segment segment = new Segment();
            segmentTariff.getSegments().add(segment);
            segment.setRecordNumber(segNo);
            segment.setAirlineLocator(airFile.getHeader().getNsRecordLocator());
            segment.setAirline(Parsers2GeneralHelper.findAirline((String)segmentData.getAirlineCode(), (int)segNo, (MessageContext)ctx));
            if (fareBasisCodes.size() >= segNo) {
                segment.setFareBasis((String)fareBasisCodes.get(segNo - 1));
            }
            if (relatedProduct != null && (relatedSegment = (Segment)relatedProduct.getSegmentTariffs().stream().flatMap(item -> item.getSegments().stream()).filter(item -> AmadeusParserHelper.isSameCity(segmentData.getOriginCityCode(), (DictionaryReference<GeoLocation>)item.getDepartureLocation()) && AmadeusParserHelper.isSameCity(segmentData.getDestinationCityCode(), (DictionaryReference<GeoLocation>)item.getArriveLocation())).findFirst().orElse(null)) != null) {
                if (TextUtil.isBlank((String)segment.getFareBasis())) {
                    segment.setFareBasis(relatedSegment.getFareBasis());
                }
                segment.setDepartureLocation(relatedSegment.getDepartureLocation());
                segment.setArriveLocation(relatedSegment.getArriveLocation());
                segment.setFlightNo(relatedSegment.getFlightNo());
                segment.setClassOfSvcCode(relatedSegment.getClassOfSvcCode());
                segment.setStartDate(relatedSegment.getStartDate());
            }
            if (segment.getDepartureLocation() == null && !TextUtil.isBlank((String)segmentData.getOriginCityCode())) {
                DictionaryReference departureLocation = Parsers2AviaHelper.findAirport((String)segmentData.getOriginCityCode(), (int)segNo, (MessageContext)ctx);
                segment.setDepartureLocation(departureLocation);
            }
            if (segment.getArriveLocation() != null || TextUtil.isBlank((String)segmentData.getDestinationCityCode())) continue;
            DictionaryReference arrivalLocation = Parsers2AviaHelper.findAirport((String)segmentData.getDestinationCityCode(), (int)segNo, (MessageContext)ctx);
            segment.setArriveLocation(arrivalLocation);
        }
        product.setRfisc(rfisc);
        if (relatedProduct != null && product.getSegmentTariffs().stream().flatMap(item -> item.getSegments().stream()).noneMatch(it -> it.getDepartureLocation() != null && it.getArriveLocation() != null)) {
            product.getSegmentTariffs().clear();
            for (SegmentTariff relatedSegmentTariff : relatedProduct.getSegmentTariffs()) {
                segmentTariff = new SegmentTariff();
                product.getSegmentTariffs().add(segmentTariff);
                for (Segment relatedSegment : relatedSegmentTariff.getSegments()) {
                    Segment segment = new Segment();
                    segmentTariff.getSegments().add(segment);
                    segment.setRecordNumber(relatedSegment.getRecordNumber());
                    segment.setAirlineLocator(relatedSegment.getAirlineLocator());
                    segment.setAirline(relatedSegment.getAirline());
                    segment.setFareBasis(relatedSegment.getFareBasis());
                    segment.setDepartureLocation(relatedSegment.getDepartureLocation());
                    segment.setArriveLocation(relatedSegment.getArriveLocation());
                    segment.setFlightNo(relatedSegment.getFlightNo());
                    segment.setClassOfSvcCode(relatedSegment.getClassOfSvcCode());
                    segment.setStartDate(relatedSegment.getStartDate());
                }
            }
        }
    }

    private boolean isVoidSegment(EMDSegment item) {
        return "VOID".equals(item.getAirlineCode());
    }
}

