/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.Fare;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.Tax;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AmadeusCreateFaresAndTaxesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Money baseFare;
        BigDecimal totalAmount;
        BigDecimal previousEquivalentFare;
        boolean exchangeOfVoucher;
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        TicketData ticketData = (TicketData)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        boolean exchange = product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
        boolean smartTickettingMode = Boolean.TRUE.equals(ctx.getObject((Enum)IBusAmadeusParserContextKeys.S7_SMART_TICKETTING_MODE));
        boolean bl = exchangeOfVoucher = product.getPreviousProduct() != null && product.getPreviousProduct().getMcoCategory() == MCOCategory.VOUCHER;
        if (exchange && airFile.getFare().getTaxes().isEmpty() && airFile.getFare().getAllTaxes().isEmpty() && !smartTickettingMode) {
            for (com.gridnine.xtrip.common.model.booking.air.Tax tax : product.getPreviousProduct().getPreviousProduct().getTaxes()) {
                com.gridnine.xtrip.common.model.booking.air.Tax newTax = new com.gridnine.xtrip.common.model.booking.air.Tax();
                newTax.setCode(tax.getCode() == null ? "" : tax.getCode());
                newTax.setEquivalentAmount(tax.getEquivalentAmount());
                product.getTaxes().add(newTax);
            }
        }
        if (exchange && smartTickettingMode && !exchangeOfVoucher) {
            HashMap surplus = new HashMap();
            for (com.gridnine.xtrip.common.model.booking.air.Tax tax : airFile.getFare().getAllTaxes()) {
                String taxCode = tax.getTaxCode() == null ? "" : tax.getTaxCode();
                BigDecimal amnt = (BigDecimal)surplus.get(taxCode);
                surplus.put(taxCode, MiscUtil.sum((BigDecimal[])new BigDecimal[]{amnt, tax.getTaxAmount()}));
            }
            for (com.gridnine.xtrip.common.model.booking.air.Tax tax : product.getPreviousProduct().getTaxes()) {
                com.gridnine.xtrip.common.model.booking.air.Tax newTax = new com.gridnine.xtrip.common.model.booking.air.Tax();
                newTax.setCode(tax.getCode() == null ? "" : tax.getCode());
                newTax.setEquivalentAmount(tax.getEquivalentAmount());
                product.getTaxes().add(newTax);
                BigDecimal addAmnt = (BigDecimal)surplus.get(newTax.getCode());
                if (addAmnt == null) continue;
                newTax.setEquivalentAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{tax.getEquivalentAmount(), addAmnt}));
                surplus.remove(newTax.getCode());
            }
        } else {
            for (Tax item : airFile.getFare().getAllTaxes()) {
                com.gridnine.xtrip.common.model.booking.air.Tax tax;
                tax = new com.gridnine.xtrip.common.model.booking.air.Tax();
                tax.setCode(item.getTaxCode());
                tax.setEquivalentAmount(item.getTaxAmount());
                product.getTaxes().add(tax);
            }
        }
        BigDecimal baseFareValue = airFile.getFare().getBaseFare();
        String baseFareCurrencyCode = airFile.getFare().getBaseCurrencyCode();
        BigDecimal equivalentFareValue = airFile.getFare().getEquivalentFare();
        String equivalentFareCurrencyCode = AmadeusParserHelper.getGdsCurrency(airFile, AmadeusParserHelper.getGdsName(ctx));
        if (!exchange && MiscUtil.equals((Object)equivalentFareCurrencyCode, (Object)baseFareCurrencyCode) && MiscUtil.isZero((BigDecimal)baseFareValue, (boolean)true) && !MiscUtil.isZero((BigDecimal)equivalentFareValue, (boolean)true)) {
            baseFareValue = equivalentFareValue;
        }
        if (MiscUtil.equals((Object)equivalentFareCurrencyCode, (Object)baseFareCurrencyCode)) {
            AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)baseFareValue);
        } else if (exchange && airFile.getFare().getFareCollectedAmount() != null && MiscUtil.equals((Object)product.getPreviousProduct().getGdsCurrency(), (Object)airFile.getFare().getFareCollectedAmount().getCurrency())) {
            previousEquivalentFare = MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)product.getPreviousProduct()));
            AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)previousEquivalentFare.add(airFile.getFare().getFareCollectedAmount().getValue()));
        } else if (!smartTickettingMode && exchange && airFile.getFare().getTotalAmount() != null && MiscUtil.equals((Object)product.getPreviousProduct().getGdsCurrency(), (Object)airFile.getFare().getTotalCurrencyCode()) && product.getPreviousProduct().getTicketType() != TicketType.FAKE) {
            totalAmount = (BigDecimal)ctx.getObject((Enum)IBusAmadeusParserContextKeys.TOTAL_TICKET_AMOUNT);
            AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)MiscUtil.sub((BigDecimal)totalAmount, (BigDecimal[])new BigDecimal[]{AirProductTaxHelper.getEquivalentTaxesAmount((Product)product), product.getPenalty()}));
        } else if (equivalentFareValue != null) {
            if (exchange) {
                previousEquivalentFare = MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)product.getPreviousProduct()));
                AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)equivalentFareValue.add(previousEquivalentFare));
            } else {
                AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)equivalentFareValue);
            }
        } else {
            totalAmount = (BigDecimal)ctx.getObject((Enum)IBusAmadeusParserContextKeys.TOTAL_TICKET_AMOUNT);
            if (totalAmount != null) {
                AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)MiscUtil.sub((BigDecimal)totalAmount, (BigDecimal[])new BigDecimal[]{AirProductTaxHelper.getEquivalentTaxesAmount((Product)product), product.getPenalty()}));
            }
        }
        if (exchange) {
            this.fillAddCollectValues(product);
        }
        if (baseFareValue != null && !TextUtil.isBlank((String)baseFareCurrencyCode)) {
            baseFare = new Money();
            baseFare.setCurrency(baseFareCurrencyCode);
            baseFare.setValue(baseFareValue);
            AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        } else if (equivalentFareValue != null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0431\u0430\u0437\u043e\u0432\u044b\u0439 \u0442\u0430\u0440\u0438\u0444, \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0431\u0430\u0437\u043e\u0432\u043e\u0433\u043e \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d \u044d\u043a\u0432\u0438\u0432\u0430\u043b\u0435\u043d\u0442\u043d\u044b\u0439", (Object[])new Object[0]));
            baseFare = new Money();
            baseFare.setCurrency(equivalentFareCurrencyCode);
            baseFare.setValue(equivalentFareValue);
            AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        }
        if (exchange && !smartTickettingMode && this.isBaseAndEquivFaresMissingOrCurrencyCodeDiffers(airFile.getFare(), product.getPreviousProduct().getGdsCurrency())) {
            if (this.isCurrencyCodeDiffersAndDoborPresent(airFile.getFare(), product.getPreviousProduct().getGdsCurrency(), product.getPreviousProduct())) {
                BigDecimal dobor = MiscUtil.guarded((BigDecimal)AirProductHelper.getTotalEquivalentFare((Product)product.getPreviousProduct())).subtract(MiscUtil.guarded((BigDecimal)AirProductTaxHelper.getEquivalentTaxesAmount((Product)product.getPreviousProduct())));
                AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)product.getPreviousProduct())).add(dobor));
            } else {
                AirProductHelper.setBaseFare((Product)product, (Money)AirProductHelper.getBaseFare((Product)product.getPreviousProduct()));
                AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)AirProductHelper.getEquivalentFare((Product)product.getPreviousProduct()));
            }
        }
        if (AirProductHelper.isBSPTicket((Product)product)) {
            Double bspCommissionRate = null;
            BigDecimal bspCommissionValue = null;
            if (exchange) {
                if (ticketData.getCommissionValue() != null) {
                    bspCommissionValue = ticketData.getCommissionValue();
                } else if (ticketData.getCommissionRate() != null) {
                    bspCommissionRate = ticketData.getCommissionRate();
                    BigDecimal addCollect = MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)product)).subtract(MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)product.getPreviousProduct())));
                    bspCommissionValue = addCollect.compareTo(BigDecimal.ZERO) > 0 ? addCollect.multiply(BigDecimal.valueOf(ticketData.getCommissionRate())).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                }
            } else if (ticketData.getCommissionRate() != null) {
                bspCommissionRate = ticketData.getCommissionRate();
                BigDecimal equivalentFare = AirProductHelper.getEquivalentFare((Product)product);
                if (equivalentFare != null) {
                    bspCommissionValue = equivalentFare.multiply(BigDecimal.valueOf(ticketData.getCommissionRate())).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
                }
            } else if (ticketData.getCommissionValue() != null) {
                bspCommissionValue = ticketData.getCommissionValue();
            }
            if (bspCommissionRate != null) {
                product.setBspCommissionRate(bspCommissionRate);
            }
            if (bspCommissionValue != null) {
                String equivalentCurrency = product.getGdsCurrency();
                product.setBspCommissionValue(MoneyHelper.buildMoney((BigDecimal)bspCommissionValue, (String)equivalentCurrency));
            }
        }
    }

    private void fillAddCollectValues(Product product) {
        BigDecimal fareAdd = MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)product)).subtract(MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)product.getPreviousProduct())));
        product.setAddCollectEquivalent(fareAdd);
        ArrayList<com.gridnine.xtrip.common.model.booking.air.Tax> oldTaxes = new ArrayList<com.gridnine.xtrip.common.model.booking.air.Tax>(product.getPreviousProduct().getTaxes());
        List<com.gridnine.xtrip.common.model.booking.air.Tax> newTaxes = product.getTaxes().stream().filter(newTax -> {
            com.gridnine.xtrip.common.model.booking.air.Tax sameOldTax = oldTaxes.stream().filter(oldTax -> TextUtil.isSame((String)newTax.getCode(), (String)oldTax.getCode()) && MiscUtil.equals((Object)oldTax.getEquivalentAmount(), (Object)newTax.getEquivalentAmount())).findFirst().orElse(null);
            oldTaxes.remove(sameOldTax);
            return sameOldTax == null;
        }).collect(Collectors.toList());
        Map<String, BigDecimal> oldTaxesSums = this.collectEquivalentSums(oldTaxes);
        Map<String, BigDecimal> newTaxesSums = this.collectEquivalentSums(newTaxes);
        for (Map.Entry<String, BigDecimal> newTaxesEntry : newTaxesSums.entrySet()) {
            BigDecimal newTaxesSum;
            BigDecimal oldTaxesSum = MiscUtil.guarded((BigDecimal)oldTaxesSums.get(newTaxesEntry.getKey()));
            if (!MiscUtil.equals((Object)oldTaxesSum, (Object)(newTaxesSum = MiscUtil.guarded((BigDecimal)newTaxesEntry.getValue())))) continue;
            oldTaxes.removeIf(newTax -> TextUtil.isSame((String)newTax.getCode(), (String)((String)newTaxesEntry.getKey())));
            newTaxes.removeIf(newTax -> TextUtil.isSame((String)newTax.getCode(), (String)((String)newTaxesEntry.getKey())));
        }
        newTaxes.forEach(newTax -> {
            com.gridnine.xtrip.common.model.booking.air.Tax oldTaxWithSameCode = oldTaxes.stream().filter(oldTax -> TextUtil.isSame((String)newTax.getCode(), (String)oldTax.getCode())).findFirst().orElse(null);
            oldTaxes.remove(oldTaxWithSameCode);
            if (oldTaxWithSameCode != null) {
                BigDecimal difference = MiscUtil.guarded((BigDecimal)newTax.getEquivalentAmount()).subtract(MiscUtil.guarded((BigDecimal)oldTaxWithSameCode.getEquivalentAmount()));
                if (!MiscUtil.isZero((BigDecimal)difference, (boolean)true)) {
                    newTax.setAddCollect(difference);
                }
            } else {
                newTax.setAddCollect(newTax.getEquivalentAmount());
            }
        });
    }

    private Map<String, BigDecimal> collectEquivalentSums(List<com.gridnine.xtrip.common.model.booking.air.Tax> taxes) {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        for (com.gridnine.xtrip.common.model.booking.air.Tax tax : taxes) {
            String taxCode = tax.getCode() == null ? "" : tax.getCode();
            BigDecimal amount = (BigDecimal)result.get(taxCode);
            result.put(taxCode, MiscUtil.sum((BigDecimal[])new BigDecimal[]{amount, tax.getEquivalentAmount()}));
        }
        return result;
    }

    private boolean isBaseAndEquivFaresMissingOrCurrencyCodeDiffers(Fare newFare, String equivFareCurrencyCode) {
        BigDecimal baseFare = newFare.getBaseFare();
        BigDecimal equivFare = newFare.getEquivalentFare();
        String totalCurrencyCode = newFare.getBaseCurrencyCode() != null ? newFare.getTotalCurrencyCode() : "";
        return MiscUtil.isZero((BigDecimal)baseFare, (boolean)true) && MiscUtil.isZero((BigDecimal)equivFare, (boolean)true) || MiscUtil.isZero((BigDecimal)equivFare, (boolean)true) && !totalCurrencyCode.equals(equivFareCurrencyCode);
    }

    private boolean isCurrencyCodeDiffersAndDoborPresent(Fare newFare, String equivFareCurrencyCode, Product exchangeProd) {
        BigDecimal equivFare = newFare.getEquivalentFare();
        String totalCurrencyCode = newFare.getBaseCurrencyCode() != null ? newFare.getTotalCurrencyCode() : "";
        BigDecimal dobor = MiscUtil.guarded((BigDecimal)AirProductHelper.getTotalEquivalentFare((Product)exchangeProd)).subtract(MiscUtil.guarded((BigDecimal)AirProductTaxHelper.getEquivalentTaxesAmount((Product)exchangeProd)));
        return MiscUtil.isZero((BigDecimal)equivFare, (boolean)true) && !totalCurrencyCode.equals(equivFareCurrencyCode) && dobor.compareTo(BigDecimal.ZERO) > 0;
    }
}

