/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.List;

public class AmadeusCreateInsuranceAccidentFopsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        InsuranceAccident product = (InsuranceAccident)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        List fops = (List)ctx.getObject((Enum)IBusParsersContextKeys.FOPS_DATA);
        VatAmount price = HandlersRegistry.get().findProductHandler(InsuranceAccident.class).calculateProductPrice((BaseProduct)product, ContractType.VENDOR);
        BigDecimal value = price == null ? BigDecimal.ZERO : price.getTotal();
        List vendorFops = InsuranceAccidentHelper.getVendorContractRelation((InsuranceAccident)product).getFops();
        vendorFops.clear();
        if (fops == null || fops.isEmpty()) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0444\u043e\u0440\u043c\u0430\u0445 \u043e\u043f\u043b\u0430\u0442\u044b, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u041d\u0410\u041b", (Object[])new Object[0]));
            GeneralProductFop fop = new GeneralProductFop();
            fop.setType(PaymentType.CASH);
            fop.setOperationDate(product.getIssueDate());
            fop.setEquivalentAmount(value);
            vendorFops.add(fop);
            return;
        }
        for (FopItem item : fops) {
            GeneralProductFop fop = new GeneralProductFop();
            fop.setType(item.getPaymentType());
            Money money = new Money();
            money.setCurrency(DictHelper.getEquivCurrency());
            if (item.getAmount() == null) {
                fop.setEquivalentAmount(fops.size() == 1 ? value : BigDecimal.ZERO);
            } else {
                fop.setEquivalentAmount(item.getAmount());
            }
            if (PaymentType.MTD.equals((Object)item.getPaymentType())) {
                fop.setEquivalentAmount(value);
                fop.setPassengerStatus(item.getPassengerStatus());
                fop.setRelatedTicketNumber(item.getDetails());
            }
            fop.setOperationDate(product.getIssueDate());
            vendorFops.add(fop);
        }
    }
}

