/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.CalculationLineParsingResult;
import com.gridnine.xtrip.common.parsers.model.CalculationLineSegmentParsingResult;
import com.gridnine.xtrip.common.parsers.model.CalculationLineSegmentTariffParsingResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketedAirSegment;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers2.common.Parsers2GeneralHelper;
import com.gridnine.xtrip.server.parsers2.common.avia.Parsers2AviaHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class AmadeusCreateSegmentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AirFile airFile = (AirFile)ctx.getObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        CalculationLineParsingResult parsingResult = (CalculationLineParsingResult)ctx.getObject((Enum)IBusParsersContextKeys.CALCULATION_LINE_PARSING_RESULT);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        if (this.isUseSegmentsInfoOnly(airFile, parsingResult)) {
            this.processSegmentsInfoOnly(airFile, product, ctx);
            return;
        }
        this.updateSegmentInfoByCalculationLine(airFile, parsingResult, product, ctx);
    }

    private void processSegmentsInfoOnly(AirFile airFile, Product product, MessageContext ctx) {
        int segNo = 0;
        List fareBasisCodes = airFile.getFare().getFareBasisCodes();
        for (TicketedAirSegment segmentData : airFile.getTicketedAirSegments()) {
            ++segNo;
            if (this.isVoidSegment(segmentData)) continue;
            SegmentTariff segmentTariff = new SegmentTariff();
            product.getSegmentTariffs().add(segmentTariff);
            Segment segment = new Segment();
            segmentTariff.getSegments().add(segment);
            segment.setAirlineLocator(airFile.getHeader().getNsRecordLocator());
            DictionaryReference departureLocation = Parsers2AviaHelper.findAirport((String)segmentData.getOriginAirportCode(), (int)segNo, (MessageContext)ctx);
            segment.setDepartureLocation(departureLocation);
            DictionaryReference arrivalLocation = Parsers2AviaHelper.findAirport((String)segmentData.getDestinationAirportCode(), (int)segNo, (MessageContext)ctx);
            segment.setArriveLocation(arrivalLocation);
            segment.setAirline(Parsers2GeneralHelper.findAirline((String)segmentData.getAirlineCode(), (int)segNo, (MessageContext)ctx));
            if (TextUtil.nonBlank((String)segmentData.getCodeShareCarrier())) {
                segment.setCodeShareCarrier(Parsers2GeneralHelper.findAirline((String)segmentData.getCodeShareCarrier(), (int)segNo, (MessageContext)ctx));
            } else {
                segment.setCodeShareCarrier(Parsers2GeneralHelper.findAirline((String)segmentData.getAirlineCode(), (int)segNo, (MessageContext)ctx));
            }
            segment.setClassOfSvcCode(segmentData.getClassOfService());
            if (fareBasisCodes.size() < segNo) {
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0430 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c farebasis", (Object[])new Object[]{Integer.toString(segNo)}));
            } else {
                segment.setFareBasis((String)fareBasisCodes.get(segNo - 1));
            }
            segment.setFlightNo(segmentData.getFlightNumber());
            segment.setStartDate(segmentData.getDeparture());
            segment.setEndDate(segmentData.getArrival());
            segment.setRecordNumber(segNo);
            segment.setLuggageInfo(AirProductHelper.parseLuggageInfo((String)segmentData.getBaggageAllowance()));
        }
    }

    private void updateSegmentInfoByCalculationLine(AirFile airFile, CalculationLineParsingResult parsingResult, Product product, MessageContext ctx) throws Exception {
        String calculationCurrencyCode = parsingResult.getCalculationCurrencyCode();
        boolean ignoreFares = false;
        ArrayList<ProductFare> fares = new ArrayList<ProductFare>();
        int idx = 0;
        int segNo = 0;
        int voidSegNo = 0;
        List airSegments = airFile.getTicketedAirSegments();
        List fareBasisCodes = airFile.getFare().getFareBasisCodes();
        block0: for (CalculationLineSegmentTariffParsingResult st : parsingResult.getSegmentTariffs()) {
            Money money;
            String currencyCode = st.getCurrencyCode() == null ? calculationCurrencyCode : st.getCurrencyCode();
            SegmentTariff segmentTariff = new SegmentTariff();
            product.getSegmentTariffs().add(segmentTariff);
            ProductFare fare = new ProductFare();
            fares.add(fare);
            fare.setSegmentTariff(segmentTariff);
            BigDecimal tariff = st.getTariff();
            if (currencyCode == null || tariff == null) {
                ignoreFares = true;
            } else if ("NUC".equals(currencyCode)) {
                fare.setNucFare(tariff);
                fare.setRoe(parsingResult.getRoe());
            } else if (DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB").equals(currencyCode)) {
                fare.setEquivalentFare(tariff);
                money = new Money();
                money.setCurrency(DictHelper.getEquivCurrency());
                money.setValue(tariff);
                fare.setBaseFare(money);
            } else {
                money = new Money();
                money.setCurrency(currencyCode);
                money.setValue(tariff);
                fare.setBaseFare(money);
            }
            for (CalculationLineSegmentParsingResult seg : st.getSegments()) {
                if (airSegments.size() > segNo) {
                    TicketedAirSegment segmentData = (TicketedAirSegment)airSegments.get(segNo);
                    ++segNo;
                    if (this.isVoidSegment(segmentData)) {
                        ++voidSegNo;
                        if (airSegments.size() <= segNo) {
                            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0447\u0438\u0442\u0430\u0442\u044c \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u043d\u0443\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e", (Object[])new Object[0]));
                            continue block0;
                        }
                        segmentData = (TicketedAirSegment)airSegments.get(segNo);
                        ++segNo;
                    }
                    Segment segment = new Segment();
                    segmentTariff.getSegments().add(segment);
                    segment.setAirlineLocator(airFile.getHeader().getNsRecordLocator());
                    DictionaryReference departureLocation = Parsers2AviaHelper.findAirport((String)segmentData.getOriginAirportCode(), (int)segNo, (MessageContext)ctx);
                    segment.setDepartureLocation(departureLocation);
                    DictionaryReference arrivalLocation = Parsers2AviaHelper.findAirport((String)segmentData.getDestinationAirportCode(), (int)segNo, (MessageContext)ctx);
                    segment.setArriveLocation(arrivalLocation);
                    segment.setAirline(Parsers2GeneralHelper.findAirline((String)segmentData.getAirlineCode(), (int)segNo, (MessageContext)ctx));
                    if (TextUtil.nonBlank((String)segmentData.getCodeShareCarrier())) {
                        segment.setCodeShareCarrier(Parsers2GeneralHelper.findAirline((String)segmentData.getCodeShareCarrier(), (int)segNo, (MessageContext)ctx));
                    } else {
                        segment.setCodeShareCarrier(Parsers2GeneralHelper.findAirline((String)segmentData.getAirlineCode(), (int)segNo, (MessageContext)ctx));
                    }
                    segment.setClassOfSvcCode(segmentData.getClassOfService());
                    if (fareBasisCodes.size() < segNo - voidSegNo) {
                        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0430 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c farebasis", (Object[])new Object[]{Integer.toString(segNo)}));
                    } else {
                        segment.setFareBasis((String)fareBasisCodes.get(segNo - voidSegNo - 1));
                    }
                    segment.setFlightNo(segmentData.getFlightNumber());
                    segment.setStartDate(segmentData.getDeparture());
                    segment.setEndDate(segmentData.getArrival());
                    segment.setRecordNumber(segNo);
                    segment.setLuggageInfo(AirProductHelper.parseLuggageInfo((String)segmentData.getBaggageAllowance()));
                } else {
                    ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u043f\u043e\u043b\u0435\u0442\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u043f\u0438\u0441\u044c \u043f\u043e \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0443 {0}", (Object[])new Object[]{Integer.toString(idx + 1)}));
                }
                ++idx;
            }
        }
        if (!ignoreFares) {
            product.getFares().addAll(fares);
        }
    }

    private boolean isUseSegmentsInfoOnly(AirFile airFile, CalculationLineParsingResult parsingResult) {
        int count1 = 0;
        for (CalculationLineSegmentTariffParsingResult st : parsingResult.getSegmentTariffs()) {
            count1 += st.getSegments().size();
        }
        int count2 = 0;
        for (TicketedAirSegment item : airFile.getTicketedAirSegments()) {
            if (this.isVoidSegment(item)) continue;
            ++count2;
        }
        return count2 != count1;
    }

    private boolean isVoidSegment(TicketedAirSegment item) {
        return "VOID".equals(item.getAirlineCode());
    }
}

